/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import jade.JadeClassLoader;
import jade.lang.acl.ACLMessage;
import jade.tools.gui.ACLSLTokenMarker;
import jade.tools.gui.ACLSyntaxDocument;
import jade.tools.gui.ACLSytntaxStyle;
import jade.tools.gui.ACLTextAreaPainter;
import jade.tools.gui.ACLToken;
import jade.tools.sl.SLFormatter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public class ACLTextArea
extends JComponent {
    protected static String CENTER = "center";
    protected static String RIGHT = "right";
    protected static String BOTTOM = "bottom";
    protected static ACLTextArea focusedComponent;
    protected static Timer caretTimer;
    protected ACLTextAreaPainter painter;
    protected JPopupMenu popup;
    protected Timer scrollTimer;
    protected EventListenerList listenerList;
    protected MutableCaretEvent caretEvent;
    protected boolean caretBlinks;
    protected boolean caretVisible;
    protected boolean blink;
    protected boolean editable;
    protected int firstLine;
    protected int visibleLines;
    protected int electricScroll;
    protected int horizontalOffset;
    protected JScrollBar vertical;
    protected JScrollBar horizontal;
    protected boolean scrollBarsInitialized;
    protected InputHandler inputHandler;
    protected ACLSyntaxDocument document;
    protected DocumentHandler documentHandler;
    protected Segment lineSegment;
    protected int selectionStart;
    protected int selectionStartLine;
    protected int selectionEnd;
    protected int selectionEndLine;
    protected boolean biasLeft;
    protected int bracketPosition;
    protected int bracketLine;
    protected int magicCaret;
    protected boolean overwrite;
    private String contentLanguage = "";
    private ACLMessage msg;
    private String fieldName;

    public ACLTextArea() {
        this.enableEvents(8L);
        this.painter = new ACLTextAreaPainter(this);
        AutoScroll scroller = new AutoScroll();
        this.scrollTimer = new Timer(200, scroller);
        this.documentHandler = new DocumentHandler();
        this.listenerList = new EventListenerList();
        this.caretEvent = new MutableCaretEvent();
        this.lineSegment = new Segment();
        this.bracketPosition = -1;
        this.bracketLine = -1;
        this.blink = true;
        caretTimer = new Timer(500, new CaretBlinker());
        caretTimer.setInitialDelay(500);
        caretTimer.start();
        this.setBorder(new EtchedBorder(1));
        this.setLayout(new BorderLayout());
        this.add((Component)this.painter, "Center");
        this.vertical = new JScrollBar(1);
        this.add((Component)this.vertical, "East");
        this.horizontal = new JScrollBar(0);
        this.add((Component)this.horizontal, "South");
        this.vertical.addAdjustmentListener(new AdjustHandler());
        this.horizontal.addAdjustmentListener(new AdjustHandler());
        this.painter.addComponentListener(new ComponentHandler());
        this.painter.addMouseListener(new MouseHandler());
        this.painter.addMouseMotionListener(scroller);
        this.addFocusListener(new FocusHandler());
        InputHandler DEFAULT_INPUT_HANDLER = new InputHandler();
        DEFAULT_INPUT_HANDLER.addDefaultKeyBindings();
        this.setInputHandler(DEFAULT_INPUT_HANDLER);
        this.setDocument(new ACLSyntaxDocument());
        this.editable = true;
        this.caretVisible = true;
        this.caretBlinks = true;
        this.electricScroll = 3;
        focusedComponent = this;
        this.setTokenMarker(new ACLSLTokenMarker());
    }

    @Override
    public final boolean isManagingFocus() {
        return true;
    }

    public final ACLTextAreaPainter getPainter() {
        return this.painter;
    }

    public final InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public final boolean isCaretBlinkEnabled() {
        return this.caretBlinks;
    }

    public final boolean isCaretVisible() {
        return (!this.caretBlinks || this.blink) && this.caretVisible;
    }

    public final int getElectricScroll() {
        return this.electricScroll;
    }

    public final int getFirstLine() {
        return this.firstLine;
    }

    public final int getVisibleLines() {
        return this.visibleLines;
    }

    public final int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public final ACLSyntaxDocument getDocument() {
        return this.document;
    }

    public final ACLSLTokenMarker getTokenMarker() {
        return this.document.getTokenMarker();
    }

    public final int getDocumentLength() {
        return this.document.getLength();
    }

    public final int getLineCount() {
        return this.document.getDefaultRootElement().getElementCount();
    }

    public final int getLineOfOffset(int offset) {
        return this.document.getDefaultRootElement().getElementIndex(offset);
    }

    public final String getText(int start, int len) {
        try {
            return this.document.getText(start, len);
        }
        catch (BadLocationException bl) {
            return null;
        }
    }

    public final void getText(int start, int len, Segment segment) {
        try {
            this.document.getText(start, len, segment);
        }
        catch (BadLocationException bl) {
            segment.count = 0;
            segment.offset = 0;
        }
    }

    public final String getLineText(int lineIndex) {
        int start = this.getLineStartOffset(lineIndex);
        return this.getText(start, this.getLineEndOffset(lineIndex) - start - 1);
    }

    public final void getLineText(int lineIndex, Segment segment) {
        int start = this.getLineStartOffset(lineIndex);
        this.getText(start, this.getLineEndOffset(lineIndex) - start - 1, segment);
    }

    public final int getSelectionStart() {
        return this.selectionStart;
    }

    public final int getSelectionStartLine() {
        return this.selectionStartLine;
    }

    public final int getSelectionEnd() {
        return this.selectionEnd;
    }

    public final int getSelectionEndLine() {
        return this.selectionEndLine;
    }

    public final int getCaretPosition() {
        return this.biasLeft ? this.selectionStart : this.selectionEnd;
    }

    public final int getCaretLine() {
        return this.biasLeft ? this.selectionStartLine : this.selectionEndLine;
    }

    public final int getMarkPosition() {
        return this.biasLeft ? this.selectionEnd : this.selectionStart;
    }

    public final int getMarkLine() {
        return this.biasLeft ? this.selectionEndLine : this.selectionStartLine;
    }

    public final String getSelectedText() {
        if (this.selectionStart == this.selectionEnd) {
            return null;
        }
        return this.getText(this.selectionStart, this.selectionEnd - this.selectionStart);
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final JPopupMenu getRightClickPopup() {
        return this.popup;
    }

    public final int getMagicCaretPosition() {
        return this.magicCaret;
    }

    public final boolean isOverwriteEnabled() {
        return this.overwrite;
    }

    public final int getBracketPosition() {
        return this.bracketPosition;
    }

    public final int getBracketLine() {
        return this.bracketLine;
    }

    public final void setElectricScroll(int electricScroll) {
        this.electricScroll = electricScroll;
    }

    public final void setTokenMarker(ACLSLTokenMarker tokenMarker) {
        this.document.setTokenMarker(tokenMarker);
    }

    public final void setSelectionStart(int selectionStart) {
        this.select(selectionStart, this.selectionEnd);
    }

    public final void setSelectionEnd(int selectionEnd) {
        this.select(this.selectionStart, selectionEnd);
    }

    public final void setCaretPosition(int caret) {
        this.select(caret, caret);
    }

    public final void setEditable(boolean editable) {
        this.editable = editable;
    }

    public final void setRightClickPopup(JPopupMenu popup) {
        this.popup = popup;
    }

    public final void setMagicCaretPosition(int magicCaret) {
        this.magicCaret = magicCaret;
    }

    public final void setOverwriteEnabled(boolean overwrite2) {
        this.overwrite = overwrite2;
        this.painter.invalidateSelectedLines();
    }

    public final void blinkCaret() {
        if (this.caretBlinks) {
            this.blink = !this.blink;
            this.painter.invalidateSelectedLines();
        } else {
            this.blink = true;
        }
    }

    public final void recalculateVisibleLines() {
        if (this.painter == null) {
            return;
        }
        int height = this.painter.getHeight();
        int lineHeight = this.painter.getFontMetrics().getHeight();
        this.visibleLines = height / lineHeight;
        this.painter.invalidateOffscreen();
        this.painter.repaint();
        this.updateScrollBars();
    }

    public final void selectAll() {
        this.select(0, this.getDocumentLength());
    }

    public final void addCaretListener(CaretListener listener) {
        this.listenerList.add(CaretListener.class, listener);
    }

    public final void removeCaretListener(CaretListener listener) {
        this.listenerList.remove(CaretListener.class, listener);
    }

    public int getLineStartOffset(int line) {
        Element lineElement = this.document.getDefaultRootElement().getElement(line);
        if (lineElement == null) {
            return -1;
        }
        return lineElement.getStartOffset();
    }

    public int getLineEndOffset(int line) {
        Element lineElement = this.document.getDefaultRootElement().getElement(line);
        if (lineElement == null) {
            return -1;
        }
        return lineElement.getEndOffset();
    }

    public int getLineLength(int line) {
        Element lineElement = this.document.getDefaultRootElement().getElement(line);
        if (lineElement == null) {
            return -1;
        }
        return lineElement.getEndOffset() - lineElement.getStartOffset() - 1;
    }

    public String getText() {
        try {
            return this.document.getText(0, this.document.getLength());
        }
        catch (BadLocationException bl) {
            return null;
        }
    }

    public void setInputHandler(InputHandler inputHandler) {
        if (this.inputHandler != null) {
            this.removeKeyListener(this.inputHandler);
        }
        if (inputHandler != null) {
            this.addKeyListener(inputHandler);
        }
        this.inputHandler = inputHandler;
    }

    public void setCaretBlinkEnabled(boolean caretBlinks) {
        this.caretBlinks = caretBlinks;
        if (!caretBlinks) {
            this.blink = false;
        }
        this.painter.invalidateSelectedLines();
    }

    public void setCaretVisible(boolean caretVisible) {
        this.caretVisible = caretVisible;
        this.blink = true;
        this.painter.invalidateSelectedLines();
    }

    public void setFirstLine(int firstLine) {
        if (firstLine == this.firstLine) {
            return;
        }
        int oldFirstLine = this.firstLine;
        this.firstLine = firstLine;
        if (firstLine != this.vertical.getValue()) {
            this.updateScrollBars();
        }
        this.painter.scrollRepaint(oldFirstLine, firstLine);
        this.painter.repaint();
    }

    public void setHorizontalOffset(int horizontalOffset) {
        if (horizontalOffset == this.horizontalOffset) {
            return;
        }
        this.horizontalOffset = horizontalOffset;
        if (horizontalOffset != this.horizontal.getValue()) {
            this.updateScrollBars();
        }
        this.painter.invalidateLineRange(this.firstLine, this.firstLine + this.visibleLines);
        this.painter.repaint();
    }

    public boolean setOrigin(int firstLine, int horizontalOffset) {
        boolean changed = false;
        boolean fullRepaint = false;
        int oldFirstLine = this.firstLine;
        if (horizontalOffset != this.horizontalOffset) {
            this.horizontalOffset = horizontalOffset;
            fullRepaint = true;
            changed = true;
        }
        if (firstLine != this.firstLine) {
            this.firstLine = firstLine;
            changed = true;
        }
        if (changed) {
            this.updateScrollBars();
            if (fullRepaint) {
                this.painter._invalidateLineRange(firstLine, firstLine + this.visibleLines);
            } else {
                this.painter.scrollRepaint(oldFirstLine, firstLine);
            }
            this.painter.repaint();
        }
        return changed;
    }

    public void setDocument(ACLSyntaxDocument document) {
        if (this.document == document) {
            return;
        }
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentHandler);
        }
        this.document = document;
        document.addDocumentListener(this.documentHandler);
        this.select(0, 0);
        this.updateScrollBars();
        this.painter.invalidateOffscreen();
        this.painter.repaint();
    }

    public void setText(String text) {
        try {
            this.document.remove(0, this.document.getLength());
            this.document.insertString(0, text, null);
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
        }
    }

    public void setSelectedText(String selectedText) {
        if (!this.editable) {
            throw new InternalError("Text component read only");
        }
        try {
            this.document.remove(this.selectionStart, this.selectionEnd - this.selectionStart);
            this.document.insertString(this.selectionStart, selectedText, null);
            this.setCaretPosition(this.selectionEnd);
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
            throw new InternalError("Cannot replace selection");
        }
    }

    public void update() {
        this.register(this.msg, "Content");
    }

    public void register(Object arg, String fieldName) {
        this.msg = (ACLMessage)arg;
        this.fieldName = fieldName;
        this.contentLanguage = this.msg.getLanguage() != null ? this.msg.getLanguage() : "<unknown>";
        String methodName = "get" + fieldName;
        String content = "";
        try {
            Method sn = this.msg.getClass().getMethod(methodName, null);
            content = (String)sn.invoke((Object)this.msg, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.contentLanguage.indexOf("SL") >= 0) {
            try {
                content = SLFormatter.format(content);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        while (content != null && content.indexOf(10) == 0) {
            content = content.substring(1);
        }
        this.setText(content);
        this.setCaretPosition(0);
    }

    public void unregister(Object arg, String str) {
    }

    public void focusLost(FocusEvent e) {
        String value;
        for (value = this.getText(); value != null && (value.indexOf(10) == 0 || value.indexOf(32) == 0); value = value.substring(1)) {
        }
        String methodName = "set" + this.fieldName;
        String theType = "java.lang.String";
        try {
            Method sn = this.msg.getClass().getMethod(methodName, JadeClassLoader.forName(theType));
            String os = value;
            sn.invoke((Object)this.msg, os);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateScrollBars() {
        if (this.vertical != null && this.visibleLines != 0) {
            this.vertical.setValues(this.firstLine, this.visibleLines, 0, this.getLineCount());
            this.vertical.setUnitIncrement(2);
            this.vertical.setBlockIncrement(this.visibleLines);
        }
        int width = this.painter.getWidth();
        if (this.horizontal != null && width != 0) {
            this.horizontal.setValues(-this.horizontalOffset, width, 0, width * 5);
            this.horizontal.setUnitIncrement(this.painter.getFontMetrics().charWidth('w'));
            this.horizontal.setBlockIncrement(width / 2);
        }
    }

    public boolean scrollToCaret() {
        int line = this.getCaretLine();
        int lineStart = this.getLineStartOffset(line);
        int offset = Math.max(0, Math.min(this.getLineLength(line) - 1, this.getCaretPosition() - lineStart));
        return this.scrollTo(line, offset);
    }

    public boolean scrollTo(int line, int offset) {
        if (this.visibleLines == 0) {
            this.setFirstLine(Math.max(0, line - this.electricScroll));
            return true;
        }
        int newFirstLine = this.firstLine;
        int newHorizontalOffset = this.horizontalOffset;
        if (line < this.firstLine + this.electricScroll) {
            newFirstLine = Math.max(0, line - this.electricScroll);
        } else if (line + this.electricScroll >= this.firstLine + this.visibleLines) {
            newFirstLine = line - this.visibleLines + this.electricScroll + 1;
            if (newFirstLine + this.visibleLines >= this.getLineCount()) {
                newFirstLine = this.getLineCount() - this.visibleLines;
            }
            if (newFirstLine < 0) {
                newFirstLine = 0;
            }
        }
        int x = this.offsetToX(line, offset);
        int width = this.painter.getFontMetrics().charWidth('W');
        if (x < 0) {
            newHorizontalOffset = Math.min(0, this.horizontalOffset - x + width);
        } else if (x + width >= this.painter.getWidth()) {
            newHorizontalOffset = this.horizontalOffset + (this.painter.getWidth() - x) - width;
        }
        return this.setOrigin(newFirstLine, newHorizontalOffset);
    }

    public int lineToY(int line) {
        FontMetrics fm = this.painter.getFontMetrics();
        return (line - this.firstLine) * fm.getHeight() - (fm.getLeading() + fm.getMaxDescent());
    }

    public int yToLine(int y) {
        FontMetrics fm = this.painter.getFontMetrics();
        int height = fm.getHeight();
        return Math.max(0, Math.min(this.getLineCount() - 1, y / height + this.firstLine));
    }

    public int offsetToX(int line, int offset) {
        ACLToken tokens;
        ACLSLTokenMarker tokenMarker = this.getTokenMarker();
        FontMetrics fm = this.painter.getFontMetrics();
        this.getLineText(line, this.lineSegment);
        int segmentOffset = this.lineSegment.offset;
        int x = this.horizontalOffset;
        if (tokenMarker == null) {
            this.lineSegment.count = offset;
            return x + Utilities.getTabbedTextWidth(this.lineSegment, fm, x, (TabExpander)this.painter, 0);
        }
        if (this.painter.currentLineIndex == line) {
            tokens = this.painter.currentLineTokens;
        } else {
            this.painter.currentLineIndex = line;
            tokens = this.painter.currentLineTokens = tokenMarker.markTokens(this.lineSegment, line);
        }
        Font defaultFont = this.painter.getFont();
        ACLSytntaxStyle[] styles = this.painter.getStyles();
        byte id;
        while ((id = tokens.id) != 127) {
            fm = id == 0 ? this.painter.getFontMetrics() : styles[id].getFontMetrics(defaultFont);
            int length = tokens.length;
            if (offset + segmentOffset < this.lineSegment.offset + length) {
                this.lineSegment.count = offset - (this.lineSegment.offset - segmentOffset);
                return x + Utilities.getTabbedTextWidth(this.lineSegment, fm, x, (TabExpander)this.painter, 0);
            }
            this.lineSegment.count = length;
            x += Utilities.getTabbedTextWidth(this.lineSegment, fm, x, (TabExpander)this.painter, 0);
            this.lineSegment.offset += length;
            tokens = tokens.next;
        }
        return x;
    }

    public int xToOffset(int line, int x) {
        ACLToken tokens;
        ACLSLTokenMarker tokenMarker = this.getTokenMarker();
        FontMetrics fm = this.painter.getFontMetrics();
        this.getLineText(line, this.lineSegment);
        char[] segmentArray = this.lineSegment.array;
        int segmentOffset = this.lineSegment.offset;
        int segmentCount = this.lineSegment.count;
        int width = this.horizontalOffset;
        if (tokenMarker == null) {
            for (int i = 0; i < segmentCount; ++i) {
                char c = segmentArray[i + segmentOffset];
                int charWidth = c == '\t' ? (int)this.painter.nextTabStop(width, i) - width : fm.charWidth(c);
                if (this.painter.isBlockCaretEnabled()) {
                    if (x - charWidth <= width) {
                        return i;
                    }
                    if (x - charWidth / 2 <= width) {
                        return i;
                    }
                }
                width += charWidth;
            }
            return segmentCount;
        }
        if (this.painter.currentLineIndex == line) {
            tokens = this.painter.currentLineTokens;
        } else {
            this.painter.currentLineIndex = line;
            tokens = this.painter.currentLineTokens = tokenMarker.markTokens(this.lineSegment, line);
        }
        int offset = 0;
        Font defaultFont = this.painter.getFont();
        ACLSytntaxStyle[] styles = this.painter.getStyles();
        byte id;
        while ((id = tokens.id) != 127) {
            fm = id == 0 ? this.painter.getFontMetrics() : styles[id].getFontMetrics(defaultFont);
            int length = tokens.length;
            for (int i = 0; i < length; ++i) {
                char c = segmentArray[segmentOffset + offset + i];
                int charWidth = c == '\t' ? (int)this.painter.nextTabStop(width, offset + i) - width : fm.charWidth(c);
                if (this.painter.isBlockCaretEnabled()) {
                    if (x - charWidth <= width) {
                        return offset + i;
                    }
                    if (x - charWidth / 2 <= width) {
                        return offset + i;
                    }
                }
                width += charWidth;
            }
            offset += length;
            tokens = tokens.next;
        }
        return offset;
    }

    public int xyToOffset(int x, int y) {
        int line = this.yToLine(y);
        int start = this.getLineStartOffset(line);
        return start + this.xToOffset(line, x);
    }

    public void select(int start, int end2) {
        boolean newBias;
        int newEnd;
        int newStart;
        if (start <= end2) {
            newStart = start;
            newEnd = end2;
            newBias = false;
        } else {
            newStart = end2;
            newEnd = start;
            newBias = true;
        }
        if (newStart < 0 || newEnd > this.getDocumentLength()) {
            throw new IllegalArgumentException("Bounds out of range: " + newStart + "," + newEnd);
        }
        if (newStart != this.selectionStart || newEnd != this.selectionEnd || newBias != this.biasLeft) {
            int newStartLine = this.getLineOfOffset(newStart);
            int newEndLine = this.getLineOfOffset(newEnd);
            if (this.painter.isBracketHighlightEnabled()) {
                if (this.bracketLine != -1) {
                    this.painter._invalidateLine(this.bracketLine);
                }
                this.updateBracketHighlight(end2);
                if (this.bracketLine != -1) {
                    this.painter._invalidateLine(this.bracketLine);
                }
            }
            this.painter._invalidateLineRange(this.selectionStartLine, this.selectionEndLine);
            this.painter._invalidateLineRange(newStartLine, newEndLine);
            this.selectionStart = newStart;
            this.selectionEnd = newEnd;
            this.selectionStartLine = newStartLine;
            this.selectionEndLine = newEndLine;
            this.biasLeft = newBias;
            this.fireCaretEvent();
        }
        this.blink = true;
        caretTimer.restart();
        this.magicCaret = -1;
        if (!this.scrollToCaret()) {
            this.painter.fastRepaint();
        }
    }

    public void overwriteSetSelectedText(String str) {
        if (!this.overwrite || this.selectionStart != this.selectionEnd) {
            this.setSelectedText(str);
            return;
        }
        int caret = this.getCaretPosition();
        int caretLineEnd = this.getLineEndOffset(this.getCaretLine());
        if (caretLineEnd - caret <= str.length()) {
            this.setSelectedText(str);
            return;
        }
        try {
            this.document.remove(caret, str.length());
            this.document.insertString(caret, str, null);
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
        }
    }

    public void cut() {
        if (this.editable) {
            this.copy();
            this.setSelectedText("");
        }
    }

    public void copy() {
        if (this.selectionStart != this.selectionEnd) {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            StringSelection selection = new StringSelection(this.getSelectedText());
            clipboard.setContents(selection, null);
        }
    }

    public void paste() {
        if (this.editable) {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            try {
                String selection = (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
                this.setSelectedText(selection.replace('\r', '\n'));
            }
            catch (Exception e) {
                this.getToolkit().beep();
                System.err.println("Clipboard does not contain a string");
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (focusedComponent == this) {
            focusedComponent = null;
        }
        if (this.scrollTimer.isRunning()) {
            this.scrollTimer.stop();
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.getID() == 1005) {
            this.focusLost(e);
        }
    }

    protected void fireCaretEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; --i) {
            if (listeners[i] != CaretListener.class) continue;
            ((CaretListener)listeners[i + 1]).caretUpdate(this.caretEvent);
        }
    }

    protected void updateBracketHighlight(int newCaretPosition) {
        if (newCaretPosition == 0) {
            this.bracketLine = -1;
            this.bracketPosition = -1;
            return;
        }
        try {
            int offset = TextUtilities.findMatchingBracket(this.document, newCaretPosition - 1);
            if (offset != -1) {
                this.bracketLine = this.getLineOfOffset(offset);
                this.bracketPosition = offset - this.getLineStartOffset(this.bracketLine);
                return;
            }
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
        }
        this.bracketPosition = -1;
        this.bracketLine = -1;
    }

    protected void documentChanged(DocumentEvent evt) {
        DocumentEvent.ElementChange ch = evt.getChange(this.document.getDefaultRootElement());
        int count = ch == null ? 0 : ch.getChildrenAdded().length - ch.getChildrenRemoved().length;
        if (count == 0) {
            int line = this.getLineOfOffset(evt.getOffset());
            this.painter._invalidateLine(line);
        } else {
            int index = ch.getIndex();
            this.painter._invalidateLineRange(index, Math.max(this.getLineCount(), this.firstLine + this.visibleLines));
            this.updateScrollBars();
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            ACLTextArea.this.requestFocus();
            if ((evt.getModifiers() & 4) != 0 && ACLTextArea.this.popup != null) {
                ACLTextArea.this.popup.show(ACLTextArea.this.painter, evt.getX(), evt.getY());
                return;
            }
            int line = ACLTextArea.this.yToLine(evt.getY());
            int offset = ACLTextArea.this.xToOffset(line, evt.getX());
            int dot = ACLTextArea.this.getLineStartOffset(line) + offset;
            switch (evt.getClickCount()) {
                case 1: {
                    this.doSingleClick(evt, line, offset, dot);
                    break;
                }
                case 2: {
                    try {
                        this.doDoubleClick(evt, line, offset, dot);
                    }
                    catch (BadLocationException bl) {
                        bl.printStackTrace();
                    }
                    break;
                }
                case 3: {
                    this.doTripleClick(evt, line, offset, dot);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (ACLTextArea.this.scrollTimer.isRunning()) {
                ACLTextArea.this.scrollTimer.stop();
            }
        }

        private void doSingleClick(MouseEvent evt, int line, int offset, int dot) {
            if ((evt.getModifiers() & 1) != 0) {
                ACLTextArea.this.setSelectionEnd(dot);
            } else {
                ACLTextArea.this.setCaretPosition(dot);
            }
        }

        private void doDoubleClick(MouseEvent evt, int line, int offset, int dot) throws BadLocationException {
            if (ACLTextArea.this.getLineLength(line) == 0) {
                return;
            }
            try {
                int bracket = TextUtilities.findMatchingBracket(ACLTextArea.this.document, Math.max(0, dot - 1));
                if (bracket != -1) {
                    int mark = ACLTextArea.this.getMarkPosition();
                    if (bracket > mark) {
                        ++bracket;
                        --mark;
                    }
                    ACLTextArea.this.select(mark, bracket);
                    return;
                }
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
            }
            String lineText = ACLTextArea.this.getLineText(line);
            char ch = lineText.charAt(offset - 1);
            String noWordSep = (String)ACLTextArea.this.document.getProperty("noWordSep");
            if (noWordSep == null) {
                noWordSep = "";
            }
            boolean selectNoLetter = !Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1;
            int wordStart = 0;
            for (int i = offset - 1; i >= 0; --i) {
                ch = lineText.charAt(i);
                if (!(selectNoLetter ^ (!Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1))) continue;
                wordStart = i + 1;
                break;
            }
            int wordEnd = lineText.length();
            for (int i = offset; i < lineText.length(); ++i) {
                ch = lineText.charAt(i);
                if (!(selectNoLetter ^ (!Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1))) continue;
                wordEnd = i;
                break;
            }
            int lineStart = ACLTextArea.this.getLineStartOffset(line);
            ACLTextArea.this.select(lineStart + wordStart, lineStart + wordEnd);
        }

        private void doTripleClick(MouseEvent evt, int line, int offset, int dot) {
            ACLTextArea.this.select(ACLTextArea.this.getLineStartOffset(line), ACLTextArea.this.getLineEndOffset(line) - 1);
        }
    }

    class FocusHandler
    implements FocusListener {
        FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent evt) {
            ACLTextArea.this.setCaretVisible(true);
            focusedComponent = ACLTextArea.this;
        }

        @Override
        public void focusLost(FocusEvent evt) {
            ACLTextArea.this.setCaretVisible(false);
            focusedComponent = null;
        }
    }

    class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            int newEnd;
            int newStart;
            ACLTextArea.this.documentChanged(evt);
            int offset = evt.getOffset();
            int length = evt.getLength();
            boolean repaint = true;
            if (ACLTextArea.this.selectionStart >= offset) {
                newStart = ACLTextArea.this.selectionStart + length;
                repaint = false;
            } else {
                newStart = ACLTextArea.this.selectionStart;
            }
            if (ACLTextArea.this.selectionEnd >= offset) {
                newEnd = ACLTextArea.this.selectionEnd + length;
                repaint = false;
            } else {
                newEnd = ACLTextArea.this.selectionEnd;
            }
            ACLTextArea.this.select(newStart, newEnd);
            if (repaint) {
                ACLTextArea.this.painter.fastRepaint();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            int newEnd;
            int newStart;
            ACLTextArea.this.documentChanged(evt);
            int offset = evt.getOffset();
            int length = evt.getLength();
            boolean repaint = true;
            if (ACLTextArea.this.selectionStart > offset) {
                newStart = ACLTextArea.this.selectionStart > offset + length ? ACLTextArea.this.selectionStart - length : offset;
                repaint = false;
            } else {
                newStart = ACLTextArea.this.selectionStart;
            }
            if (ACLTextArea.this.selectionEnd > offset) {
                newEnd = ACLTextArea.this.selectionEnd > offset + length ? ACLTextArea.this.selectionEnd - length : offset;
                repaint = false;
            } else {
                newEnd = ACLTextArea.this.selectionEnd;
            }
            ACLTextArea.this.select(newStart, newEnd);
            if (repaint) {
                ACLTextArea.this.painter.fastRepaint();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
        }
    }

    class ComponentHandler
    extends ComponentAdapter {
        ComponentHandler() {
        }

        @Override
        public void componentResized(ComponentEvent evt) {
            ACLTextArea.this.recalculateVisibleLines();
            ACLTextArea.this.scrollBarsInitialized = true;
        }
    }

    class AdjustHandler
    implements AdjustmentListener {
        AdjustHandler() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent evt) {
            if (!ACLTextArea.this.scrollBarsInitialized) {
                return;
            }
            if (evt.getAdjustable() == ACLTextArea.this.vertical) {
                ACLTextArea.this.setFirstLine(ACLTextArea.this.vertical.getValue());
            } else {
                ACLTextArea.this.setHorizontalOffset(-ACLTextArea.this.horizontal.getValue());
            }
        }
    }

    class MutableCaretEvent
    extends CaretEvent {
        MutableCaretEvent() {
            super(ACLTextArea.this);
        }

        @Override
        public int getDot() {
            return ACLTextArea.this.getCaretPosition();
        }

        @Override
        public int getMark() {
            return ACLTextArea.this.getMarkPosition();
        }
    }

    class AutoScroll
    implements ActionListener,
    MouseMotionListener {
        private int x;
        private int y;

        AutoScroll() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ACLTextArea.this.select(ACLTextArea.this.getMarkPosition(), ACLTextArea.this.xyToOffset(this.x, this.y));
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (ACLTextArea.this.popup != null && ACLTextArea.this.popup.isVisible()) {
                return;
            }
            this.x = evt.getX();
            this.y = evt.getY();
            if (!ACLTextArea.this.scrollTimer.isRunning()) {
                ACLTextArea.this.scrollTimer.start();
            }
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
        }
    }

    class ScrollLayout
    implements LayoutManager {
        private Component center;
        private Component right;
        private Component bottom;

        ScrollLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if (name.equals(CENTER)) {
                this.center = comp;
            } else if (name.equals(RIGHT)) {
                this.right = comp;
            } else if (name.equals(BOTTOM)) {
                this.bottom = comp;
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (this.center == comp) {
                this.center = null;
            }
            if (this.right == comp) {
                this.right = null;
            }
            if (this.bottom == comp) {
                this.bottom = null;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension();
            Insets insets = ACLTextArea.this.getInsets();
            dim.width = insets.left + insets.right;
            dim.height = insets.top + insets.bottom;
            Dimension centerPref = this.center.getPreferredSize();
            dim.height += centerPref.height;
            dim.width += centerPref.width;
            Dimension rightPref = this.right.getPreferredSize();
            dim.width += rightPref.width;
            return dim;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = new Dimension();
            Insets insets = ACLTextArea.this.getInsets();
            dim.width = insets.left + insets.right;
            dim.height = insets.top + insets.bottom;
            Dimension centerPref = this.center.getMinimumSize();
            dim.height += centerPref.height;
            dim.width += centerPref.width;
            Dimension rightPref = this.right.getMinimumSize();
            dim.width += rightPref.width;
            Dimension bottomPref = this.bottom.getMinimumSize();
            dim.height += bottomPref.height;
            return dim;
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension size = parent.getSize();
            Insets insets = ACLTextArea.this.getInsets();
            int itop = insets.top;
            int ileft = insets.left;
            int ibottom = insets.bottom;
            int iright = insets.right;
            int rightWidth = this.right.getPreferredSize().width;
            int bottomHeight = this.center.getPreferredSize().height;
            this.center.setBounds(ileft, itop, size.width - rightWidth - ileft - iright, size.height - bottomHeight - itop - ibottom);
            this.right.setBounds(size.width - rightWidth - iright, itop, rightWidth, size.height - bottomHeight - itop - ibottom);
        }
    }

    private static class InputHandler
    implements KeyListener {
        public static final ActionListener BACKSPACE = new backspace();
        public static final ActionListener DELETE = new delete();
        public static final ActionListener END = new end(false);
        public static final ActionListener SELECT_END = new end(true);
        public static final ActionListener INSERT_BREAK = new insert_break();
        public static final ActionListener INSERT_TAB = new insert_tab();
        public static final ActionListener HOME = new home(false);
        public static final ActionListener SELECT_HOME = new home(true);
        public static final ActionListener NEXT_CHAR = new next_char(false);
        public static final ActionListener NEXT_LINE = new next_line(false);
        public static final ActionListener NEXT_PAGE = new next_page(false);
        public static final ActionListener NEXT_WORD = new next_word(false);
        public static final ActionListener SELECT_NEXT_CHAR = new next_char(true);
        public static final ActionListener SELECT_NEXT_LINE = new next_line(true);
        public static final ActionListener SELECT_NEXT_PAGE = new next_page(true);
        public static final ActionListener SELECT_NEXT_WORD = new next_word(true);
        public static final ActionListener OVERWRITE = new overwrite();
        public static final ActionListener PREV_CHAR = new prev_char(false);
        public static final ActionListener PREV_LINE = new prev_line(false);
        public static final ActionListener PREV_PAGE = new prev_page(false);
        public static final ActionListener PREV_WORD = new prev_word(false);
        public static final ActionListener SELECT_PREV_CHAR = new prev_char(true);
        public static final ActionListener SELECT_PREV_LINE = new prev_line(true);
        public static final ActionListener SELECT_PREV_PAGE = new prev_page(true);
        public static final ActionListener SELECT_PREV_WORD = new prev_word(true);
        public static final ActionListener[] ACTIONS = new ActionListener[]{BACKSPACE, DELETE, END, SELECT_END, INSERT_BREAK, INSERT_TAB, HOME, SELECT_HOME, NEXT_CHAR, NEXT_LINE, NEXT_PAGE, NEXT_WORD, SELECT_NEXT_CHAR, SELECT_NEXT_LINE, SELECT_NEXT_PAGE, SELECT_NEXT_WORD, OVERWRITE, PREV_CHAR, PREV_LINE, PREV_PAGE, PREV_WORD, SELECT_PREV_CHAR, SELECT_PREV_LINE, SELECT_PREV_PAGE, SELECT_PREV_WORD};
        public static final String[] ACTION_NAMES = new String[]{"backspace", "delete", "end", "select-end", "insert-break", "insert-tab", "home", "select-home", "next-char", "next-line", "next-page", "next-word", "select-next-char", "select-next-line", "select-next-page", "select-next-word", "overwrite", "prev-char", "prev-line", "prev-page", "prev-word", "select-prev-char", "select-prev-line", "select-prev-page", "select-prev-word"};
        private Hashtable bindings;
        private Hashtable currentBindings;

        public InputHandler() {
            this.bindings = this.currentBindings = new Hashtable();
        }

        public static ACLTextArea getTextArea(EventObject evt) {
            Object o;
            if (evt != null && (o = evt.getSource()) instanceof Component) {
                Component c = (Component)o;
                while (true) {
                    if (c instanceof ACLTextArea) {
                        return (ACLTextArea)c;
                    }
                    if (c == null) break;
                    if (c instanceof JPopupMenu) {
                        c = ((JPopupMenu)c).getInvoker();
                        continue;
                    }
                    c = c.getParent();
                }
            }
            System.err.println("BUG: getTextArea() returning null");
            System.err.println("Report this to Slava Pestov <sp@gjt.org>");
            return null;
        }

        public static KeyStroke parseKeyStroke(String keyStroke) {
            String key;
            if (keyStroke == null) {
                return null;
            }
            int modifiers = 0;
            int ch = 0;
            int index = keyStroke.indexOf(43);
            if (index != -1) {
                block8: for (int i = 0; i < index; ++i) {
                    switch (Character.toUpperCase(keyStroke.charAt(i))) {
                        case 'A': {
                            modifiers |= 8;
                            continue block8;
                        }
                        case 'C': {
                            modifiers |= 2;
                            continue block8;
                        }
                        case 'M': {
                            modifiers |= 4;
                            continue block8;
                        }
                        case 'S': {
                            modifiers |= 1;
                        }
                    }
                }
            }
            if ((key = keyStroke.substring(index + 1)).length() == 1) {
                ch = Character.toUpperCase(key.charAt(0));
            } else {
                if (key.length() == 0) {
                    System.err.println("Invalid key stroke: " + keyStroke);
                    return null;
                }
                try {
                    ch = KeyEvent.class.getField("VK_".concat(key)).getInt(null);
                }
                catch (Exception e) {
                    System.err.println("Invalid key stroke: " + keyStroke);
                    return null;
                }
            }
            return KeyStroke.getKeyStroke(ch, modifiers);
        }

        public void addDefaultKeyBindings() {
            this.addKeyBinding("BACK_SPACE", BACKSPACE);
            this.addKeyBinding("DELETE", DELETE);
            this.addKeyBinding("ENTER", INSERT_BREAK);
            this.addKeyBinding("TAB", INSERT_TAB);
            this.addKeyBinding("INSERT", OVERWRITE);
            this.addKeyBinding("HOME", HOME);
            this.addKeyBinding("END", END);
            this.addKeyBinding("S+HOME", SELECT_HOME);
            this.addKeyBinding("S+END", SELECT_END);
            this.addKeyBinding("PAGE_UP", PREV_PAGE);
            this.addKeyBinding("PAGE_DOWN", NEXT_PAGE);
            this.addKeyBinding("S+PAGE_UP", SELECT_PREV_PAGE);
            this.addKeyBinding("S+PAGE_DOWN", SELECT_NEXT_PAGE);
            this.addKeyBinding("LEFT", PREV_CHAR);
            this.addKeyBinding("S+LEFT", SELECT_PREV_CHAR);
            this.addKeyBinding("C+LEFT", PREV_WORD);
            this.addKeyBinding("CS+LEFT", SELECT_PREV_WORD);
            this.addKeyBinding("RIGHT", NEXT_CHAR);
            this.addKeyBinding("S+RIGHT", SELECT_NEXT_CHAR);
            this.addKeyBinding("C+RIGHT", NEXT_WORD);
            this.addKeyBinding("CS+RIGHT", SELECT_NEXT_WORD);
            this.addKeyBinding("UP", PREV_LINE);
            this.addKeyBinding("S+UP", SELECT_PREV_LINE);
            this.addKeyBinding("DOWN", NEXT_LINE);
            this.addKeyBinding("S+DOWN", SELECT_NEXT_LINE);
        }

        public void addKeyBinding(String keyBinding, ActionListener action) {
            Hashtable current = this.bindings;
            StringTokenizer st = new StringTokenizer(keyBinding);
            while (st.hasMoreTokens()) {
                KeyStroke keyStroke = InputHandler.parseKeyStroke(st.nextToken());
                if (keyStroke == null) {
                    return;
                }
                if (st.hasMoreTokens()) {
                    Object o = current.get(keyStroke);
                    if (o instanceof Hashtable) {
                        current = (Hashtable)o;
                        continue;
                    }
                    o = new Hashtable();
                    current.put(keyStroke, o);
                    current = (Hashtable)o;
                    continue;
                }
                current.put(keyStroke, action);
            }
        }

        public void removeKeyBinding(String keyBinding) {
            throw new InternalError("Not yet implemented");
        }

        public void removeAllKeyBindings() {
            this.bindings.clear();
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            int keyCode = evt.getKeyCode();
            int modifiers = evt.getModifiers();
            if ((modifiers & 0xFFFFFFFE) != 0 || evt.isActionKey() || keyCode == 8 || keyCode == 127 || keyCode == 10 || keyCode == 9) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, modifiers);
                Object o = this.currentBindings.get(keyStroke);
                if (o == null) {
                    if (this.currentBindings != this.bindings) {
                        Toolkit.getDefaultToolkit().beep();
                        evt.consume();
                    }
                    this.currentBindings = this.bindings;
                    return;
                }
                if (o instanceof ActionListener) {
                    ((ActionListener)o).actionPerformed(new ActionEvent(evt.getSource(), 1001, null, modifiers));
                    this.currentBindings = this.bindings;
                    evt.consume();
                    return;
                }
                if (o instanceof Hashtable) {
                    this.currentBindings = (Hashtable)o;
                    evt.consume();
                    return;
                }
                if (keyCode != 18 && keyCode != 17 && keyCode != 16 && keyCode != 157) {
                    return;
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent evt) {
        }

        @Override
        public void keyTyped(KeyEvent evt) {
            int modifiers = evt.getModifiers();
            char c = evt.getKeyChar();
            if (c != '\uffff' && (modifiers & 8) == 0 && c >= ' ' && c != '\u007f') {
                ACLTextArea textArea = InputHandler.getTextArea(evt);
                if (!textArea.isEditable()) {
                    textArea.getToolkit().beep();
                    return;
                }
                this.currentBindings = this.bindings;
                textArea.overwriteSetSelectedText(String.valueOf(c));
            }
        }

        public static class prev_word
        implements ActionListener {
            private boolean select;

            public prev_word(boolean select) {
                this.select = select;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                ACLTextArea textArea = InputHandler.getTextArea(evt);
                int caret = textArea.getCaretPosition();
                int line = textArea.getCaretLine();
                int lineStart = textArea.getLineStartOffset(line);
                String lineText = textArea.getLineText(textArea.getCaretLine());
                if ((caret -= lineStart) == 0) {
                    if (lineStart == 0) {
                        textArea.getToolkit().beep();
                        return;
                    }
                    --caret;
                } else {
                    char ch = lineText.charAt(caret - 1);
                    String noWordSep = (String)textArea.getDocument().getProperty("noWordSep");
                    boolean selectNoLetter = !Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1;
                    int wordStart = 0;
                    for (int i = caret - 1; i >= 0; --i) {
                        ch = lineText.charAt(i);
                        if (!(selectNoLetter ^ (!Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1))) continue;
                        wordStart = i + 1;
                        break;
                    }
                    caret = wordStart;
                }
                if (this.select) {
                    textArea.select(textArea.getMarkPosition(), lineStart + caret);
                } else {
                    textArea.setCaretPosition(lineStart + caret);
                }
            }
        }

        public static class prev_page
        implements ActionListener {
            private boolean select;

            public prev_page(boolean select) {
                this.select = select;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                ACLTextArea textArea = InputHandler.getTextArea(evt);
                int firstLine = textArea.getFirstLine();
                int visibleLines = textArea.getVisibleLines();
                int line = textArea.getCaretLine();
                if (firstLine < visibleLines) {
                    firstLine = visibleLines;
                }
                textArea.setFirstLine(firstLine - visibleLines);
                int caret = textArea.getLineStartOffset(Math.max(0, line - visibleLines));
                if (this.select) {
                    textArea.select(textArea.getMarkPosition(), caret);
                } else {
                    textArea.setCaretPosition(caret);
                }
            }
        }

        public static class prev_line
        implements ActionListener {
            private boolean select;

            public prev_line(boolean select) {
                this.select = select;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                ACLTextArea textArea = InputHandler.getTextArea(evt);
                int caret = textArea.getCaretPosition();
                int line = textArea.getCaretLine();
                if (line == 0) {
                    textArea.getToolkit().beep();
                    return;
                }
                int magic = textArea.getMagicCaretPosition();
                if (magic == -1) {
                    magic = textArea.offsetToX(line, caret - textArea.getLineStartOffset(line));
                }
                caret = textArea.getLineStartOffset(line - 1) + textArea.xToOffset(line - 1, magic);
                if (this.select) {
                    textArea.select(textArea.getMarkPosition(), caret);
                } else {
                    textArea.setCaretPosition(caret);
                }
                textArea.setMagicCaretPosition(magic);
            }
        }

        public static class prev_char
        implements ActionListener {
            private boolean select;

            public prev_char(boolean select) {
                this.select = select;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                ACLTextArea textArea = InputHandler.getTextArea(evt);
                int caret = textArea.getCaretPosition();
                if (caret == 0) {
                    textArea.getToolkit().beep();
                    return;
                }
                if (this.select) {
                    textArea.select(textArea.getMarkPosition(), caret - 1);
                } else {
                    textArea.setCaretPosition(caret - 1);
                }
            }
        }

        public static class overwrite
        implements ActionListener {
            @Override
            public void actionPerformed(ActionEvent evt) {
                ACLTextArea textArea;
                textArea.setOverwriteEnabled(!(textArea = InputHandler.getTextArea(evt)).isOverwriteEnabled());
            }
        }

        public static class next_word
        implements ActionListener {
            private boolean select;

            public next_word(boolean select) {
                this.select = select;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                String lineText;
                ACLTextArea textArea = InputHandler.getTextArea(evt);
                int caret = textArea.getCaretPosition();
                int line = textArea.getCaretLine();
                int lineStart = textArea.getLineStartOffset(line);
                if ((caret -= lineStart) == (lineText = textArea.getLineText(textArea.getCaretLine())).length()) {
                    if (lineStart + caret == textArea.getDocumentLength()) {
                        textArea.getToolkit().beep();
                        return;
                    }
                    ++caret;
                } else {
                    char ch = lineText.charAt(caret);
                    String noWordSep = (String)textArea.getDocument().getProperty("noWordSep");
                    boolean selectNoLetter = !Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1;
                    int wordEnd = lineText.length();
                    for (int i = caret; i < lineText.length(); ++i) {
                        ch = lineText.charAt(i);
                        if (!(selectNoLetter ^ (!Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1))) continue;
                        wordEnd = i;
                        break;
                    }
                    caret = wordEnd;
                }
                if (this.select) {
                    textArea.select(textArea.getMarkPosition(), lineStart + caret);
                } else {
                    textArea.setCaretPosition(lineStart + caret);
                }
            }
        }

        public static class next_page
        implements ActionListener {
            private boolean select;

            public next_page(boolean select) {
                this.select = select;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                ACLTextArea textArea = InputHandler.getTextArea(evt);
                int lineCount = textArea.getLineCount();
                int firstLine = textArea.getFirstLine();
                int visibleLines = textArea.getVisibleLines();
                int line = textArea.getCaretLine();
                if ((firstLine += visibleLines) + visibleLines >= lineCount - 1) {
                    firstLine = lineCount - visibleLines;
                }
                textArea.setFirstLine(firstLine);
                int caret = textArea.getLineStartOffset(Math.min(textArea.getLineCount() - 1, line + visibleLines));
                if (this.select) {
                    textArea.select(textArea.getMarkPosition(), caret);
                } else {
                    textArea.setCaretPosition(caret);
                }
            }
        }

        public static class next_line
        implements ActionListener {
            private boolean select;

            public next_line(boolean select) {
                this.select = select;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                ACLTextArea textArea = InputHandler.getTextArea(evt);
                int caret = textArea.getCaretPosition();
                int line = textArea.getCaretLine();
                if (line == textArea.getLineCount() - 1) {
                    textArea.getToolkit().beep();
                    return;
                }
                int magic = textArea.getMagicCaretPosition();
                if (magic == -1) {
                    magic = textArea.offsetToX(line, caret - textArea.getLineStartOffset(line));
                }
                caret = textArea.getLineStartOffset(line + 1) + textArea.xToOffset(line + 1, magic);
                if (this.select) {
                    textArea.select(textArea.getMarkPosition(), caret);
                } else {
                    textArea.setCaretPosition(caret);
                }
                textArea.setMagicCaretPosition(magic);
            }
        }

        public static class next_char
        implements ActionListener {
            private boolean select;

            public next_char(boolean select) {
                this.select = select;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                ACLTextArea textArea = InputHandler.getTextArea(evt);
                int caret = textArea.getCaretPosition();
                if (caret == textArea.getDocumentLength()) {
                    textArea.getToolkit().beep();
                    return;
                }
                if (this.select) {
                    textArea.select(textArea.getMarkPosition(), caret + 1);
                } else {
                    textArea.setCaretPosition(caret + 1);
                }
            }
        }

        public static class insert_tab
        implements ActionListener {
            @Override
            public void actionPerformed(ActionEvent evt) {
                ACLTextArea textArea = InputHandler.getTextArea(evt);
                if (!textArea.isEditable()) {
                    textArea.getToolkit().beep();
                    return;
                }
                textArea.overwriteSetSelectedText("\t");
            }
        }

        public static class insert_break
        implements ActionListener {
            @Override
            public void actionPerformed(ActionEvent evt) {
                ACLTextArea textArea = InputHandler.getTextArea(evt);
                if (!textArea.isEditable()) {
                    textArea.getToolkit().beep();
                    return;
                }
                textArea.setSelectedText("\n");
            }
        }

        public static class home
        implements ActionListener {
            private boolean select;

            public home(boolean select) {
                this.select = select;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                ACLTextArea textArea = InputHandler.getTextArea(evt);
                int caret = textArea.getCaretPosition();
                int firstLine = textArea.getFirstLine();
                int firstOfLine = textArea.getLineStartOffset(textArea.getCaretLine());
                int firstVisibleLine = firstLine == 0 ? 0 : firstLine + textArea.getElectricScroll();
                int firstVisible = textArea.getLineStartOffset(firstVisibleLine);
                if (caret == 0) {
                    textArea.getToolkit().beep();
                    return;
                }
                caret = caret == firstVisible ? 0 : (caret == firstOfLine ? firstVisible : firstOfLine);
                if (this.select) {
                    textArea.select(textArea.getMarkPosition(), caret);
                } else {
                    textArea.setCaretPosition(caret);
                }
            }
        }

        public static class end
        implements ActionListener {
            private boolean select;

            public end(boolean select) {
                this.select = select;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                ACLTextArea textArea = InputHandler.getTextArea(evt);
                int caret = textArea.getCaretPosition();
                int lastOfLine = textArea.getLineEndOffset(textArea.getCaretLine()) - 1;
                int lastVisibleLine = textArea.getFirstLine() + textArea.getVisibleLines();
                lastVisibleLine = lastVisibleLine >= textArea.getLineCount() ? Math.min(textArea.getLineCount() - 1, lastVisibleLine) : (lastVisibleLine -= textArea.getElectricScroll() + 1);
                int lastVisible = textArea.getLineEndOffset(lastVisibleLine) - 1;
                int lastDocument = textArea.getDocumentLength();
                if (caret == lastDocument) {
                    textArea.getToolkit().beep();
                    return;
                }
                caret = caret == lastVisible ? lastDocument : (caret == lastOfLine ? lastVisible : lastOfLine);
                if (this.select) {
                    textArea.select(textArea.getMarkPosition(), caret);
                } else {
                    textArea.setCaretPosition(caret);
                }
            }
        }

        public static class delete
        implements ActionListener {
            @Override
            public void actionPerformed(ActionEvent evt) {
                ACLTextArea textArea = InputHandler.getTextArea(evt);
                if (!textArea.isEditable()) {
                    textArea.getToolkit().beep();
                    return;
                }
                if (textArea.getSelectionStart() != textArea.getSelectionEnd()) {
                    textArea.setSelectedText("");
                } else {
                    int caret = textArea.getCaretPosition();
                    if (caret == textArea.getDocumentLength()) {
                        textArea.getToolkit().beep();
                        return;
                    }
                    try {
                        textArea.getDocument().remove(caret, 1);
                    }
                    catch (BadLocationException bl) {
                        bl.printStackTrace();
                    }
                }
            }
        }

        public static class backspace
        implements ActionListener {
            @Override
            public void actionPerformed(ActionEvent evt) {
                ACLTextArea textArea = InputHandler.getTextArea(evt);
                if (!textArea.isEditable()) {
                    textArea.getToolkit().beep();
                    return;
                }
                if (textArea.getSelectionStart() != textArea.getSelectionEnd()) {
                    textArea.setSelectedText("");
                } else {
                    int caret = textArea.getCaretPosition();
                    if (caret == 0) {
                        textArea.getToolkit().beep();
                        return;
                    }
                    try {
                        textArea.getDocument().remove(caret - 1, 1);
                    }
                    catch (BadLocationException bl) {
                        bl.printStackTrace();
                    }
                }
            }
        }
    }

    static class CaretBlinker
    implements ActionListener {
        CaretBlinker() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (focusedComponent != null && focusedComponent.hasFocus()) {
                focusedComponent.blinkCaret();
            }
        }
    }

    public static class TextUtilities {
        public static int findMatchingBracket(Document doc, int offset) throws BadLocationException {
            boolean direction;
            char cprime;
            if (doc.getLength() == 0) {
                return -1;
            }
            char c = doc.getText(offset, 1).charAt(0);
            switch (c) {
                case '(': {
                    cprime = ')';
                    direction = false;
                    break;
                }
                case ')': {
                    cprime = '(';
                    direction = true;
                    break;
                }
                case '[': {
                    cprime = ']';
                    direction = false;
                    break;
                }
                case ']': {
                    cprime = '[';
                    direction = true;
                    break;
                }
                case '{': {
                    cprime = '}';
                    direction = false;
                    break;
                }
                case '}': {
                    cprime = '{';
                    direction = true;
                    break;
                }
                default: {
                    return -1;
                }
            }
            if (direction) {
                int count = 1;
                String text = doc.getText(0, offset);
                for (int i = offset - 1; i >= 0; --i) {
                    char x = text.charAt(i);
                    if (x == c) {
                        ++count;
                        continue;
                    }
                    if (x != cprime || --count != 0) continue;
                    return i;
                }
            } else {
                int count = 1;
                int len = doc.getLength() - ++offset;
                String text = doc.getText(offset, len);
                for (int i = 0; i < len; ++i) {
                    char x = text.charAt(i);
                    if (x == c) {
                        ++count;
                        continue;
                    }
                    if (x != cprime || --count != 0) continue;
                    return i + offset;
                }
            }
            return -1;
        }
    }
}

