/*
 * Decompiled with CFR 0.152.
 */
package jade.wrapper;

import jade.core.AgentManager;
import jade.core.ContainerID;
import jade.core.event.MTPEvent;
import jade.security.JADESecurityException;
import jade.wrapper.AgentController;
import jade.wrapper.ContainerController;
import jade.wrapper.ControllerException;
import jade.wrapper.PlatformController;
import jade.wrapper.PlatformEvent;
import jade.wrapper.PlatformState;
import jade.wrapper.State;
import java.util.Hashtable;

class PlatformControllerImpl
implements PlatformController {
    private ContainerController myContainer;
    private AgentManager myMain;
    private Hashtable listeners = new Hashtable();
    private State platformState = PlatformState.PLATFORM_STATE_VOID;

    PlatformControllerImpl(ContainerController c, AgentManager m) {
        this.myContainer = c;
        this.myMain = m;
        this.platformState = PlatformState.PLATFORM_STATE_READY;
        this.myMain.addListener(new AgentManagerListenerAdapter(){

            @Override
            public void removedContainer(jade.core.event.PlatformEvent ev) {
                ContainerID cid = ev.getContainer();
                try {
                    if (cid.getName().equals(PlatformControllerImpl.this.myContainer.getContainerName())) {
                        PlatformControllerImpl.this.platformState = PlatformState.PLATFORM_STATE_KILLED;
                    }
                }
                catch (ControllerException ce) {
                    ce.printStackTrace();
                }
            }
        });
    }

    @Override
    public String getName() {
        return this.myContainer.getPlatformName();
    }

    @Override
    public void start() throws ControllerException {
    }

    @Override
    public void suspend() throws ControllerException {
        throw new ControllerException("Not_Yet_Implemented");
    }

    @Override
    public void resume() throws ControllerException {
        throw new ControllerException("Not_Yet_Implemented");
    }

    @Override
    public void kill() throws ControllerException {
        try {
            this.platformState = PlatformState.PLATFORM_STATE_KILLING;
            this.myMain.shutdownPlatform(null, null);
        }
        catch (JADESecurityException jse) {
            throw new ControllerException("Security error. " + jse.getMessage());
        }
    }

    @Override
    public AgentController getAgent(String localAgentName) throws ControllerException {
        return this.myContainer.getAgent(localAgentName);
    }

    @Override
    public AgentController createNewAgent(String nickname, String className, Object[] args) throws ControllerException {
        return this.myContainer.createNewAgent(nickname, className, args);
    }

    @Override
    public State getState() {
        return this.platformState;
    }

    @Override
    public synchronized void addPlatformListener(PlatformController.Listener aListener) throws ControllerException {
        ListenerWrapper wrapper = new ListenerWrapper(aListener);
        this.myMain.addListener(wrapper);
        this.listeners.put(aListener, wrapper);
    }

    @Override
    public synchronized void removePlatformListener(PlatformController.Listener aListener) throws ControllerException {
        ListenerWrapper wrapper = (ListenerWrapper)this.listeners.get(aListener);
        if (wrapper != null) {
            this.myMain.removeListener(wrapper);
        }
    }

    class ListenerWrapper
    extends AgentManagerListenerAdapter {
        private PlatformController.Listener myListener;

        ListenerWrapper(PlatformController.Listener l) {
            this.myListener = l;
        }

        @Override
        public void removedContainer(jade.core.event.PlatformEvent ev) {
            ContainerID cid = ev.getContainer();
            try {
                if (cid.getName().equals(PlatformControllerImpl.this.myContainer.getContainerName())) {
                    this.myListener.killedPlatform(new PlatformEvent(){

                        @Override
                        public String getAgentGUID() {
                            return null;
                        }

                        @Override
                        public String getPlatformName() {
                            return PlatformControllerImpl.this.myContainer.getPlatformName();
                        }

                        @Override
                        public int getEventType() {
                            return 103;
                        }
                    });
                }
            }
            catch (ControllerException ce) {
                ce.printStackTrace();
            }
        }

        @Override
        public void bornAgent(jade.core.event.PlatformEvent ev) {
            this.myListener.bornAgent(ev);
        }

        @Override
        public void deadAgent(jade.core.event.PlatformEvent ev) {
            this.myListener.deadAgent(ev);
        }
    }

    class AgentManagerListenerAdapter
    implements AgentManager.Listener {
        AgentManagerListenerAdapter() {
        }

        @Override
        public void addedContainer(jade.core.event.PlatformEvent ev) {
        }

        @Override
        public void removedContainer(jade.core.event.PlatformEvent ev) {
        }

        @Override
        public void bornAgent(jade.core.event.PlatformEvent ev) {
        }

        @Override
        public void deadAgent(jade.core.event.PlatformEvent ev) {
        }

        @Override
        public void movedAgent(jade.core.event.PlatformEvent ev) {
        }

        @Override
        public void suspendedAgent(jade.core.event.PlatformEvent ev) {
        }

        @Override
        public void resumedAgent(jade.core.event.PlatformEvent ev) {
        }

        @Override
        public void frozenAgent(jade.core.event.PlatformEvent ev) {
        }

        @Override
        public void thawedAgent(jade.core.event.PlatformEvent ev) {
        }

        @Override
        public void addedMTP(MTPEvent ev) {
        }

        @Override
        public void removedMTP(MTPEvent ev) {
        }

        @Override
        public void messageIn(MTPEvent ev) {
        }

        @Override
        public void messageOut(MTPEvent ev) {
        }
    }
}

