/*
 * Decompiled with CFR 0.152.
 */
package jade.wrapper.gateway;

import jade.core.behaviours.CyclicBehaviour;
import jade.util.Event;
import jade.util.Logger;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;

public abstract class GatewayBehaviour
extends CyclicBehaviour {
    private final HashMap commandQueue = new HashMap(2);
    private final Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    @Override
    public void action() {
        Event e = (Event)this.myAgent.getO2AObject();
        if (e == null) {
            this.block();
            return;
        }
        this.commandQueue.put(e.getSource(), e);
        if (this.myLogger.isLoggable(Logger.INFO)) {
            this.myLogger.log(Logger.INFO, this.myAgent.getLocalName() + " started execution of command " + e.getSource());
        }
        this.processCommand(e.getSource());
    }

    protected abstract void processCommand(Object var1);

    public final void releaseCommand(Object command) {
        Event e = (Event)this.commandQueue.remove(command);
        if (e != null) {
            if (this.myLogger.isLoggable(Logger.INFO)) {
                this.myLogger.log(Logger.INFO, this.myAgent.getLocalName() + " terminated execution of command " + command);
            }
            e.notifyProcessed(null);
        }
    }

    @Override
    public int onEnd() {
        if (this.myLogger.isLoggable(Logger.INFO)) {
            this.myLogger.log(Logger.INFO, this.myAgent.getLocalName() + " terminated GatewayBehaviour");
        }
        Iterator i = this.commandQueue.values().iterator();
        while (i.hasNext()) {
            ((Event)i.next()).notifyProcessed(null);
        }
        return super.onEnd();
    }
}

