/*
 * Decompiled with CFR 0.152.
 */
package jade.wrapper.gateway;

import jade.JadeClassLoader;
import jade.core.AID;
import jade.core.MicroRuntime;
import jade.core.NotFoundException;
import jade.util.Logger;
import jade.util.leap.Properties;
import jade.wrapper.ControllerException;
import jade.wrapper.StaleProxyException;
import jade.wrapper.gateway.DynamicJadeGateway;
import jade.wrapper.gateway.GatewayAgent;

public class SplitJadeGateway
extends DynamicJadeGateway {
    private static Logger myLogger = Logger.getMyLogger(SplitJadeGateway.class.getName());

    @Override
    public void checkJADE() throws StaleProxyException, ControllerException {
        this.initProfile();
        final Properties properties = this.profile.getProperties();
        MicroRuntime.startJADE(properties, new Runnable(){

            @Override
            public void run() {
                myLogger.log(Logger.INFO, "Disconnected from the platform at " + properties.getProperty("host") + ":" + properties.getProperty("port"));
            }
        });
        if (MicroRuntime.isRunning()) {
            myLogger.log(Logger.INFO, "Connected to the platform at " + properties.getProperty("host") + ":" + properties.getProperty("port"));
            if (this.myAgent == null) {
                if (this.agentName == null) {
                    this.agentName = "Control" + MicroRuntime.getContainerName();
                }
                try {
                    Class<?> agentClass = JadeClassLoader.forName(this.agentType);
                    if (GatewayAgent.class.isAssignableFrom(agentClass)) {
                        if (this.agentArguments == null) {
                            this.agentArguments = new Object[1];
                            this.agentArguments[0] = new DynamicJadeGateway.GatewayListenerImpl();
                        }
                        this.gatewayAgentState = 2;
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new ControllerException("GatewayAgent class not found [" + e + "]");
                }
                try {
                    MicroRuntime.startAgent(this.agentName, this.agentType, this.agentArguments);
                    if (this.gatewayAgentState == 2) {
                        this.gatewayAgentState = 1;
                    }
                }
                catch (Exception e) {
                    throw new ControllerException("Error creating GatewayAgent [" + e + "]");
                }
                this.myAgent = MicroRuntime.getAgent(this.agentName);
            }
        } else {
            myLogger.log(Logger.WARNING, "Cannot connect to the platform at " + properties.getProperty("host") + ":" + properties.getProperty("port"));
            this.shutdown();
        }
    }

    @Override
    public final void shutdown() {
        if (this.myAgent != null) {
            try {
                MicroRuntime.killAgent(this.agentName);
            }
            catch (NotFoundException e) {
                myLogger.log(Logger.WARNING, "Try to kill a not present agent " + this.agentName);
            }
            this.myAgent = null;
        }
        MicroRuntime.stopJADE();
    }

    @Override
    public boolean isGatewayActive() {
        if (this.gatewayAgentState != -1) {
            return this.gatewayAgentState == 1;
        }
        return MicroRuntime.isRunning() && this.myAgent != null;
    }

    @Override
    public AID createAID(String localName) {
        return new AID(localName, false);
    }
}

