/*
 * Decompiled with CFR 0.152.
 */
package jade.content;

import jade.content.ContentElement;
import jade.content.abs.AbsContentElement;
import jade.content.lang.ByteArrayCodec;
import jade.content.lang.Codec;
import jade.content.lang.StringCodec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.UngroundedException;
import jade.content.schema.ObjectSchema;
import jade.core.CaseInsensitiveString;
import jade.lang.acl.ACLMessage;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.Map;
import jade.util.leap.Serializable;
import java.io.IOException;
import java.io.ObjectInputStream;

public class ContentManager
implements Serializable {
    private transient Map languages = new HashMap();
    private transient Map ontologies = new HashMap();
    private boolean validationMode = true;

    private void readObject(ObjectInputStream oin) throws IOException, ClassNotFoundException {
        oin.defaultReadObject();
        this.languages = new HashMap();
        this.ontologies = new HashMap();
    }

    public void registerLanguage(Codec c) {
        if (c == null) {
            throw new IllegalArgumentException("Null codec registered");
        }
        this.registerLanguage(c, c.getName());
    }

    public void registerLanguage(Codec c, String name) {
        if (c == null) {
            throw new IllegalArgumentException("Null codec registered");
        }
        this.languages.put(new CaseInsensitiveString(name), c);
    }

    public void registerOntology(Ontology o) {
        if (o == null) {
            throw new IllegalArgumentException("Null ontology registered");
        }
        this.registerOntology(o, o.getName());
    }

    public void registerOntology(Ontology o, String name) {
        if (o == null) {
            throw new IllegalArgumentException("Null ontology registered");
        }
        this.ontologies.put(new CaseInsensitiveString(name), o);
    }

    public Codec lookupLanguage(String name) {
        return name == null ? null : (Codec)this.languages.get(new CaseInsensitiveString(name));
    }

    public Ontology lookupOntology(String name) {
        return name == null ? null : (Ontology)this.ontologies.get(new CaseInsensitiveString(name));
    }

    public void fillContent(ACLMessage msg, AbsContentElement content) throws Codec.CodecException, OntologyException {
        Codec codec = this.lookupLanguage(msg.getLanguage());
        if (codec == null) {
            throw new Codec.CodecException("Unknown language " + msg.getLanguage());
        }
        String ontoName = msg.getOntology();
        Ontology o = null;
        if (ontoName != null && (o = this.lookupOntology(ontoName)) == null) {
            throw new OntologyException("Unknown ontology " + msg.getOntology());
        }
        Ontology onto = this.getMergedOntology(codec, o);
        this.validate(content, onto);
        this.encode(msg, content, codec, onto);
    }

    public void fillContent(ACLMessage msg, ContentElement content) throws Codec.CodecException, OntologyException {
        Codec codec = this.lookupLanguage(msg.getLanguage());
        if (codec == null) {
            throw new Codec.CodecException("Unknown language " + msg.getLanguage());
        }
        String ontoName = msg.getOntology();
        Ontology o = null;
        if (ontoName != null && (o = this.lookupOntology(ontoName)) == null) {
            throw new OntologyException("Unknown ontology " + msg.getOntology());
        }
        Ontology onto = this.getMergedOntology(codec, o);
        AbsContentElement abs = (AbsContentElement)onto.fromObject(content);
        this.validate(abs, onto);
        this.encode(msg, abs, codec, onto);
    }

    public AbsContentElement extractAbsContent(ACLMessage msg) throws Codec.CodecException, OntologyException {
        Codec codec = this.lookupLanguage(msg.getLanguage());
        if (codec == null) {
            throw new Codec.CodecException("Unknown language " + msg.getLanguage());
        }
        String ontoName = msg.getOntology();
        Ontology o = null;
        if (ontoName != null && (o = this.lookupOntology(ontoName)) == null) {
            throw new OntologyException("Unknown ontology " + msg.getOntology());
        }
        Ontology onto = this.getMergedOntology(codec, o);
        AbsContentElement content = this.decode(msg, codec, onto);
        this.validate(content, onto);
        return content;
    }

    public ContentElement extractContent(ACLMessage msg) throws Codec.CodecException, UngroundedException, OntologyException {
        Codec codec = this.lookupLanguage(msg.getLanguage());
        if (codec == null) {
            throw new Codec.CodecException("Unknown language " + msg.getLanguage());
        }
        String ontoName = msg.getOntology();
        Ontology o = null;
        if (ontoName != null && (o = this.lookupOntology(ontoName)) == null) {
            throw new OntologyException("Unknown ontology " + msg.getOntology());
        }
        Ontology onto = this.getMergedOntology(codec, o);
        AbsContentElement content = this.decode(msg, codec, onto);
        this.validate(content, onto);
        return (ContentElement)onto.toObject(content);
    }

    public void setValidationMode(boolean mode) {
        this.validationMode = mode;
    }

    public boolean getValidationMode() {
        return this.validationMode;
    }

    public Ontology getOntology(ACLMessage msg) {
        return this.getMergedOntology(this.lookupLanguage(msg.getLanguage()), this.lookupOntology(msg.getOntology()));
    }

    private Ontology getMergedOntology(Codec c, Ontology o) {
        Ontology ontology = null;
        Ontology langOnto = c.getInnerOntology();
        ontology = langOnto == null ? o : (o == null ? langOnto : new Ontology(null, new Ontology[]{o, langOnto}, null));
        return ontology;
    }

    private void validate(AbsContentElement content, Ontology onto) throws OntologyException {
        if (this.validationMode) {
            ObjectSchema schema = onto.getSchema(content.getTypeName());
            if (schema == null) {
                throw new OntologyException("No schema found for type " + content.getTypeName());
            }
            schema.validate(content, onto);
        }
    }

    private void encode(ACLMessage msg, AbsContentElement content, Codec codec, Ontology onto) throws Codec.CodecException, OntologyException {
        if (codec instanceof ByteArrayCodec) {
            msg.setByteSequenceContent(((ByteArrayCodec)codec).encode(onto, content));
        } else if (codec instanceof StringCodec) {
            msg.setContent(((StringCodec)codec).encode(onto, content));
        } else {
            throw new Codec.CodecException("UnsupportedTypeOfCodec");
        }
    }

    private AbsContentElement decode(ACLMessage msg, Codec codec, Ontology onto) throws Codec.CodecException, OntologyException {
        if (codec instanceof ByteArrayCodec) {
            return ((ByteArrayCodec)codec).decode(onto, msg.getByteSequenceContent());
        }
        if (codec instanceof StringCodec) {
            return ((StringCodec)codec).decode(onto, msg.getContent());
        }
        throw new Codec.CodecException("UnsupportedTypeOfCodec");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("(ContentManager:\n  - registered-ontologies = ");
        sb.append(this.ontologies);
        sb.append("\n  - registered-languages = ");
        sb.append(this.languages);
        sb.append(")");
        return sb.toString();
    }

    public String[] getLanguageNames() {
        String[] langs = new String[this.languages.size()];
        int i = 0;
        Iterator it = this.languages.keySet().iterator();
        while (it.hasNext()) {
            langs[i] = it.next().toString();
            ++i;
        }
        return langs;
    }

    public String[] getOntologyNames() {
        String[] onts = new String[this.ontologies.size()];
        int i = 0;
        Iterator it = this.ontologies.keySet().iterator();
        while (it.hasNext()) {
            onts[i] = it.next().toString();
            ++i;
        }
        return onts;
    }
}

