/*
 * Decompiled with CFR 0.152.
 */
package jade.content.onto;

import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElementList;
import jade.content.Predicate;
import jade.content.abs.AbsAgentAction;
import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsConcept;
import jade.content.abs.AbsContentElementList;
import jade.content.abs.AbsHelper;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPredicate;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsTerm;
import jade.content.lang.sl.SL0Vocabulary;
import jade.content.onto.ConceptSlotFunction;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.UngroundedException;
import jade.content.onto.UnknownSchemaException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Done;
import jade.content.onto.basic.Equals;
import jade.content.onto.basic.FalseProposition;
import jade.content.onto.basic.Result;
import jade.content.onto.basic.TrueProposition;
import jade.content.schema.AgentActionSchema;
import jade.content.schema.AggregateSchema;
import jade.content.schema.ConceptSchema;
import jade.content.schema.ContentElementListSchema;
import jade.content.schema.ObjectSchema;
import jade.content.schema.PredicateSchema;
import jade.content.schema.PrimitiveSchema;
import jade.content.schema.TermSchema;
import jade.core.AID;
import jade.core.CaseInsensitiveString;
import jade.domain.FIPAAgentManagement.Property;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ISO8601;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Map;
import jade.util.leap.Set;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BasicOntology
extends Ontology
implements SL0Vocabulary {
    private static final BasicOntology theInstance = new BasicOntology();
    public static final String STRING = "BO_String";
    public static final String FLOAT = "BO_Float";
    public static final String INTEGER = "BO_Integer";
    public static final String BOOLEAN = "BO_Boolean";
    public static final String DATE = "BO_Date";
    public static final String BYTE_SEQUENCE = "BO_Byte-sequence";
    public static final String CONTENT_ELEMENT_LIST = "ContentElementList";
    private transient Map primitiveSchemas;

    private BasicOntology() {
        super("BASIC_ONTOLOGY", (Ontology)null, null);
    }

    private void initialize() {
        try {
            this.add(new PrimitiveSchema(FLOAT));
            this.add(new PrimitiveSchema(INTEGER));
            this.add(new PrimitiveSchema(BOOLEAN));
            this.add(new AggregateSchema("sequence"));
            this.add(new AggregateSchema("set"));
            this.add(ContentElementListSchema.getBaseSchema());
            this.add(new PrimitiveSchema(STRING), String.class);
            this.add(new PrimitiveSchema(DATE), Date.class);
            this.add(new PrimitiveSchema(BYTE_SEQUENCE), byte[].class);
            this.add(new ConceptSchema("agent-identifier"), AID.class);
            this.add(new ConceptSchema("property"), Property.class);
            this.add(new AgentActionSchema("fipa-acl-message"), ACLMessage.class);
            this.add(new PredicateSchema("true"), TrueProposition.class);
            this.add(new PredicateSchema("false"), FalseProposition.class);
            this.add(new AgentActionSchema("action"), Action.class);
            this.add(new PredicateSchema("done"), Done.class);
            this.add(new PredicateSchema("result"), Result.class);
            this.add(new PredicateSchema("="), Equals.class);
            ConceptSchema aidSchema = (ConceptSchema)this.getSchema("agent-identifier");
            aidSchema.add("name", (TermSchema)this.getSchema(STRING));
            aidSchema.add("addresses", (TermSchema)this.getSchema(STRING), 0, -1);
            aidSchema.add("resolvers", aidSchema, 0, -1);
            ConceptSchema propertySchema = (ConceptSchema)this.getSchema("property");
            propertySchema.add("name", (PrimitiveSchema)this.getSchema(STRING));
            propertySchema.add("value", (TermSchema)TermSchema.getBaseSchema(), 1);
            AgentActionSchema msgSchema = (AgentActionSchema)this.getSchema("fipa-acl-message");
            msgSchema.add("sender", (ConceptSchema)this.getSchema("agent-identifier"), 1);
            msgSchema.add("receivers", (ConceptSchema)this.getSchema("agent-identifier"), 0, -1);
            msgSchema.add("reply-to", (ConceptSchema)this.getSchema("agent-identifier"), 0, -1);
            msgSchema.add("language", (PrimitiveSchema)this.getSchema(STRING), 1);
            msgSchema.add("ontology", (PrimitiveSchema)this.getSchema(STRING), 1);
            msgSchema.add("protocol", (PrimitiveSchema)this.getSchema(STRING), 1);
            msgSchema.add("in-reply-to", (PrimitiveSchema)this.getSchema(STRING), 1);
            msgSchema.add("reply-with", (PrimitiveSchema)this.getSchema(STRING), 1);
            msgSchema.add("conversation-id", (PrimitiveSchema)this.getSchema(STRING), 1);
            msgSchema.add("reply-by", (PrimitiveSchema)this.getSchema(DATE), 1);
            msgSchema.add("content", (PrimitiveSchema)this.getSchema(STRING), 1);
            msgSchema.add("bs-content", (PrimitiveSchema)this.getSchema(BYTE_SEQUENCE), 1);
            msgSchema.add("encoding", (PrimitiveSchema)this.getSchema(STRING), 1);
            AgentActionSchema actionSchema = (AgentActionSchema)this.getSchema("action");
            actionSchema.add("actor", (TermSchema)this.getSchema("agent-identifier"));
            actionSchema.add("action", (TermSchema)ConceptSchema.getBaseSchema());
            actionSchema.setEncodingByOrder(true);
            PredicateSchema doneSchema = (PredicateSchema)this.getSchema("done");
            doneSchema.add("action", (AgentActionSchema)AgentActionSchema.getBaseSchema());
            doneSchema.add("condition", (PredicateSchema)PredicateSchema.getBaseSchema(), 1);
            PredicateSchema resultSchema = (PredicateSchema)this.getSchema("result");
            resultSchema.add("action", (AgentActionSchema)AgentActionSchema.getBaseSchema());
            resultSchema.add("value", (TermSchema)TermSchema.getBaseSchema());
            PredicateSchema equalsSchema = (PredicateSchema)this.getSchema("=");
            equalsSchema.add("left", TermSchema.getBaseSchema());
            equalsSchema.add("right", TermSchema.getBaseSchema());
            this.fillPrimitiveSchemas();
        }
        catch (OntologyException oe) {
            oe.printStackTrace();
        }
    }

    private void fillPrimitiveSchemas() throws OntologyException {
        this.primitiveSchemas = new HashMap(10);
        this.primitiveSchemas.put(Boolean.TYPE, this.getSchema(BOOLEAN));
        this.primitiveSchemas.put(Boolean.class, this.getSchema(BOOLEAN));
        this.primitiveSchemas.put(Integer.TYPE, this.getSchema(INTEGER));
        this.primitiveSchemas.put(Long.TYPE, this.getSchema(INTEGER));
        this.primitiveSchemas.put(Integer.class, this.getSchema(INTEGER));
        this.primitiveSchemas.put(Long.class, this.getSchema(INTEGER));
        this.primitiveSchemas.put(Float.TYPE, this.getSchema(FLOAT));
        this.primitiveSchemas.put(Double.TYPE, this.getSchema(FLOAT));
        this.primitiveSchemas.put(Float.class, this.getSchema(FLOAT));
        this.primitiveSchemas.put(Double.class, this.getSchema(FLOAT));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.fillPrimitiveSchemas();
        }
        catch (OntologyException oe) {
            oe.printStackTrace();
        }
    }

    public static Ontology getInstance() {
        return theInstance;
    }

    @Override
    protected Object toObject(AbsObject abs, String lcType, Ontology referenceOnto) throws UngroundedException, OntologyException {
        try {
            if (abs == null) {
                return null;
            }
            if (abs.getAbsType() == 4) {
                return ((AbsPrimitive)abs).getObject();
            }
            if (abs.getAbsType() == 5) {
                String absTypeName = abs.getTypeName();
                if ("sequence".equals(absTypeName)) {
                    return AbsHelper.internaliseList((AbsAggregate)abs, referenceOnto);
                }
                if ("set".equals(absTypeName)) {
                    return AbsHelper.internaliseSet((AbsAggregate)abs, referenceOnto);
                }
                return AbsHelper.internaliseJavaCollection((AbsAggregate)abs, referenceOnto);
            }
            if (abs.getAbsType() == 8) {
                return AbsHelper.internaliseContentElementList((AbsContentElementList)abs, referenceOnto);
            }
            if (abs.getAbsType() == 9) {
                AbsObject absConcept = abs.getAbsObject("CSF_CONCEPT");
                return referenceOnto.createConceptSlotFunction(abs.getTypeName(), (Concept)referenceOnto.toObject(absConcept));
            }
            if (CaseInsensitiveString.equalsIgnoreCase(abs.getTypeName(), "agent-identifier")) {
                return AbsHelper.internaliseAID((AbsConcept)abs);
            }
            if (CaseInsensitiveString.equalsIgnoreCase(abs.getTypeName(), "property")) {
                return AbsHelper.internaliseProperty((AbsConcept)abs, referenceOnto);
            }
            if (CaseInsensitiveString.equalsIgnoreCase(abs.getTypeName(), "true")) {
                TrueProposition t = new TrueProposition();
                return t;
            }
            if (CaseInsensitiveString.equalsIgnoreCase(abs.getTypeName(), "false")) {
                FalseProposition t = new FalseProposition();
                return t;
            }
            if (CaseInsensitiveString.equalsIgnoreCase(abs.getTypeName(), "done")) {
                Done d = new Done();
                d.setAction((AgentAction)referenceOnto.toObject(abs.getAbsObject("action")));
                AbsPredicate condition = (AbsPredicate)abs.getAbsObject("condition");
                if (condition != null) {
                    d.setCondition((Predicate)referenceOnto.toObject(abs.getAbsObject("condition")));
                }
                return d;
            }
            if (CaseInsensitiveString.equalsIgnoreCase(abs.getTypeName(), "result")) {
                Result r = new Result();
                r.setAction((AgentAction)referenceOnto.toObject(abs.getAbsObject("action")));
                r.setValue(referenceOnto.toObject(abs.getAbsObject("value")));
                return r;
            }
            if (CaseInsensitiveString.equalsIgnoreCase(abs.getTypeName(), "=")) {
                Equals e = new Equals();
                e.setLeft(referenceOnto.toObject(abs.getAbsObject("left")));
                e.setRight(referenceOnto.toObject(abs.getAbsObject("right")));
                return e;
            }
            if (CaseInsensitiveString.equalsIgnoreCase(abs.getTypeName(), "action")) {
                Action a = new Action();
                a.internalise(abs, referenceOnto);
                return a;
            }
            if (ACLMessage.getInteger(abs.getTypeName()) != -1) {
                return AbsHelper.internaliseACLMessage((AbsAgentAction)abs, referenceOnto);
            }
            throw new UnknownSchemaException();
        }
        catch (OntologyException oe) {
            throw oe;
        }
        catch (Throwable t) {
            throw new OntologyException("Unexpected error internalising " + abs + ".", t);
        }
    }

    @Override
    protected AbsObject fromObject(Object obj, Ontology referenceOnto) throws OntologyException {
        try {
            if (obj == null) {
                return null;
            }
            if (obj instanceof String) {
                return AbsPrimitive.wrap((String)obj);
            }
            if (obj instanceof Boolean) {
                return AbsPrimitive.wrap((Boolean)obj);
            }
            if (obj instanceof Integer) {
                return AbsPrimitive.wrap((Integer)obj);
            }
            if (obj instanceof Long) {
                return AbsPrimitive.wrap((Long)obj);
            }
            if (obj instanceof Float) {
                return AbsPrimitive.wrap(((Float)obj).floatValue());
            }
            if (obj instanceof Double) {
                return AbsPrimitive.wrap((Double)obj);
            }
            if (obj instanceof Date) {
                return AbsPrimitive.wrap((Date)obj);
            }
            if (obj instanceof byte[]) {
                return AbsPrimitive.wrap((byte[])obj);
            }
            if (obj instanceof List) {
                return AbsHelper.externaliseList((List)obj, referenceOnto, "sequence");
            }
            if (obj instanceof Set) {
                return AbsHelper.externaliseSet((Set)obj, referenceOnto, "set");
            }
            if (obj instanceof Iterator) {
                return AbsHelper.externaliseIterator((Iterator)obj, referenceOnto, "sequence");
            }
            if (obj instanceof AID) {
                return AbsHelper.externaliseAID((AID)obj);
            }
            if (obj instanceof Property) {
                return AbsHelper.externaliseProperty((Property)obj, referenceOnto);
            }
            if (obj instanceof ContentElementList) {
                return AbsHelper.externaliseContentElementList((ContentElementList)obj, referenceOnto);
            }
            if (obj instanceof TrueProposition) {
                AbsPredicate absTrueProp = new AbsPredicate("true");
                return absTrueProp;
            }
            if (obj instanceof FalseProposition) {
                AbsPredicate absTrueProp = new AbsPredicate("false");
                return absTrueProp;
            }
            if (obj instanceof Done) {
                AbsPredicate absDone = new AbsPredicate("done");
                absDone.set("action", (AbsAgentAction)referenceOnto.fromObject(((Done)obj).getAction()));
                if (((Done)obj).getCondition() != null) {
                    absDone.set("condition", (AbsPredicate)referenceOnto.fromObject(((Done)obj).getCondition()));
                }
                return absDone;
            }
            if (obj instanceof Result) {
                AbsPredicate absResult = new AbsPredicate("result");
                absResult.set("action", (AbsAgentAction)referenceOnto.fromObject(((Result)obj).getAction()));
                absResult.set("value", (AbsTerm)referenceOnto.fromObject(((Result)obj).getValue()));
                return absResult;
            }
            if (obj instanceof Equals) {
                AbsPredicate absEquals = new AbsPredicate("=");
                absEquals.set("left", (AbsTerm)referenceOnto.fromObject(((Equals)obj).getLeft()));
                absEquals.set("right", (AbsTerm)referenceOnto.fromObject(((Equals)obj).getRight()));
                return absEquals;
            }
            if (obj instanceof Action) {
                AbsAgentAction absAction = new AbsAgentAction("action");
                ((Action)obj).externalise(absAction, referenceOnto);
                return absAction;
            }
            if (obj instanceof ACLMessage) {
                return AbsHelper.externaliseACLMessage((ACLMessage)obj, referenceOnto);
            }
            if (obj instanceof ConceptSlotFunction) {
                ConceptSlotFunction csf = (ConceptSlotFunction)obj;
                AbsObject absConcept = referenceOnto.fromObject(csf.getConcept());
                AbsConcept absCsf = new AbsConcept(csf.getSlotName());
                absCsf.set("CSF_CONCEPT", absConcept);
                return absCsf;
            }
            throw new UnknownSchemaException();
        }
        catch (OntologyException oe) {
            throw oe;
        }
        catch (Throwable t) {
            throw new OntologyException("Unexpected error externalising " + obj + ".", t);
        }
    }

    @Override
    public ObjectSchema getSchema(String name) throws OntologyException {
        int perf;
        ObjectSchema ret = super.getSchema(name);
        if (ret == null && (perf = ACLMessage.getInteger(name)) != -1) {
            ret = this.createMsgSchema(name);
        }
        return ret;
    }

    public ObjectSchema getSchema(Class clazz) throws OntologyException {
        ObjectSchema schema = (ObjectSchema)this.primitiveSchemas.get(clazz);
        if (schema == null) {
            schema = super.getSchema(clazz);
        }
        return schema;
    }

    private ObjectSchema createMsgSchema(String performative) throws OntologyException {
        AgentActionSchema msgSchema = new AgentActionSchema(performative);
        msgSchema.addSuperSchema((AgentActionSchema)this.getSchema("fipa-acl-message"));
        return msgSchema;
    }

    public static Object adjustPrimitiveValue(Object srcValue, Class destClass) {
        Class<?> srcClass;
        Object destValue = srcValue;
        if (srcValue != null && (srcClass = srcValue.getClass()) != destClass) {
            if (destClass == Integer.class || destClass == Integer.TYPE) {
                if (srcClass == Long.class) {
                    destValue = new Integer(((Long)srcValue).intValue());
                } else if (srcClass == String.class) {
                    destValue = new Integer(Integer.parseInt((String)srcValue));
                }
            } else if (destClass == Long.class || destClass == Long.TYPE) {
                if (srcClass == Integer.class) {
                    destValue = new Long(((Integer)srcValue).longValue());
                } else if (srcClass == String.class) {
                    destValue = new Long(Long.parseLong((String)srcValue));
                }
            } else if (destClass == Float.class || destClass == Float.TYPE) {
                if (srcClass == Integer.class) {
                    destValue = new Float(((Integer)srcValue).floatValue());
                } else if (srcClass == Long.class) {
                    destValue = new Float(((Long)srcValue).floatValue());
                } else if (srcClass == Double.class) {
                    destValue = new Float(((Double)srcValue).floatValue());
                } else if (srcClass == String.class) {
                    destValue = new Float(Float.parseFloat((String)srcValue));
                }
            } else if (destClass == Double.class || destClass == Double.TYPE) {
                if (srcClass == Integer.class) {
                    destValue = new Double(((Integer)srcValue).doubleValue());
                } else if (srcClass == Long.class) {
                    destValue = new Double(((Long)srcValue).doubleValue());
                } else if (srcClass == Float.class) {
                    destValue = new Double(((Float)srcValue).doubleValue());
                } else if (srcClass == String.class) {
                    destValue = new Double(Double.parseDouble((String)srcValue));
                }
            } else if (destClass == String.class) {
                destValue = srcValue.toString();
            } else if (destClass == Boolean.class || destClass == Boolean.TYPE) {
                if (srcClass == String.class) {
                    String s = (String)srcValue;
                    if (s.equalsIgnoreCase("true")) {
                        destValue = new Boolean(true);
                    } else if (s.equalsIgnoreCase("false")) {
                        destValue = new Boolean(false);
                    }
                }
            } else if (destClass == Date.class) {
                try {
                    destValue = ISO8601.toDate(srcValue.toString());
                }
                catch (Exception e) {
                    try {
                        SimpleDateFormat W3CISO8601DateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                        destValue = W3CISO8601DateFormat.parse(srcValue.toString());
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        }
        return destValue;
    }

    public static Object resolveNumericValue(Object srcValue, Class destClass) {
        return BasicOntology.adjustPrimitiveValue(srcValue, destClass);
    }

    static {
        theInstance.initialize();
    }
}

