/*
 * Decompiled with CFR 0.152.
 */
package jade.content.schema;

import jade.content.abs.AbsObject;
import jade.content.abs.AbsPrimitive;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.ObjectSchema;
import jade.content.schema.TermSchema;

public class PrimitiveSchema
extends TermSchema {
    public static final String BASE_NAME = "Primitive";
    private static PrimitiveSchema baseSchema = new PrimitiveSchema();

    private PrimitiveSchema() {
        super(BASE_NAME);
    }

    public PrimitiveSchema(String typeName) {
        super(typeName);
    }

    public static ObjectSchema getBaseSchema() {
        return baseSchema;
    }

    @Override
    public AbsObject newInstance() throws OntologyException {
        return new AbsPrimitive(this.getTypeName());
    }

    @Override
    public void validate(AbsObject abs, Ontology onto) throws OntologyException {
        if (!(abs instanceof AbsPrimitive)) {
            throw new OntologyException(abs + " is not an AbsPrimitive");
        }
    }

    @Override
    protected boolean descendsFrom(ObjectSchema s) {
        if (s != null) {
            if (s.equals(PrimitiveSchema.getBaseSchema())) {
                return true;
            }
            return super.descendsFrom(s);
        }
        return false;
    }

    @Override
    public boolean isAssignableFrom(ObjectSchema s) {
        if (s != null && s instanceof PrimitiveSchema) {
            String srcTypeName = s.getTypeName();
            String destTypeName = this.getTypeName();
            if (destTypeName.equals(srcTypeName)) {
                return true;
            }
        }
        return false;
    }
}

