/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.AgentContainerImpl;
import jade.core.Profile;
import jade.core.sam.CounterValueProvider;
import jade.core.sam.SAMHelper;
import jade.core.sam.SAMService;
import jade.imtp.leap.JICP.Connection;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

class JVM {
    public static final String JVM_NAME = "jvm-name";
    public static final String ENABLE_GLOBAL_MONITORING = "enable-global-monitoring";
    private static boolean initialized = false;

    JVM() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void started(AgentContainerImpl aci, Profile p) {
        if (!p.getBooleanProperty(ENABLE_GLOBAL_MONITORING, false)) return;
        Class<JVM> clazz = JVM.class;
        synchronized (JVM.class) {
            if (initialized) return;
            try {
                SAMHelper helper = SAMService.getSingletonHelper();
                if (helper == null) return;
                String jvmName = aci.getProperty(JVM_NAME, aci.getID().getName());
                String hostName = Profile.getDefaultNetworkName(p.getBooleanProperty("priviledge-logical-name", false));
                String suffix = "#" + hostName + "#" + jvmName;
                helper.addCounterValueProvider("openSockets" + suffix, new CounterValueProvider(){

                    @Override
                    public long getValue() {
                        return Connection.socketCnt;
                    }

                    @Override
                    public boolean isDifferential() {
                        return false;
                    }
                });
                helper.addCounterValueProvider("threads" + suffix, new CounterValueProvider(){

                    @Override
                    public long getValue() {
                        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                        return threadMXBean.getThreadCount();
                    }

                    @Override
                    public boolean isDifferential() {
                        return false;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
    }
}

