/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.JadeClassLoader;
import jade.core.GenericCommand;
import jade.core.Node;
import jade.core.NodeEventListener;
import jade.core.ServiceException;
import jade.core.nodeMonitoring.NodeMonitoringService;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.Map;

public abstract class NodeFailureMonitor {
    private static NodeMonitoringService theMonitoringService;
    protected Node target;
    protected NodeEventListener listener;
    protected Map childNodes = new HashMap();

    public void start(Node n, NodeEventListener nel) {
        this.target = n;
        this.listener = nel;
    }

    public abstract void stop();

    public synchronized void addChild(Node n) {
        this.childNodes.put(n.getName(), n);
        System.out.println("FailureMonitor child added. " + this.childNodes.size());
    }

    public synchronized void removeChild(Node n) {
        this.childNodes.remove(n.getName());
        System.out.println("FailureMonitor child removed. " + this.childNodes.size());
    }

    public Node getNode() {
        return this.target;
    }

    protected synchronized void fireNodeAdded() {
        this.listener.nodeAdded(this.target);
        Iterator iter = this.childNodes.values().iterator();
        while (iter.hasNext()) {
            Node n = (Node)iter.next();
            this.listener.nodeAdded(n);
        }
    }

    protected synchronized void fireNodeRemoved() {
        this.listener.nodeRemoved(this.target);
        Iterator iter = this.childNodes.values().iterator();
        while (iter.hasNext()) {
            Node n = (Node)iter.next();
            this.listener.nodeRemoved(n);
        }
    }

    protected synchronized void fireNodeReachable() {
        this.listener.nodeReachable(this.target);
        this.issueNodeReachable(this.target);
        Iterator iter = this.childNodes.values().iterator();
        while (iter.hasNext()) {
            Node n = (Node)iter.next();
            this.listener.nodeReachable(n);
            this.issueNodeReachable(n);
        }
    }

    protected synchronized void fireNodeUnreachable() {
        this.listener.nodeUnreachable(this.target);
        this.issueNodeUnreachable(this.target);
        Iterator iter = this.childNodes.values().iterator();
        while (iter.hasNext()) {
            Node n = (Node)iter.next();
            this.listener.nodeUnreachable(n);
            this.issueNodeUnreachable(this.target);
        }
    }

    private void issueNodeReachable(Node n) {
        if (theMonitoringService != null) {
            GenericCommand cmd = new GenericCommand("Node-Unreachable", theMonitoringService.getName(), null);
            cmd.addParam(n);
            try {
                theMonitoringService.submit(cmd);
            }
            catch (ServiceException se) {
                se.printStackTrace();
            }
        }
    }

    private void issueNodeUnreachable(Node n) {
        if (theMonitoringService != null) {
            GenericCommand cmd = new GenericCommand("Node-Unreachable", theMonitoringService.getName(), null);
            cmd.addParam(n);
            try {
                theMonitoringService.submit(cmd);
            }
            catch (ServiceException se) {
                se.printStackTrace();
            }
        }
    }

    public String requireService() {
        return null;
    }

    public static NodeFailureMonitor getFailureMonitor() {
        NodeFailureMonitor nfm = null;
        if (theMonitoringService != null) {
            nfm = theMonitoringService.getFailureMonitor();
        }
        if (nfm == null) {
            nfm = NodeFailureMonitor.getDefaultFailureMonitor();
        }
        return nfm;
    }

    public static NodeFailureMonitor getDefaultFailureMonitor() {
        try {
            return (NodeFailureMonitor)JadeClassLoader.forName("jade.core.nodeMonitoring.BlockingNodeFailureMonitor").newInstance();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static void init(NodeMonitoringService nms) {
        theMonitoringService = nms;
    }
}

