/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.ContentException;
import jade.content.onto.Ontology;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.behaviours.BaseInitiator;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import java.util.Date;

public class ActionExecutor<ActionT extends AgentAction, ResultT>
extends BaseInitiator {
    private static final long serialVersionUID = 54354676089783L;
    protected ActionT action;
    protected ResultT result;
    protected AID actor;
    protected String language = "fipa-sl";
    protected Ontology ontology;
    protected long timeout = 30000L;
    protected String conversationId = null;

    public ActionExecutor(ActionT action, Ontology ontology, AID actor) {
        this.action = action;
        this.ontology = ontology;
        this.actor = actor;
    }

    public void setAction(ActionT action) {
        this.action = action;
    }

    public void setActor(AID actor) {
        this.actor = actor;
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public ResultT getResult() {
        return this.result;
    }

    public AID getActualActor() {
        AID actualActor = null;
        ACLMessage reply = (ACLMessage)this.getDataStore().get(this.REPLY_K);
        if (reply != null && reply.getPerformative() != 6 && !reply.getSender().getLocalName().equalsIgnoreCase("AMS")) {
            actualActor = reply.getSender();
        }
        return actualActor;
    }

    protected AID retrieveActor() throws FIPAException {
        throw new FIPAException("Cannot retrieve actor for action " + this.action);
    }

    @Override
    protected ACLMessage createInitiation() {
        this.checkLanguage(this.language);
        this.checkOntology(this.ontology);
        try {
            if (this.actor == null) {
                this.actor = this.retrieveActor();
                if (this.actor == null) {
                    this.outcome.error("Actor for action " + this.action.getClass().getSimpleName() + " not found", null);
                    return null;
                }
            }
            Action actExpr = new Action(this.actor, (Concept)this.action);
            ACLMessage request = new ACLMessage(16);
            request.addReceiver(this.actor);
            request.setLanguage(this.language);
            request.setOntology(this.ontology.getName());
            request.setConversationId(this.conversationId);
            if (this.timeout > 0L) {
                request.setReplyByDate(new Date(System.currentTimeMillis() + this.timeout));
            }
            this.myAgent.getContentManager().fillContent(request, actExpr);
            return request;
        }
        catch (ContentException ce) {
            this.outcome.error("Error encoding " + this.action.getClass().getSimpleName() + " request", ce);
        }
        catch (FIPAException fe) {
            this.outcome.error("Error searching for actor for action " + this.action.getClass().getSimpleName(), fe);
        }
        catch (Exception e) {
            this.outcome.error("Unexpected error", e);
        }
        return null;
    }

    @Override
    public void handleInform(ACLMessage inform) {
        try {
            ContentElement el = this.myAgent.getContentManager().extractContent(inform);
            if (el instanceof Result) {
                Result r = (Result)el;
                this.result = this.extractResult(r);
            }
        }
        catch (Exception e) {
            this.outcome.error("Error decoding response", e);
        }
    }

    protected ResultT extractResult(Result r) {
        return (ResultT)r.getValue();
    }
}

