/*
 * Decompiled with CFR 0.152.
 */
package jade.core.management;

import jade.JadeClassLoader;
import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.AgentState;
import jade.core.BaseService;
import jade.core.ContainerID;
import jade.core.Filter;
import jade.core.GenericCommand;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.MainContainer;
import jade.core.NameClashException;
import jade.core.Node;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.Sink;
import jade.core.VerticalCommand;
import jade.core.management.AgentManagementSlice;
import jade.core.management.CodeLocator;
import jade.core.management.JarClassLoader;
import jade.security.Credentials;
import jade.security.JADEPrincipal;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.ObjectManager;
import jade.util.leap.Properties;
import java.io.File;
import java.io.IOException;

public class AgentManagementService
extends BaseService {
    public static final String NAME = "jade.core.management.AgentManagement";
    public static final String CLASS_CODE = "code";
    public static final String CLASS_STATE = "state";
    public static final String AGENTS_PATH = "jade_core_management_AgentManagementService_agentspath";
    private static final String[] OWNED_COMMANDS = new String[]{"Request-Create", "Request-Kill", "Request-State-Change", "Inform-Created", "Inform-Killed", "Inform-State-Changed", "Kill-Container", "Add-Tool", "Remove-Tool"};
    private AgentContainer myContainer;
    private final ServiceComponent localSlice = new ServiceComponent();
    private final CommandSourceSink senderSink = new CommandSourceSink();
    private final CommandTargetSink receiverSink = new CommandTargetSink();
    private String agentsPath = null;
    private CodeLocator codeLocator;

    @Override
    public void init(AgentContainer ac, Profile p) throws ProfileException {
        super.init(ac, p);
        this.myContainer = ac;
        this.agentsPath = p.getParameter(AGENTS_PATH, ".");
        ObjectManager.addLoader("agent", new ObjectManager.Loader(){

            @Override
            public Object load(String className, Properties pp) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
                String jarName = pp.getProperty(AgentManagementService.CLASS_CODE);
                boolean warnIfJarNotFound = true;
                if (jarName == null) {
                    jarName = className.replace('.', '_') + ".jar";
                    warnIfJarNotFound = false;
                }
                jarName = AgentManagementService.this.agentsPath + File.separator + jarName;
                File file = new File(jarName);
                try {
                    if (file.exists()) {
                        JarClassLoader loader = new JarClassLoader(file, this.getClass().getClassLoader());
                        return (Agent)JadeClassLoader.forName(className, true, loader).newInstance();
                    }
                    if (warnIfJarNotFound) {
                        AgentManagementService.this.myLogger.log(Logger.WARNING, "Jar file " + jarName + " for class " + className + " does not exist");
                    }
                }
                catch (IOException ioe) {
                    AgentManagementService.this.myLogger.log(Logger.WARNING, "File " + file.getPath() + " is not a valid Jar file.");
                }
                return null;
            }
        });
        this.codeLocator = new CodeLocator();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Class<?> getHorizontalInterface() {
        try {
            return JadeClassLoader.forName("jade.core.management.AgentManagementSlice");
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    @Override
    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    @Override
    public Filter getCommandFilter(boolean direction) {
        return null;
    }

    @Override
    public Sink getCommandSink(boolean side) {
        if (!side) {
            return this.senderSink;
        }
        return this.receiverSink;
    }

    @Override
    public String[] getOwnedCommands() {
        return OWNED_COMMANDS;
    }

    public void removeLocalAgent(AID target) {
        this.myContainer.removeLocalAgent(target);
    }

    public CodeLocator getCodeLocator() {
        return this.codeLocator;
    }

    private void initAgent(AID target, Agent instance, VerticalCommand vCmd) throws IMTPException, JADESecurityException, NameClashException, NotFoundException, ServiceException {
        Agent old;
        if (this.isLoadedFromSeparateSpace(instance)) {
            try {
                this.codeLocator.registerAgent(target, instance.getClass().getClassLoader());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (instance == (old = this.myContainer.addLocalAgent(target, instance))) {
            old = null;
        }
        try {
            AgentManagementSlice mainSlice = (AgentManagementSlice)this.getSlice("$$$Main-Slice$$$");
            AID cloned = (AID)target.clone();
            cloned.addUserDefinedSlot("JADE-agent-classname", instance.getClass().getName());
            try {
                mainSlice.bornAgent(cloned, this.myContainer.getID(), vCmd);
            }
            catch (IMTPException imtpe) {
                mainSlice = (AgentManagementSlice)this.getFreshSlice("$$$Main-Slice$$$");
                mainSlice.bornAgent(cloned, this.myContainer.getID(), vCmd);
            }
            this.customize(instance);
        }
        catch (NameClashException nce) {
            this.removeLocalAgent(target);
            if (old != null) {
                this.myContainer.addLocalAgent(target, old);
            }
            throw nce;
        }
        catch (IMTPException imtpe) {
            this.removeLocalAgent(target);
            throw imtpe;
        }
        catch (NotFoundException nfe) {
            this.removeLocalAgent(target);
            throw nfe;
        }
        catch (JADESecurityException ae) {
            this.removeLocalAgent(target);
            throw ae;
        }
    }

    private boolean isLoadedFromSeparateSpace(Object obj) {
        try {
            Class<?> c = obj.getClass();
            Class<?> reloadedClass = JadeClassLoader.forName(c.getName(), true, this.getClass().getClassLoader());
            if (c == reloadedClass) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    private void customize(Agent agent) {
    }

    @Override
    protected Service.Slice getFreshSlice(String name) throws ServiceException {
        return super.getFreshSlice(name);
    }

    private class ServiceComponent
    implements Service.Slice {
        private ServiceComponent() {
        }

        @Override
        public Service getService() {
            return AgentManagementService.this;
        }

        @Override
        public Node getNode() throws ServiceException {
            try {
                return AgentManagementService.this.getLocalNode();
            }
            catch (IMTPException imtpe) {
                throw new ServiceException("Problem in contacting the IMTP Manager", imtpe);
            }
        }

        @Override
        public VerticalCommand serve(HorizontalCommand cmd) {
            GenericCommand result = null;
            try {
                String cmdName = cmd.getName();
                Object[] params = cmd.getParams();
                if (cmdName.equals("1")) {
                    GenericCommand gCmd = new GenericCommand("Request-Create", AgentManagementService.NAME, null);
                    AID agentID = (AID)params[0];
                    String className = (String)params[1];
                    Object[] arguments = (Object[])params[2];
                    JADEPrincipal owner = (JADEPrincipal)params[3];
                    Credentials initialCredentials = (Credentials)params[4];
                    Boolean startIt = (Boolean)params[5];
                    gCmd.addParam(agentID);
                    gCmd.addParam(className);
                    gCmd.addParam(arguments);
                    gCmd.addParam(owner);
                    gCmd.addParam(initialCredentials);
                    gCmd.addParam(startIt);
                    result = gCmd;
                } else if (cmdName.equals("2")) {
                    GenericCommand gCmd = new GenericCommand("Request-Kill", AgentManagementService.NAME, null);
                    AID agentID = (AID)params[0];
                    gCmd.addParam(agentID);
                    result = gCmd;
                } else if (cmdName.equals("3")) {
                    GenericCommand gCmd = new GenericCommand("Request-State-Change", AgentManagementService.NAME, null);
                    AID agentID = (AID)params[0];
                    Integer newState = (Integer)params[1];
                    gCmd.addParam(agentID);
                    gCmd.addParam(newState);
                    result = gCmd;
                } else if (cmdName.equals("4")) {
                    GenericCommand gCmd = new GenericCommand("Inform-Created", AgentManagementService.NAME, null);
                    AID agentID = (AID)params[0];
                    ContainerID cid = (ContainerID)params[1];
                    gCmd.addParam(agentID);
                    gCmd.addParam(cid);
                    JADEPrincipal owner = cmd.getPrincipal();
                    if (AgentManagementService.this.myLogger.isLoggable(Logger.FINE)) {
                        String ownerInfo = owner != null ? ", Owner = " + owner : "";
                        AgentManagementService.this.myLogger.log(Logger.CONFIG, "Local slice processing H-command BORN_AGENT. Name is " + agentID.getName() + ownerInfo);
                    }
                    result = gCmd;
                } else if (cmdName.equals("5")) {
                    GenericCommand gCmd = new GenericCommand("Inform-Killed", AgentManagementService.NAME, null);
                    AID agentID = (AID)params[0];
                    gCmd.addParam(agentID);
                    result = gCmd;
                } else if (cmdName.equals("6")) {
                    GenericCommand gCmd = new GenericCommand("Inform-State-Changed", AgentManagementService.NAME, null);
                    AID agentID = (AID)params[0];
                    gCmd.addParam(agentID);
                    gCmd.addParam("suspended");
                    gCmd.addParam("*");
                    result = gCmd;
                } else if (cmdName.equals("7")) {
                    GenericCommand gCmd = new GenericCommand("Inform-State-Changed", AgentManagementService.NAME, null);
                    AID agentID = (AID)params[0];
                    gCmd.addParam(agentID);
                    gCmd.addParam("active");
                    gCmd.addParam("suspended");
                    result = gCmd;
                } else if (cmdName.equals("8")) {
                    GenericCommand gCmd;
                    result = gCmd = new GenericCommand("Kill-Container", AgentManagementService.NAME, null);
                }
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
            return result;
        }
    }

    private class CommandTargetSink
    implements Sink {
        private CommandTargetSink() {
        }

        @Override
        public void consume(VerticalCommand cmd) {
            String name = cmd.getName();
            try {
                if (name.equals("Request-Create")) {
                    this.handleRequestCreate(cmd);
                } else if (name.equals("Request-Kill")) {
                    this.handleRequestKill(cmd);
                } else if (name.equals("Request-State-Change")) {
                    this.handleRequestStateChange(cmd);
                } else if (name.equals("Inform-Killed")) {
                    this.handleInformKilled(cmd);
                } else if (name.equals("Inform-State-Changed")) {
                    this.handleInformStateChanged(cmd);
                } else if (name.equals("Inform-Created")) {
                    this.handleInformCreated(cmd);
                } else if (name.equals("Kill-Container")) {
                    this.handleKillContainer(cmd);
                }
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
        }

        private void handleRequestCreate(VerticalCommand cmd) throws IMTPException, JADESecurityException, NotFoundException, NameClashException, ServiceException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            String className = (String)params[1];
            Object[] arguments = (Object[])params[2];
            JADEPrincipal owner = (JADEPrincipal)params[3];
            Credentials initialCredentials = (Credentials)params[4];
            boolean startIt = (Boolean)params[5];
            if (AgentManagementService.this.myLogger.isLoggable(Logger.FINE)) {
                String ownerInfo = owner != null ? ", Owner = " + owner : "";
                AgentManagementService.this.myLogger.log(Logger.FINE, "Target sink consuming command REQUEST_CREATE: Name is " + agentID.getName() + ownerInfo);
            }
            this.createAgent(agentID, className, arguments, owner, initialCredentials, startIt);
        }

        private void handleRequestKill(VerticalCommand cmd) throws IMTPException, JADESecurityException, NotFoundException, ServiceException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            if (AgentManagementService.this.myLogger.isLoggable(Logger.FINE)) {
                AgentManagementService.this.myLogger.log(Logger.FINE, "Target sink consuming command REQUEST_KILL: Name is " + agentID.getName());
            }
            this.killAgent(agentID);
        }

        private void handleRequestStateChange(VerticalCommand cmd) throws IMTPException, JADESecurityException, NotFoundException, ServiceException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            int newState = (Integer)params[1];
            this.changeAgentState(agentID, newState);
        }

        private void handleInformCreated(VerticalCommand cmd) throws NotFoundException, NameClashException, ServiceException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            ContainerID cid = (ContainerID)params[1];
            if (AgentManagementService.this.myLogger.isLoggable(Logger.FINE)) {
                AgentManagementService.this.myLogger.log(Logger.FINE, "Target sink consuming command INFORM_CREATED: Name is " + agentID.getName());
            }
            this.bornAgent(agentID, cid, cmd.getPrincipal(), cmd.getCredentials());
        }

        private void handleInformKilled(VerticalCommand cmd) throws NotFoundException, ServiceException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            if (AgentManagementService.this.myLogger.isLoggable(Logger.FINE)) {
                AgentManagementService.this.myLogger.log(Logger.FINE, "Target sink consuming command INFORM_KILLED: Name is " + agentID.getName());
            }
            this.deadAgent(agentID);
        }

        private void handleInformStateChanged(VerticalCommand cmd) throws NotFoundException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            String newState = (String)params[1];
            String oldState = (String)params[2];
            if (newState.equals("suspended")) {
                this.suspendedAgent(agentID);
            } else if (newState.equals("active")) {
                this.resumedAgent(agentID);
            }
        }

        private void handleKillContainer(VerticalCommand cmd) {
            if (AgentManagementService.this.myLogger.isLoggable(Logger.FINE)) {
                AgentManagementService.this.myLogger.log(Logger.FINE, "Target sink consuming command KILL_CONTAINER");
            }
            this.exitContainer();
        }

        private void createAgent(AID agentID, String className, Object[] arguments, JADEPrincipal owner, Credentials initialCredentials, boolean startIt) throws IMTPException, NotFoundException, NameClashException, JADESecurityException {
            Agent agent = null;
            try {
                agent = (Agent)ObjectManager.load(className, "agent");
                if (agent == null) {
                    agent = (Agent)JadeClassLoader.forName(className).newInstance();
                }
                agent.setArguments(arguments);
                AgentManagementService.this.myContainer.initAgent(agentID, agent, owner, initialCredentials);
                if (startIt) {
                    AgentManagementService.this.myContainer.powerUpLocalAgent(agentID);
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new IMTPException("Class " + className + " for agent " + agentID + " not found", cnfe);
            }
            catch (InstantiationException ie) {
                throw new IMTPException("Class " + className + " for agent " + agentID + " cannot be instantiated", ie);
            }
            catch (Throwable t) {
                AgentManagementService.this.myLogger.log(Logger.WARNING, "Unexpected error creating agent " + agentID.getName(), t);
                throw new IMTPException("Unexpected error creating agent " + agentID, t);
            }
        }

        private void killAgent(AID agentID) throws IMTPException, NotFoundException {
            Agent a = AgentManagementService.this.myContainer.acquireLocalAgent(agentID);
            if (a == null) {
                throw new NotFoundException("Kill-Agent failed to find " + agentID);
            }
            a.doDelete();
            AgentManagementService.this.myContainer.releaseLocalAgent(agentID);
        }

        private void changeAgentState(AID agentID, int newState) throws IMTPException, NotFoundException {
            Agent a = AgentManagementService.this.myContainer.acquireLocalAgent(agentID);
            if (a == null) {
                throw new NotFoundException("Change-Agent-State failed to find " + agentID);
            }
            if (newState == 4) {
                a.doSuspend();
            } else if (newState == 5) {
                a.doWait();
            } else if (newState == 2) {
                int oldState = a.getState();
                if (oldState == 4) {
                    a.doActivate();
                } else {
                    a.doWake();
                }
            }
            AgentManagementService.this.myContainer.releaseLocalAgent(agentID);
        }

        private void bornAgent(AID name, ContainerID cid, JADEPrincipal principal, Credentials credentials) throws NameClashException, NotFoundException {
            MainContainer impl = AgentManagementService.this.myContainer.getMain();
            if (impl != null) {
                JADEPrincipal ownerPr;
                String ownership = "NONE";
                if (credentials != null && (ownerPr = credentials.getOwner()) != null) {
                    ownership = ownerPr.getName();
                }
                try {
                    impl.bornAgent(name, cid, principal, ownership, false);
                }
                catch (NameClashException nce) {
                    try {
                        ContainerID oldCid = impl.getContainerID(name);
                        if (oldCid != null) {
                            Node n = impl.getContainerNode(oldCid).getNode();
                            n.ping(false);
                            throw nce;
                        }
                        throw nce;
                    }
                    catch (NameClashException nce2) {
                        throw nce2;
                    }
                    catch (Exception e) {
                        impl.bornAgent(name, cid, principal, ownership, true);
                    }
                }
            }
        }

        private void deadAgent(AID name) throws NotFoundException {
            MainContainer impl = AgentManagementService.this.myContainer.getMain();
            if (impl != null) {
                impl.deadAgent(name, false);
            }
        }

        private void suspendedAgent(AID name) throws NotFoundException {
            MainContainer impl = AgentManagementService.this.myContainer.getMain();
            if (impl != null) {
                impl.suspendedAgent(name);
            }
        }

        private void resumedAgent(AID name) throws NotFoundException {
            MainContainer impl = AgentManagementService.this.myContainer.getMain();
            if (impl != null) {
                impl.resumedAgent(name);
            }
        }

        private void exitContainer() {
            AgentManagementService.this.myContainer.shutDown();
        }
    }

    private class CommandSourceSink
    implements Sink {
        private CommandSourceSink() {
        }

        @Override
        public void consume(VerticalCommand cmd) {
            String name = cmd.getName();
            try {
                if (name.equals("Request-Create")) {
                    this.handleRequestCreate(cmd);
                } else if (name.equals("Request-Kill")) {
                    this.handleRequestKill(cmd);
                } else if (name.equals("Request-State-Change")) {
                    this.handleRequestStateChange(cmd);
                } else if (name.equals("Inform-Created")) {
                    this.handleInformCreated(cmd);
                } else if (name.equals("Inform-Killed")) {
                    this.handleInformKilled(cmd);
                } else if (name.equals("Inform-State-Changed")) {
                    this.handleInformStateChanged(cmd);
                } else if (name.equals("Kill-Container")) {
                    this.handleKillContainer(cmd);
                } else if (name.equals("Add-Tool")) {
                    this.handleAddTool(cmd);
                } else if (name.equals("Remove-Tool")) {
                    this.handleRemoveTool(cmd);
                }
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
        }

        private void handleRequestCreate(VerticalCommand cmd) throws IMTPException, JADESecurityException, NotFoundException, NameClashException, ServiceException {
            MainContainer impl;
            Object[] params = cmd.getParams();
            String name = (String)params[0];
            String className = (String)params[1];
            Object[] args = (Object[])params[2];
            ContainerID cid = (ContainerID)params[3];
            JADEPrincipal owner = (JADEPrincipal)params[4];
            Credentials initialCredentials = (Credentials)params[5];
            if (AgentManagementService.this.myLogger.isLoggable(Logger.CONFIG)) {
                AgentManagementService.this.myLogger.log(Logger.CONFIG, "Source Sink consuming command REQUEST_CREATE. Name is " + name);
            }
            if ((impl = AgentManagementService.this.myContainer.getMain()) != null) {
                AID agentID = new AID(AID.createGUID(name, AgentManagementService.this.myContainer.getPlatformID()), true);
                AgentManagementSlice targetSlice = (AgentManagementSlice)AgentManagementService.this.getSlice(cid.getName());
                if (targetSlice != null) {
                    try {
                        targetSlice.createAgent(agentID, className, args, owner, initialCredentials, true, cmd);
                    }
                    catch (IMTPException imtpe) {
                        targetSlice = (AgentManagementSlice)AgentManagementService.this.getFreshSlice(cid.getName());
                        targetSlice.createAgent(agentID, className, args, owner, initialCredentials, true, cmd);
                    }
                } else {
                    throw new NotFoundException("Container " + cid.getName() + " not found");
                }
            }
        }

        private void handleRequestKill(VerticalCommand cmd) throws IMTPException, JADESecurityException, NotFoundException, ServiceException {
            MainContainer impl;
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            if (AgentManagementService.this.myLogger.isLoggable(Logger.CONFIG)) {
                AgentManagementService.this.myLogger.log(Logger.CONFIG, "Source Sink consuming command REQUEST_KILL. Name is " + agentID.getName());
            }
            if ((impl = AgentManagementService.this.myContainer.getMain()) != null) {
                ContainerID cid = impl.getContainerID(agentID);
                AgentManagementSlice targetSlice = (AgentManagementSlice)AgentManagementService.this.getSlice(cid.getName());
                try {
                    targetSlice.killAgent(agentID, cmd);
                }
                catch (IMTPException imtpe) {
                    targetSlice = (AgentManagementSlice)AgentManagementService.this.getFreshSlice(cid.getName());
                    targetSlice.killAgent(agentID, cmd);
                }
            }
        }

        private void handleRequestStateChange(VerticalCommand cmd) throws IMTPException, JADESecurityException, NotFoundException, ServiceException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            AgentState as = (AgentState)params[1];
            int newState = 0;
            if (as.equals("suspended")) {
                newState = 4;
            } else if (as.equals("waiting")) {
                newState = 5;
            } else if (as.equals("active")) {
                newState = 2;
            }
            MainContainer impl = AgentManagementService.this.myContainer.getMain();
            if (impl != null) {
                ContainerID cid = impl.getContainerID(agentID);
                AgentManagementSlice targetSlice = (AgentManagementSlice)AgentManagementService.this.getSlice(cid.getName());
                try {
                    targetSlice.changeAgentState(agentID, newState);
                }
                catch (IMTPException imtpe) {
                    targetSlice = (AgentManagementSlice)AgentManagementService.this.getFreshSlice(cid.getName());
                    targetSlice.changeAgentState(agentID, newState);
                }
            }
        }

        private void handleInformCreated(VerticalCommand cmd) throws IMTPException, NotFoundException, NameClashException, JADESecurityException, ServiceException {
            Object[] params = cmd.getParams();
            AID target = (AID)params[0];
            Agent instance = (Agent)params[1];
            JADEPrincipal owner = (JADEPrincipal)params[2];
            if (AgentManagementService.this.myLogger.isLoggable(Logger.CONFIG)) {
                String ownerInfo = owner != null ? ", Owner = " + owner : "";
                AgentManagementService.this.myLogger.log(Logger.CONFIG, "Source Sink consuming command INFORM_CREATED. Name is " + target.getName() + ownerInfo);
            }
            AgentManagementService.this.initAgent(target, instance, cmd);
        }

        private void handleInformKilled(VerticalCommand cmd) throws IMTPException, NotFoundException, ServiceException {
            Object[] params = cmd.getParams();
            AID target = (AID)params[0];
            if (AgentManagementService.this.myLogger.isLoggable(Logger.CONFIG)) {
                AgentManagementService.this.myLogger.log(Logger.CONFIG, "Source Sink consuming command INFORM_KILLED. Name is " + target.getName());
            }
            AgentManagementService.this.codeLocator.removeAgent(target);
            AgentManagementService.this.removeLocalAgent(target);
            AgentManagementSlice mainSlice = (AgentManagementSlice)AgentManagementService.this.getSlice("$$$Main-Slice$$$");
            try {
                mainSlice.deadAgent(target, cmd);
            }
            catch (IMTPException imtpe) {
                mainSlice = (AgentManagementSlice)AgentManagementService.this.getFreshSlice("$$$Main-Slice$$$");
                mainSlice.deadAgent(target, cmd);
            }
        }

        private void handleInformStateChanged(VerticalCommand cmd) {
            Object[] params = cmd.getParams();
            AID target = (AID)params[0];
            AgentState from = (AgentState)params[1];
            AgentState to = (AgentState)params[2];
            if (to.equals("suspended")) {
                try {
                    AgentManagementSlice mainSlice = (AgentManagementSlice)AgentManagementService.this.getSlice("$$$Main-Slice$$$");
                    try {
                        mainSlice.suspendedAgent(target);
                    }
                    catch (IMTPException imtpe) {
                        mainSlice = (AgentManagementSlice)AgentManagementService.this.getFreshSlice("$$$Main-Slice$$$");
                        mainSlice.suspendedAgent(target);
                    }
                }
                catch (IMTPException re) {
                    re.printStackTrace();
                }
                catch (NotFoundException nfe) {
                    nfe.printStackTrace();
                }
                catch (ServiceException se) {
                    se.printStackTrace();
                }
            } else if (from.equals("suspended")) {
                try {
                    AgentManagementSlice mainSlice = (AgentManagementSlice)AgentManagementService.this.getSlice("$$$Main-Slice$$$");
                    try {
                        mainSlice.resumedAgent(target);
                    }
                    catch (IMTPException imtpe) {
                        mainSlice = (AgentManagementSlice)AgentManagementService.this.getFreshSlice("$$$Main-Slice$$$");
                        mainSlice.resumedAgent(target);
                    }
                }
                catch (IMTPException re) {
                    re.printStackTrace();
                }
                catch (NotFoundException nfe) {
                    nfe.printStackTrace();
                }
                catch (ServiceException se) {
                    se.printStackTrace();
                }
            }
        }

        private void handleKillContainer(VerticalCommand cmd) throws IMTPException, ServiceException, NotFoundException {
            Object[] params = cmd.getParams();
            ContainerID cid = (ContainerID)params[0];
            if (AgentManagementService.this.myLogger.isLoggable(Logger.CONFIG)) {
                AgentManagementService.this.myLogger.log(Logger.CONFIG, "Source Sink consuming command KILL_CONTAINER. Container is " + cid.getName());
            }
            AgentManagementSlice targetSlice = (AgentManagementSlice)AgentManagementService.this.getSlice(cid.getName());
            try {
                try {
                    targetSlice.exitContainer();
                }
                catch (IMTPException imtpe) {
                    targetSlice = (AgentManagementSlice)AgentManagementService.this.getFreshSlice(cid.getName());
                    targetSlice.exitContainer();
                }
            }
            catch (NullPointerException npe) {
                throw new NotFoundException("Container " + cid.getName() + " not found");
            }
        }

        private void handleAddTool(VerticalCommand cmd) {
            Object[] params = cmd.getParams();
            AID tool = (AID)params[0];
            MainContainer impl = AgentManagementService.this.myContainer.getMain();
            if (impl != null) {
                impl.toolAdded(tool);
            }
        }

        private void handleRemoveTool(VerticalCommand cmd) {
            Object[] params = cmd.getParams();
            AID tool = (AID)params[0];
            MainContainer impl = AgentManagementService.this.myContainer.getMain();
            if (impl != null) {
                impl.toolRemoved(tool);
            }
        }
    }
}

