/*
 * Decompiled with CFR 0.152.
 */
package jade.core.replication;

import jade.JadeClassLoader;
import jade.core.AgentContainer;
import jade.core.BaseService;
import jade.core.Command;
import jade.core.Filter;
import jade.core.GenericCommand;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.Node;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.ServiceManager;
import jade.core.Sink;
import jade.core.VerticalCommand;
import jade.core.replication.AddressNotificationSlice;
import jade.util.Logger;

public class AddressNotificationService
extends BaseService {
    private AgentContainer myContainer;
    private ServiceComponent localSlice;
    private final IncomingFilter incomingFilter = new IncomingFilter();
    private ServiceManager myServiceManager;

    @Override
    public void init(AgentContainer ac, Profile p) throws ProfileException {
        super.init(ac, p);
        this.myContainer = ac;
        this.localSlice = new ServiceComponent(p);
    }

    @Override
    public String getName() {
        return "jade.core.replication.AddressNotification";
    }

    @Override
    public Class<?> getHorizontalInterface() {
        try {
            return JadeClassLoader.forName("jade.core.replication.AddressNotificationSlice");
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    @Override
    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    @Override
    public Filter getCommandFilter(boolean direction) {
        if (!direction) {
            return this.incomingFilter;
        }
        return null;
    }

    @Override
    public Sink getCommandSink(boolean side) {
        return null;
    }

    @Override
    public String[] getOwnedCommands() {
        return null;
    }

    @Override
    public void boot(Profile p) throws ServiceException {
        try {
            Node n = this.getLocalNode();
            if (!n.hasPlatformManager()) {
                Service.Slice[] slices = this.getAllSlices();
                for (int i = 0; i < slices.length; ++i) {
                    AddressNotificationSlice slice = (AddressNotificationSlice)slices[i];
                    if (!slice.getNode().hasPlatformManager()) continue;
                    this.addAddress(slice.getServiceManagerAddress());
                }
            }
        }
        catch (Exception e) {
            throw new ServiceException("Boot failure", e);
        }
    }

    private void broadcastToSlices(HorizontalCommand cmd) throws IMTPException, ServiceException {
        Service.Slice[] slices = this.getAllSlices();
        for (int i = 0; i < slices.length; ++i) {
            AddressNotificationSlice slice = (AddressNotificationSlice)slices[i];
            if (slice.getNode().hasPlatformManager()) continue;
            slice.serve(cmd);
        }
    }

    private void addAddress(String addr) throws IMTPException {
        if (this.myLogger.isLoggable(Logger.CONFIG)) {
            this.myLogger.log(Logger.CONFIG, "Adding PlatformManager address " + addr);
        }
        this.myServiceManager.addAddress(addr);
    }

    private class ServiceComponent
    implements Service.Slice {
        public ServiceComponent(Profile p) {
            AddressNotificationService.this.myServiceManager = AddressNotificationService.this.myContainer.getServiceManager();
        }

        @Override
        public Service getService() {
            return AddressNotificationService.this;
        }

        @Override
        public Node getNode() throws ServiceException {
            try {
                return AddressNotificationService.this.getLocalNode();
            }
            catch (IMTPException imtpe) {
                throw new ServiceException("Problem in contacting the IMTP Manager", imtpe);
            }
        }

        @Override
        public VerticalCommand serve(HorizontalCommand cmd) {
            Command result;
            block5: {
                result = null;
                try {
                    String cmdName = cmd.getName();
                    Object[] params = cmd.getParams();
                    if (cmdName.equals("1")) {
                        String addr = (String)params[0];
                        this.addServiceManagerAddress(addr);
                    } else if (cmdName.equals("3")) {
                        cmd.setReturnValue(this.getServiceManagerAddress());
                    }
                }
                catch (Throwable t) {
                    cmd.setReturnValue(t);
                    if (result == null) break block5;
                    result.setReturnValue(t);
                }
            }
            return result;
        }

        private void addServiceManagerAddress(String addr) throws IMTPException {
            try {
                String localSMAddr = AddressNotificationService.this.myServiceManager.getLocalAddress();
                if (!addr.equals(localSMAddr)) {
                    AddressNotificationService.this.addAddress(addr);
                }
            }
            catch (IMTPException imtpe) {
                imtpe.printStackTrace();
            }
        }

        private String getServiceManagerAddress() throws IMTPException {
            return AddressNotificationService.this.myServiceManager.getLocalAddress();
        }
    }

    private class IncomingFilter
    extends Filter {
        private IncomingFilter() {
        }

        @Override
        public boolean accept(VerticalCommand cmd) {
            try {
                String name = cmd.getName();
                if (name.equals("New-Replica")) {
                    this.handleAddressAdded(cmd);
                }
            }
            catch (IMTPException imtpe) {
                imtpe.printStackTrace();
            }
            catch (ServiceException se) {
                se.printStackTrace();
            }
            return true;
        }

        public void handleAddressAdded(VerticalCommand cmd) throws IMTPException, ServiceException {
            Object[] params = cmd.getParams();
            String addr = (String)params[0];
            GenericCommand hCmd = new GenericCommand("1", "jade.core.replication.AddressNotification", null);
            hCmd.addParam(addr);
            AddressNotificationService.this.broadcastToSlices(hCmd);
        }
    }
}

