/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.imtp.leap.JICP.Connection;
import jade.mtp.TransportAddress;

class ConnectionWrapper {
    private Connection myConnection;
    private TransportAddress destAddr;
    private boolean oneShot;
    private boolean locked;
    private boolean closed;
    private boolean reused;
    private long lastUsage;
    private long nUsages;

    ConnectionWrapper(Connection c, TransportAddress ta) {
        this.myConnection = c;
        this.destAddr = ta;
        this.oneShot = false;
        this.reused = false;
        this.locked = true;
        this.closed = false;
        this.nUsages = 0L;
    }

    final Connection getConnection() {
        return this.myConnection;
    }

    final TransportAddress getDestAddress() {
        return this.destAddr;
    }

    final void setOneShot() {
        this.oneShot = true;
    }

    final boolean isOneShot() {
        return this.oneShot;
    }

    final void setReused() {
        this.reused = true;
    }

    final boolean isReused() {
        return this.reused;
    }

    synchronized boolean lock() {
        if (this.locked) {
            return false;
        }
        this.locked = true;
        return true;
    }

    synchronized void unlock() {
        this.locked = false;
        ++this.nUsages;
        this.lastUsage = System.currentTimeMillis();
        if (this.closed) {
            this.close();
        }
    }

    synchronized void close() {
        if (!this.locked) {
            try {
                this.myConnection.close();
            }
            catch (Exception exception) {}
        } else {
            this.closed = true;
        }
    }

    synchronized boolean isExpired(long currentTime) {
        if (!this.locked && currentTime - this.lastUsage > 120000L) {
            this.locked = true;
            return true;
        }
        return false;
    }

    public String toString() {
        return "[CW: nUsages=" + this.nUsages + ", lastUsage=" + this.lastUsage + "]";
    }
}

