/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.JadeClassLoader;
import jade.core.Profile;
import jade.imtp.leap.FrontEndStub;
import jade.imtp.leap.ICP;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.ConnectionFactory;
import jade.imtp.leap.JICP.JICPMediator;
import jade.imtp.leap.JICP.JICPMediatorManager;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.JICP.JICPPeer;
import jade.imtp.leap.JICP.PDPContextManager;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.Properties;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JICPServer
extends Thread
implements PDPContextManager.Listener,
JICPMediatorManager {
    private static final int INIT = 0;
    private static final int REQUEST_READ = 1;
    private static final int REQUEST_SERVED = 2;
    private static final int RESPONSE_SENT = 3;
    public static final String ACCEPT_LOCAL_HOST_ONLY = "jade_imtp_leap_JICP_JICPServer_acceptlocalhostonly";
    public static final String UNCHECK_LOCAL_HOST = "jade_imtp_leap_JICP_JICPServer_unchecklocalhost";
    private static final int LISTENING = 0;
    private static final int TERMINATING = 1;
    private int state = 0;
    private String host;
    private String exportHost;
    private Integer exportPort;
    private ServerSocket server;
    private ICP.Listener cmdListener;
    private int mediatorCnt = 1;
    private Hashtable mediators = new Hashtable();
    public static final String ACCEPT_MEDIATORS = "jade_imtp_leap_JICP_JICPServer_acceptmediators";
    private boolean acceptMediators = true;
    private Properties leapProps = new Properties();
    private PDPContextManager myPDPContextManager;
    private int maxHandlers;
    private Vector connectionHandlers = new Vector();
    private ConnectionFactory connFactory;
    private Logger myLogger;

    public JICPServer(Profile p, JICPPeer myPeer, ICP.Listener l, ConnectionFactory f, int max) throws ICPException {
        int idLength;
        this.cmdListener = l;
        this.connFactory = f;
        this.maxHandlers = max;
        this.myLogger = Logger.getMyLogger(this.getClass().getName());
        StringBuffer sb = null;
        String peerID = myPeer.getID();
        if (peerID != null) {
            sb = new StringBuffer(peerID);
            sb.append('-');
            idLength = sb.length();
        } else {
            sb = new StringBuffer();
            idLength = 0;
        }
        sb.append("local-host");
        this.host = p.getParameter(sb.toString(), null);
        boolean acceptLocalHostOnly = false;
        if (this.host == null || this.host.equals("localhost")) {
            sb.setLength(idLength);
            sb.append("remote-url");
            String remoteURL = p.getParameter(sb.toString(), null);
            this.host = remoteURL != null ? myPeer.getAddress(remoteURL) : Profile.getDefaultNetworkName(p.getBooleanProperty("priviledge-logical-name", false));
        } else {
            if (!p.getBooleanProperty(UNCHECK_LOCAL_HOST, false) && !Profile.isLocalHost(this.host)) {
                throw new ICPException("Error: Not possible to launch JADE on a remote host (" + this.host + "). Check the -host and -local-host options.");
            }
            acceptLocalHostOnly = p.getBooleanProperty(ACCEPT_LOCAL_HOST_ONLY, false);
        }
        int port = 1099;
        boolean changePortIfBusy = !p.getBooleanProperty("main", true) || p.getBooleanProperty("jade_imtp_leap_LEAPIMTPManager_changeportifbusy", false);
        sb.setLength(idLength);
        sb.append("local-port");
        String strPort = p.getParameter(sb.toString(), null);
        try {
            port = Integer.parseInt(strPort);
        }
        catch (Exception e) {
            try {
                port = Integer.parseInt(peerID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int[] portRange = null;
        sb.setLength(idLength);
        sb.append("local-port-range");
        String strPortRange = p.getParameter(sb.toString(), null);
        if (strPortRange != null) {
            try {
                String[] r = strPortRange.split("-");
                int rMin = Integer.parseInt(r[0]);
                int rMax = Integer.parseInt(r[1]);
                int rSize = rMax - rMin;
                portRange = new int[rSize];
                for (int i = 0; i < rSize; ++i) {
                    portRange[i] = rMin + i;
                }
            }
            catch (Exception e) {
                this.myLogger.log(Logger.WARNING, "Wrong local-port-range format " + strPortRange + ". Must be <min>-<max>. " + e);
            }
        }
        this.acceptMediators = p.getBooleanProperty(ACCEPT_MEDIATORS, true);
        if (this.acceptMediators) {
            sb.setLength(idLength);
            sb.append("leap-property-file");
            String fileName = p.getParameter(sb.toString(), "leap.properties");
            try {
                this.leapProps.load(fileName);
            }
            catch (Exception e) {
                this.myLogger.log(Logger.FINE, "Can't read LEAP property file " + fileName + ". " + e);
            }
            String pdpContextManagerClass = this.leapProps.getProperty("pdp-context-manager");
            if (pdpContextManagerClass != null) {
                try {
                    this.myLogger.log(Logger.INFO, "Loading PDPContextManager of class " + pdpContextManagerClass);
                    this.myPDPContextManager = (PDPContextManager)JadeClassLoader.forName(pdpContextManagerClass).newInstance();
                    this.myPDPContextManager.init(this.leapProps);
                    this.myPDPContextManager.registerListener(this);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    this.myPDPContextManager = null;
                }
            }
        }
        if (portRange == null) {
            this.server = myPeer.getServerSocket(acceptLocalHostOnly ? this.host : null, port, changePortIfBusy);
        } else {
            for (int i = 0; i < portRange.length; ++i) {
                void pi = portRange[i];
                try {
                    this.server = myPeer.getServerSocket(acceptLocalHostOnly ? this.host : null, (int)pi, false);
                    break;
                }
                catch (ICPException iCPException) {
                    continue;
                }
            }
            if (this.server == null) {
                throw new ICPException("Cannot bind server socket to " + (this.host != null ? "host " + this.host : "localhost") + " and any ports in range " + strPortRange);
            }
        }
        this.setDaemon(true);
        this.setName("JICPServer-" + this.getLocalPort());
        this.exportHost = p.getParameter("export-host", null);
        String exportPortStr = p.getParameter("export-port", null);
        try {
            this.exportPort = Integer.getInteger(exportPortStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int getLocalPort() {
        return this.exportPort != null ? this.exportPort.intValue() : this.server.getLocalPort();
    }

    @Override
    public String getLocalHost() {
        return this.exportHost != null ? this.exportHost : this.host;
    }

    public synchronized void shutdown() {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Shutting down JICPServer...");
        }
        this.state = 1;
        try {
            this.server.close();
            this.join();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int chCount = 0;
        while (this.state != 1) {
            try {
                Socket s = this.server.accept();
                ++Connection.socketCnt;
                InetAddress addr = s.getInetAddress();
                int port = s.getPort();
                if (this.myLogger.isLoggable(Logger.FINEST)) {
                    this.myLogger.log(Logger.FINEST, "Incoming connection from " + addr + ":" + port);
                }
                Connection c = this.connFactory.createConnection(s);
                ConnectionHandler ch = new ConnectionHandler(c, addr, port, chCount++);
                if (this.myLogger.isLoggable(Logger.FINEST)) {
                    this.myLogger.log(Logger.FINEST, "Create new ConnectionHandler (" + ch + ")");
                }
                this.connectionHandlers.addElement(ch);
                ch.start();
            }
            catch (InterruptedIOException s) {
            }
            catch (Exception e) {
                if (this.state != 0) continue;
                if (this.myLogger.isLoggable(Logger.WARNING)) {
                    this.myLogger.log(Logger.WARNING, "Problems accepting a new connection");
                }
                e.printStackTrace();
                this.state = 1;
            }
        }
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "JICPServer terminated");
        }
        try {
            this.server.close();
        }
        catch (IOException io) {
            if (this.myLogger.isLoggable(Logger.WARNING)) {
                this.myLogger.log(Logger.WARNING, "I/O error closing the server socket");
            }
            io.printStackTrace();
        }
        this.server = null;
        Vector io = this.connectionHandlers;
        synchronized (io) {
            Enumeration en = this.connectionHandlers.elements();
            while (en.hasMoreElements()) {
                ConnectionHandler ch = (ConnectionHandler)en.nextElement();
                ch.close();
            }
        }
        Enumeration e = this.mediators.elements();
        while (e.hasMoreElements()) {
            JICPMediator m = (JICPMediator)e.nextElement();
            m.kill();
        }
        this.mediators.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(long currentTime) {
        Hashtable hashtable = this.mediators;
        synchronized (hashtable) {
            Enumeration e = this.mediators.elements();
            while (e.hasMoreElements()) {
                JICPMediator m = (JICPMediator)e.nextElement();
                m.tick(currentTime);
            }
        }
    }

    @Override
    public void deregisterMediator(String id) {
        this.myLogger.log(Logger.FINE, "Deregistering mediator " + id);
        this.mediators.remove(id);
    }

    @Override
    public void handlePDPContextClosed(String id) {
    }

    private void mergeProperties(Properties p1, Properties p2) {
        Enumeration<?> e = p2.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            p1.setProperty(key, p2.getProperty(key));
        }
    }

    private JICPMediator startMediator(String id, Properties p) throws Exception {
        String className = p.getProperty("mediator-class");
        if (className != null) {
            JICPMediator m = (JICPMediator)JadeClassLoader.forName(className).newInstance();
            this.mergeProperties(p, this.leapProps);
            this.myLogger.log(Logger.FINE, "Initializing mediator " + id + " with properties " + p);
            m.init(this, id, p);
            return m;
        }
        throw new ICPException("No JICPMediator class specified.");
    }

    private void waitABit(long t) {
        try {
            Thread.sleep(t);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class ConnectionHandler
    extends Thread {
        private Connection c;
        private InetAddress addr;
        private int port;
        private boolean loop = false;
        private int status = 0;
        private boolean closeConnection = true;

        public ConnectionHandler(Connection c, InetAddress addr, int port, int count) {
            this.c = c;
            this.addr = addr;
            this.port = port;
            this.setName("JICP-CH-" + count);
        }

        public void close() {
            block6: {
                if (this.status != 3) {
                    this.loop = false;
                    this.closeConnection = true;
                    if (JICPServer.this.myLogger.isLoggable(Logger.FINEST)) {
                        JICPServer.this.myLogger.log(Logger.FINEST, "Predispose to close connection handler (" + this + ")");
                    }
                } else {
                    try {
                        if (JICPServer.this.myLogger.isLoggable(Logger.FINEST)) {
                            JICPServer.this.myLogger.log(Logger.FINEST, "Close connection socket to force exit from connection handler (" + this + ")");
                        }
                        this.c.close();
                    }
                    catch (IOException e) {
                        if (!JICPServer.this.myLogger.isLoggable(Logger.FINEST)) break block6;
                        JICPServer.this.myLogger.log(Logger.FINEST, "Exception closing connection with " + this.addr + ":" + this.port);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (JICPServer.this.myLogger.isLoggable(Logger.FINEST)) {
                JICPServer.this.myLogger.log(Logger.FINEST, "CommandHandler started");
            }
            byte type = 0;
            try {
                do {
                    JICPPacket pkt = this.c.readPacket();
                    JICPPacket reply = null;
                    this.status = 1;
                    type = pkt.getType();
                    switch (type) {
                        case 0: 
                        case 1: {
                            String recipientID = pkt.getRecipientID();
                            if (JICPServer.this.myLogger.isLoggable(Logger.FINEST)) {
                                JICPServer.this.myLogger.log(Logger.FINEST, "Recipient: " + recipientID);
                            }
                            if (recipientID != null) {
                                JICPMediator m = (JICPMediator)JICPServer.this.mediators.get(recipientID);
                                if (m != null) {
                                    if (JICPServer.this.myLogger.isLoggable(Logger.FINEST)) {
                                        JICPServer.this.myLogger.log(Logger.FINEST, "Passing incoming packet to mediator " + recipientID);
                                    }
                                    reply = m.handleJICPPacket(pkt, this.addr, this.port);
                                    break;
                                }
                                if (type != 0) break;
                                reply = new JICPPacket("Unknown recipient " + recipientID, null);
                                break;
                            }
                            this.loop = true;
                            if (type == 0) {
                                if (JICPServer.this.myLogger.isLoggable(Logger.FINEST)) {
                                    JICPServer.this.myLogger.log(Logger.FINEST, "Passing incoming COMMAND to local listener");
                                }
                                byte[] rsp = JICPServer.this.cmdListener.handleCommand(pkt.getData());
                                byte dataInfo = 0;
                                if (JICPServer.this.connectionHandlers.size() >= JICPServer.this.maxHandlers) {
                                    dataInfo = (byte)(dataInfo | 0x40);
                                    this.loop = false;
                                }
                                reply = new JICPPacket(1, dataInfo, rsp);
                            }
                            if ((pkt.getInfo() & 0x40) == 0) break;
                            this.loop = false;
                            break;
                        }
                        case 21: {
                            if (JICPServer.this.myLogger.isLoggable(Logger.INFO)) {
                                JICPServer.this.myLogger.log(Logger.INFO, "Received a GET_ADDRESS request from " + this.addr + ":" + this.port);
                            }
                            String addressStr = this.addr.getHostAddress();
                            if (pkt.getData() != null) {
                                addressStr = addressStr + ":" + this.port;
                            }
                            reply = new JICPPacket(1, 0, addressStr.getBytes());
                            break;
                        }
                        case 22: {
                            if (JICPServer.this.acceptMediators) {
                                JICPMediator m;
                                JICPMediator old;
                                String s;
                                Properties p;
                                String pn;
                                if (JICPServer.this.myLogger.isLoggable(Logger.INFO)) {
                                    JICPServer.this.myLogger.log(Logger.INFO, "Received a CREATE_MEDIATOR request from " + this.addr + ":" + this.port);
                                }
                                if ((pn = (p = FrontEndStub.parseCreateMediatorRequest(s = new String(pkt.getData()))).getProperty("platform-id")) != null) {
                                    JICPServer.this.myLogger.log(Logger.WARNING, "CREATE_MEDIATOR request with specified platform-name: " + pn);
                                    reply = new JICPPacket("Not-authorized", new JADESecurityException("Platform-name specified"));
                                    break;
                                }
                                if (JICPServer.this.myPDPContextManager != null) {
                                    try {
                                        Properties pdpContextInfo = JICPServer.this.myPDPContextManager.getPDPContextInfo(this.addr, p.getProperty("owner"));
                                        JICPServer.this.myLogger.log(Logger.FINE, "PDPContext properties = " + pdpContextInfo);
                                        JICPServer.this.mergeProperties(p, pdpContextInfo);
                                    }
                                    catch (JADESecurityException jse) {
                                        if (JICPServer.this.myLogger.isLoggable(Logger.WARNING)) {
                                            JICPServer.this.myLogger.log(Logger.WARNING, "CREATE_MEDIATOR request from non authorized address: " + this.addr);
                                        }
                                        reply = new JICPPacket("Not-authorized", jse);
                                        break;
                                    }
                                }
                                String id = p.getProperty("mediator-id");
                                String msisdn = p.getProperty("msisdn");
                                if (id != null) {
                                    if (msisdn != null && !msisdn.equals(id)) {
                                        if (JICPServer.this.myLogger.isLoggable(Logger.WARNING)) {
                                            JICPServer.this.myLogger.log(Logger.WARNING, "CREATE_MEDIATOR request with mediator-id != MSISDN. Address is: " + this.addr);
                                        }
                                        reply = new JICPPacket("Not-authorized", new JADESecurityException("Inconsistent mediator-id and msisdn"));
                                        break;
                                    }
                                    p.setProperty("jade_core_BackEndContainer_resynch", "true");
                                } else {
                                    id = msisdn;
                                    if (id == null) {
                                        id = "BE-" + JICPServer.this.getLocalHost() + ':' + JICPServer.this.getLocalPort() + '-' + String.valueOf(JICPServer.this.mediatorCnt++);
                                    }
                                }
                                if (id.equals(msisdn) && (old = (JICPMediator)JICPServer.this.mediators.get(id)) != null) {
                                    JICPServer.this.myLogger.log(Logger.INFO, "Replacing old mediator " + id);
                                    old.kill();
                                    JICPServer.this.waitABit(1000L);
                                }
                                this.closeConnection = !(m = JICPServer.this.startMediator(id, p)).handleIncomingConnection(this.c, pkt, this.addr, this.port);
                                JICPServer.this.mediators.put(m.getID(), m);
                                p.setProperty("mediator-id", m.getID());
                                p.setProperty("local-host", this.addr.getHostAddress());
                                String replyMsg = FrontEndStub.encodeCreateMediatorResponse(p);
                                reply = new JICPPacket(1, 0, replyMsg.getBytes());
                                reply.setSessionID((byte)31);
                                break;
                            }
                            JICPServer.this.myLogger.log(Logger.WARNING, "CREATE_MEDIATOR request received with accept-mediator option set to false. Address is: " + this.addr);
                            reply = new JICPPacket("Not-authorized", null);
                            break;
                        }
                        case 23: {
                            String recipientID;
                            if (JICPServer.this.acceptMediators) {
                                JICPMediator m;
                                recipientID = pkt.getRecipientID();
                                if (JICPServer.this.myLogger.isLoggable(Logger.INFO)) {
                                    JICPServer.this.myLogger.log(Logger.INFO, "Received a CONNECT_MEDIATOR request from " + this.addr + ":" + this.port + ". Mediator ID is " + recipientID);
                                }
                                if ((m = (JICPMediator)JICPServer.this.mediators.get(recipientID)) != null) {
                                    this.closeConnection = !m.handleIncomingConnection(this.c, pkt, this.addr, this.port);
                                    reply = new JICPPacket(1, 0, this.addr.getHostAddress().getBytes());
                                    break;
                                }
                                if (JICPServer.this.myLogger.isLoggable(Logger.INFO)) {
                                    JICPServer.this.myLogger.log(Logger.INFO, "Mediator " + recipientID + " not found");
                                }
                                reply = new JICPPacket("Not-found", null);
                                break;
                            }
                            JICPServer.this.myLogger.log(Logger.WARNING, "CONNECT_MEDIATOR request received with accept-mediator option set to false. Address is: " + this.addr);
                            reply = new JICPPacket("Not-authorized", null);
                            break;
                        }
                        default: {
                            if (JICPServer.this.myLogger.isLoggable(Logger.WARNING)) {
                                JICPServer.this.myLogger.log(Logger.WARNING, "Uncorrect JICP data type: " + pkt.getType());
                            }
                            reply = new JICPPacket("Uncorrect JICP data type: " + pkt.getType(), null);
                        }
                    }
                    this.status = 2;
                    if (reply != null) {
                        this.c.writePacket(reply);
                    }
                    this.status = 3;
                } while (this.loop);
                return;
            }
            catch (Exception e) {
                switch (this.status) {
                    case 0: {
                        if (JICPServer.this.myLogger.isLoggable(Logger.SEVERE)) {
                            JICPServer.this.myLogger.log(Logger.SEVERE, "Communication error reading incoming packet from " + this.addr + ":" + this.port);
                        }
                        e.printStackTrace();
                        return;
                    }
                    case 1: {
                        if (JICPServer.this.myLogger.isLoggable(Logger.SEVERE)) {
                            JICPServer.this.myLogger.log(Logger.SEVERE, "Error handling incoming packet");
                        }
                        e.printStackTrace();
                        if (type != 0) return;
                        if (this.c == null) return;
                        try {
                            this.c.writePacket(new JICPPacket("Unexpected error", e));
                            return;
                        }
                        catch (IOException ioe) {
                            if (!JICPServer.this.myLogger.isLoggable(Logger.WARNING)) return;
                            JICPServer.this.myLogger.log(Logger.WARNING, "Can't send back error indication " + ioe);
                            return;
                        }
                    }
                    case 2: {
                        if (!JICPServer.this.myLogger.isLoggable(Logger.SEVERE)) return;
                        JICPServer.this.myLogger.log(Logger.SEVERE, "Communication error writing return packet to " + this.addr + ":" + this.port + " [" + e.toString() + "]");
                        return;
                    }
                    case 3: {
                        if (e instanceof EOFException) {
                            if (!JICPServer.this.myLogger.isLoggable(Logger.FINE)) return;
                            JICPServer.this.myLogger.log(Logger.FINE, "Client " + this.addr + ":" + this.port + " has closed the connection.");
                            return;
                        }
                        if (!JICPServer.this.myLogger.isLoggable(Logger.FINE)) return;
                        JICPServer.this.myLogger.log(Logger.FINE, "Unexpected client " + this.addr + ":" + this.port + " termination. " + e.toString());
                        return;
                    }
                }
                return;
            }
            finally {
                try {
                    if (this.closeConnection) {
                        if (JICPServer.this.myLogger.isLoggable(Logger.FINEST)) {
                            JICPServer.this.myLogger.log(Logger.FINEST, "Closing connection with " + this.addr + ":" + this.port);
                        }
                        this.c.close();
                    }
                }
                catch (IOException io) {
                    if (JICPServer.this.myLogger.isLoggable(Logger.INFO)) {
                        JICPServer.this.myLogger.log(Logger.INFO, "I/O error while closing the connection");
                    }
                    io.printStackTrace();
                }
                JICPServer.this.connectionHandlers.remove(this);
                if (JICPServer.this.myLogger.isLoggable(Logger.FINEST)) {
                    JICPServer.this.myLogger.log(Logger.FINEST, "ConnectionHandler closed (" + this + ")");
                }
            }
        }
    }
}

