/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap;

import jade.core.Node;
import jade.core.NodeDescriptor;
import jade.core.PlatformManager;
import jade.core.Service;
import jade.core.ServiceDescriptor;
import jade.imtp.leap.Command;
import jade.imtp.leap.LEAPIMTPManager;
import jade.imtp.leap.Skeleton;
import java.util.Vector;

class PlatformManagerSkel
extends Skeleton {
    private PlatformManager impl;
    private LEAPIMTPManager manager;

    public PlatformManagerSkel(PlatformManager pm, LEAPIMTPManager mgr) {
        this.impl = pm;
        this.manager = mgr;
    }

    @Override
    public Command executeCommand(Command command) throws Throwable {
        switch (command.getCode()) {
            case 1: {
                String name = this.impl.getPlatformName();
                command.reset(1);
                command.addParam(name);
                break;
            }
            case 2: {
                NodeDescriptor desc = (NodeDescriptor)command.getParamAt(0);
                Vector services = (Vector)command.getParamAt(1);
                boolean propagated = (Boolean)command.getParamAt(2);
                String name = this.impl.addNode(desc, services, propagated);
                command.reset(1);
                command.addParam(name);
                break;
            }
            case 3: {
                NodeDescriptor desc = (NodeDescriptor)command.getParamAt(0);
                boolean propagated = (Boolean)command.getParamAt(1);
                this.impl.removeNode(desc, propagated);
                command.reset(1);
                break;
            }
            case 4: {
                ServiceDescriptor svc = (ServiceDescriptor)command.getParamAt(0);
                NodeDescriptor desc = (NodeDescriptor)command.getParamAt(1);
                boolean propagated = (Boolean)command.getParamAt(2);
                this.impl.addSlice(svc, desc, propagated);
                command.reset(1);
                break;
            }
            case 5: {
                String serviceKey = (String)command.getParamAt(0);
                String sliceKey = (String)command.getParamAt(1);
                boolean propagated = (Boolean)command.getParamAt(2);
                this.impl.removeSlice(serviceKey, sliceKey, propagated);
                command.reset(1);
                break;
            }
            case 6: {
                String pmAddr = (String)command.getParamAt(0);
                boolean propagated = (Boolean)command.getParamAt(1);
                this.impl.addReplica(pmAddr, propagated);
                command.reset(1);
                break;
            }
            case 7: {
                String address = (String)command.getParamAt(0);
                boolean propagated = (Boolean)command.getParamAt(1);
                this.impl.removeReplica(address, propagated);
                command.reset(1);
                break;
            }
            case 10: {
                Node node = (Node)command.getParamAt(0);
                Node[] children = (Node[])command.getParamAt(1);
                this.impl.adopt(node, children);
                command.reset(1);
                break;
            }
            case 11: {
                this.impl.ping();
                command.reset(1);
                break;
            }
            case 8: {
                String serviceKey = (String)command.getParamAt(0);
                String sliceKey = (String)command.getParamAt(1);
                Service.Slice slice = this.impl.findSlice(serviceKey, sliceKey);
                command.reset(1);
                command.addParam(slice);
                break;
            }
            case 9: {
                String serviceKey = (String)command.getParamAt(0);
                Vector v = this.impl.findAllSlices(serviceKey);
                command.reset(1);
                command.addParam(v);
                break;
            }
        }
        return command;
    }
}

