/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.nio;

import jade.JadeClassLoader;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.BackEndManager;
import jade.core.BaseService;
import jade.core.GenericCommand;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.ServiceHelper;
import jade.core.ServiceNotActiveException;
import jade.core.Specifier;
import jade.core.sam.AverageMeasureProviderImpl;
import jade.core.sam.CounterValueProvider;
import jade.core.sam.MeasureProvider;
import jade.core.sam.SAMHelper;
import jade.imtp.leap.FrontEndStub;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.ConnectionFactory;
import jade.imtp.leap.JICP.JICPMediatorManager;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.JICP.PDPContextManager;
import jade.imtp.leap.JICP.ProtocolManager;
import jade.imtp.leap.TransportProtocol;
import jade.imtp.leap.nio.BEManagementHelper;
import jade.imtp.leap.nio.NIOBEDispatcher;
import jade.imtp.leap.nio.NIOHTTPPeer;
import jade.imtp.leap.nio.NIOHTTPSPeer;
import jade.imtp.leap.nio.NIOJICPConnection;
import jade.imtp.leap.nio.NIOJICPConnectionWrapper;
import jade.imtp.leap.nio.NIOJICPPeer;
import jade.imtp.leap.nio.NIOJICPSPeer;
import jade.imtp.leap.nio.NIOMediator;
import jade.imtp.leap.nio.PacketIncompleteException;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.ThreadDumpManager;
import jade.util.leap.Properties;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class BEManagementService
extends BaseService {
    public static final String NAME = "BEManagement";
    private static final String PREFIX = "jade_imtp_leap_nio_BEManagementService_";
    public static final String ACCEPT = "jade_imtp_leap_nio_BEManagementService_accept";
    public static final String SERVERS = "jade_imtp_leap_nio_BEManagementService_servers";
    public static final String ADDITIONAL_SERVICES = "additional-services";
    private static final int DEFAULT_PORT = 2099;
    private static final int DEFAULT_POOL_SIZE = 5;
    private static final int INIT_STATE = 0;
    private static final int ACTIVE_STATE = 1;
    private static final int TERMINATING_STATE = 2;
    private static final int TERMINATED_STATE = 3;
    private static final int ERROR_STATE = -1;
    public static final String INCOMING_CONNECTION = "Incoming-Connection";
    private static int bufferIncreaseSize = 1024;
    public static final String BUFFERINCREASE = "bufferincrease";
    private static final String[] OWNED_COMMANDS = new String[]{"Incoming-Connection"};
    private static final Map<String, Class> protocolManagers = new HashMap<String, Class>();
    private Hashtable servers = new Hashtable(2);
    private Ticker myTicker;
    private ServiceHelper myHelper;
    private String platformName;
    private Vector maliciousAddresses = new Vector();
    private String configOptionsFileName = "feOptions.properties";
    private AgentContainer myContainer;
    private long createMediatorCounter = 0L;
    private long connectMediatorCounter = 0L;
    private long mediatorNotFoundCounter = 0L;
    private long incomingCommandCounter = 0L;
    private long keepAliveCounter = 0L;
    private long dropDownCounter = 0L;
    private long processingTimeGT1SecCounter = 0L;
    private long processingTimeGT10SecCounter = 0L;
    private long incomingPacketServingErrorCounter = 0L;
    private long incomingPacketReadingErrorCounter = 0L;
    private AverageMeasureProviderImpl dataProcessingTimeProvider = null;
    private AverageMeasureProviderImpl waitForDataTimeProvider = null;
    private Logger myLogger = Logger.getJADELogger(this.getClass().getName());

    @Override
    public String getName() {
        String className = this.getClass().getName();
        return className.substring(0, className.indexOf("Service"));
    }

    public static final int getBufferIncreaseSize() {
        return bufferIncreaseSize;
    }

    @Override
    public String[] getOwnedCommands() {
        return OWNED_COMMANDS;
    }

    @Override
    public void init(AgentContainer ac, Profile p) throws ProfileException {
        super.init(ac, p);
        this.platformName = ac.getPlatformID();
        this.myContainer = ac;
        BackEndManager.getInstance(p);
        this.handleAcceptOption(p);
    }

    private void handleAcceptOption(Profile p) throws ProfileException {
        String acceptOption = p.getParameter(ACCEPT, null);
        if (acceptOption != null) {
            jade.util.leap.List acceptedProtocols = p.getSpecifiers(ACCEPT);
            String serverIDs = p.getParameter(SERVERS, null);
            serverIDs = serverIDs != null ? (serverIDs = serverIDs + ';') : "";
            for (int i = 0; i < acceptedProtocols.size(); ++i) {
                Specifier s = (Specifier)acceptedProtocols.get(i);
                String proto = s.getClassName();
                if (proto.equalsIgnoreCase("socket") || proto.equalsIgnoreCase("ssl") || proto.equalsIgnoreCase("http") || proto.equalsIgnoreCase("https")) {
                    String semicolon = i + 1 == acceptedProtocols.size() ? "" : ";";
                    serverIDs = serverIDs + this.manageAcceptedProtocol(s, proto.toLowerCase(), p) + semicolon;
                    continue;
                }
                this.myLogger.log(Logger.WARNING, "Unsupported protocol " + proto + ". Permitted values are socket, ssl, http and https!!!!");
            }
            p.setParameter(SERVERS, serverIDs);
        }
    }

    private String manageAcceptedProtocol(Specifier s, String protocolName, Profile p) {
        String id = PREFIX + protocolName;
        p.setParameter(id + '_' + "protocol", protocolManagers.get(protocolName).getName());
        if (s.getArgs() != null && s.getArgs().length > 0) {
            p.setParameter(id + '_' + "local-port", (String)s.getArgs()[0]);
        }
        return id;
    }

    @Override
    public void boot(final Profile p) throws ServiceException {
        String defaultServerIDs = PREFIX.substring(0, PREFIX.length() - 1);
        String serverIDs = p.getParameter(SERVERS, defaultServerIDs);
        Vector v = Specifier.parseList(serverIDs, ';');
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String id = (String)e.nextElement();
            try {
                IOEventServer srv = new IOEventServer();
                srv.init(id, p);
                this.servers.put(id, srv);
            }
            catch (Throwable t) {
                this.myLogger.log(Logger.WARNING, "Error activating IOEventServer " + id + ". " + t);
                t.printStackTrace();
            }
        }
        if (this.servers.size() == 0) {
            throw new ServiceException("NO IO-Event-Server active");
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                long wait = 10000L;
                try {
                    wait = Long.parseLong(p.getParameter("jade_imtp_leap_nio_BEManagementService_serversstartwait", null));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Thread.sleep(wait);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Iterator it = BEManagementService.this.servers.entrySet().iterator();
                while (it.hasNext()) {
                    String id = null;
                    try {
                        Map.Entry entry = it.next();
                        id = (String)entry.getKey();
                        ((IOEventServer)entry.getValue()).activate();
                    }
                    catch (Throwable t) {
                        BEManagementService.this.myLogger.log(Logger.WARNING, "Error activating IOEventServer " + id + ". " + t);
                        t.printStackTrace();
                    }
                }
            }
        };
        t.start();
        long tickTime = 60000L;
        try {
            tickTime = Long.parseLong(p.getParameter("jade_imtp_leap_nio_BEManagementService_ticktime", null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bufferIncreaseSize = Integer.parseInt(p.getParameter("jade_imtp_leap_nio_BEManagementService_bufferincrease", null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.myTicker = new Ticker(tickTime);
        this.myTicker.start();
        this.initializeSAM();
    }

    private void initializeSAM() {
        try {
            Service sam = this.myContainer.getServiceFinder().findService("jade.core.sam.SAM");
            if (sam != null) {
                SAMHelper samHelper = (SAMHelper)sam.getHelper(null);
                this.dataProcessingTimeProvider = new AverageMeasureProviderImpl();
                samHelper.addEntityMeasureProvider("Avg_Data_Processing_Time", this.dataProcessingTimeProvider);
                this.waitForDataTimeProvider = new AverageMeasureProviderImpl();
                samHelper.addEntityMeasureProvider("Avg_Wait_For_Data_Time", this.waitForDataTimeProvider);
                samHelper.addCounterValueProvider("Processing_Time_GT1Sec_Count", new CounterValueProvider(){

                    @Override
                    public long getValue() {
                        return BEManagementService.this.processingTimeGT1SecCounter;
                    }

                    @Override
                    public boolean isDifferential() {
                        return false;
                    }
                });
                samHelper.addCounterValueProvider("Processing_Time_GT10Sec_Count", new CounterValueProvider(){

                    @Override
                    public long getValue() {
                        return BEManagementService.this.processingTimeGT10SecCounter;
                    }

                    @Override
                    public boolean isDifferential() {
                        return false;
                    }
                });
                samHelper.addEntityMeasureProvider("BackEnd_Number", new MeasureProvider(){

                    @Override
                    public Number getValue() {
                        int cnt = 0;
                        Iterator it = BEManagementService.this.servers.values().iterator();
                        while (it.hasNext()) {
                            cnt += ((IOEventServer)it.next()).mediators.values().size();
                        }
                        return cnt;
                    }
                });
                samHelper.addEntityMeasureProvider("Socket_Number", new MeasureProvider(){

                    @Override
                    public Number getValue() {
                        int cnt = 0;
                        Iterator it = BEManagementService.this.servers.values().iterator();
                        while (it.hasNext()) {
                            cnt += ((IOEventServer)it.next()).getSocketCnt();
                        }
                        return cnt;
                    }
                });
                samHelper.addCounterValueProvider("Create_Mediator_Count", new CounterValueProvider(){

                    @Override
                    public long getValue() {
                        return BEManagementService.this.createMediatorCounter;
                    }

                    @Override
                    public boolean isDifferential() {
                        return false;
                    }
                });
                samHelper.addCounterValueProvider("Connect_Mediator_Count", new CounterValueProvider(){

                    @Override
                    public long getValue() {
                        return BEManagementService.this.connectMediatorCounter;
                    }

                    @Override
                    public boolean isDifferential() {
                        return false;
                    }
                });
                samHelper.addCounterValueProvider("Mediator_Not_Found_Count", new CounterValueProvider(){

                    @Override
                    public long getValue() {
                        return BEManagementService.this.mediatorNotFoundCounter;
                    }

                    @Override
                    public boolean isDifferential() {
                        return false;
                    }
                });
                samHelper.addCounterValueProvider("Incoming_Command_Count", new CounterValueProvider(){

                    @Override
                    public long getValue() {
                        return BEManagementService.this.incomingCommandCounter;
                    }

                    @Override
                    public boolean isDifferential() {
                        return false;
                    }
                });
                samHelper.addCounterValueProvider("Keep_Alive_Count", new CounterValueProvider(){

                    @Override
                    public long getValue() {
                        return BEManagementService.this.keepAliveCounter;
                    }

                    @Override
                    public boolean isDifferential() {
                        return false;
                    }
                });
                samHelper.addCounterValueProvider("Drop_Down_Count", new CounterValueProvider(){

                    @Override
                    public long getValue() {
                        return BEManagementService.this.dropDownCounter;
                    }

                    @Override
                    public boolean isDifferential() {
                        return false;
                    }
                });
                samHelper.addCounterValueProvider("Incoming_Packet_Reading_Error_Count", new CounterValueProvider(){

                    @Override
                    public long getValue() {
                        return BEManagementService.this.incomingPacketReadingErrorCounter;
                    }

                    @Override
                    public boolean isDifferential() {
                        return false;
                    }
                });
                samHelper.addCounterValueProvider("Incoming_Packet_Serving_Error_Count", new CounterValueProvider(){

                    @Override
                    public long getValue() {
                        return BEManagementService.this.incomingPacketServingErrorCounter;
                    }

                    @Override
                    public boolean isDifferential() {
                        return false;
                    }
                });
            }
        }
        catch (ServiceNotActiveException sam) {
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Error accessing the local SAMService.", e);
        }
    }

    @Override
    public void shutdown() {
        this.myLogger.log(Logger.CONFIG, "BEManagementService initiating shutdown procedure...");
        if (this.myTicker != null) {
            this.myTicker.shutdown();
        }
        Object[] ss = this.servers.values().toArray();
        for (int i = 0; i < ss.length; ++i) {
            ((IOEventServer)ss[i]).shutdown();
        }
    }

    @Override
    public ServiceHelper getHelper(Agent a) {
        if (this.myHelper == null) {
            this.myHelper = new BEManagementHelperImpl();
        }
        return this.myHelper;
    }

    private String encodeConfigOptionsResponse() throws Exception {
        Properties pp = new Properties();
        pp.load(this.configOptionsFileName);
        return FrontEndStub.encodeProperties(pp);
    }

    private void mergeProperties(Properties p1, Properties p2) {
        Enumeration<?> e = p2.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            p1.setProperty(key, p2.getProperty(key));
        }
    }

    private void waitABit(long t) {
        try {
            Thread.sleep(t);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private final void checkAddress(SocketChannel sc) throws JADESecurityException {
        Socket s = sc.socket();
        InetAddress address = s.getInetAddress();
        if (this.maliciousAddresses.contains(address)) {
            try {
                sc.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new JADESecurityException(address.toString());
        }
    }

    static {
        protocolManagers.put("socket", NIOJICPPeer.class);
        protocolManagers.put("ssl", NIOJICPSPeer.class);
        protocolManagers.put("http", NIOHTTPPeer.class);
        protocolManagers.put("https", NIOHTTPSPeer.class);
    }

    private class BEManagementHelperImpl
    implements BEManagementHelper {
        private BEManagementHelperImpl() {
        }

        @Override
        public void init(Agent a) {
        }

        @Override
        public String getProperty(String containerName, String key) {
            Properties pp;
            String value = null;
            NIOMediator mediator = this.findMediatorGlobally(containerName);
            if (mediator != null && (pp = mediator.getProperties()) != null) {
                value = pp.getProperty(key);
            }
            return value;
        }

        private NIOMediator findMediatorGlobally(String id) {
            Object[] ss = BEManagementService.this.servers.values().toArray();
            for (int i = 0; i < ss.length; ++i) {
                NIOMediator m = ((IOEventServer)ss[i]).getFromID(id);
                if (m == null) continue;
                return m;
            }
            return null;
        }
    }

    private class Ticker
    extends Thread {
        private long period;
        private boolean active = false;

        private Ticker(long period) {
            this.period = period;
        }

        @Override
        public void start() {
            this.active = true;
            this.setName("BEManagementService-ticker-master");
            super.start();
        }

        @Override
        public void run() {
            while (this.active) {
                try {
                    Thread.sleep(this.period);
                    final long currentTime = System.currentTimeMillis();
                    if (BEManagementService.this.myLogger.isLoggable(Logger.FINE)) {
                        BEManagementService.this.myLogger.log(Logger.FINE, "Ticker: Tick begin. Current time = " + currentTime);
                    }
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            Object[] ss = BEManagementService.this.servers.values().toArray();
                            for (int i = 0; i < ss.length; ++i) {
                                ((IOEventServer)ss[i]).tick(currentTime);
                            }
                            if (BEManagementService.this.myLogger.isLoggable(Logger.FINE)) {
                                BEManagementService.this.myLogger.log(Logger.FINE, "Ticker: Tick end. Current time = " + currentTime);
                            }
                        }
                    };
                    t.setName("BEManagementService-ticker-" + currentTime);
                    t.setDaemon(true);
                    t.start();
                }
                catch (Throwable t) {
                    if (!this.active) continue;
                    BEManagementService.this.myLogger.log(Logger.WARNING, "BEManagementService-Ticker: Unexpected exception ", t);
                }
            }
        }

        public void shutdown() {
            this.active = false;
            this.interrupt();
        }
    }

    private class LoopManager
    implements Runnable {
        private int myIndex;
        private String displayId;
        private int state = 0;
        private int replaceCnt;
        private Selector mySelector;
        private Thread myThread;
        private IOEventServer myServer;
        private boolean pendingChannelPresent = false;
        private List pendingChannels = new ArrayList();
        private long readStartTime = -1L;
        private boolean stuck = false;

        public LoopManager(IOEventServer server, int index) {
            this.myServer = server;
            this.myIndex = index;
            String id = this.myServer.getID();
            this.displayId = "BEManagementService" + (BEManagementService.PREFIX.startsWith(id) ? "" : "-" + id);
            this.replaceCnt = 0;
            try {
                this.mySelector = Selector.open();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        private LoopManager(LoopManager lm) {
            this.myServer = lm.myServer;
            this.myIndex = lm.myIndex;
            this.displayId = lm.displayId;
            this.pendingChannelPresent = lm.pendingChannelPresent;
            this.pendingChannels = lm.pendingChannels;
            this.replaceCnt = lm.replaceCnt + 1;
            try {
                this.mySelector = Selector.open();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        public void start() {
            this.state = 1;
            this.myThread = new Thread(this);
            this.myThread.setName(this.displayId + "-LM" + this.myIndex + "-R" + this.replaceCnt);
            this.myThread.start();
        }

        public void stop() {
            this.state = 2;
            this.mySelector.wakeup();
        }

        public void join() throws InterruptedException {
            this.myThread.join(5000L);
            if (this.myThread.isAlive()) {
                BEManagementService.this.myLogger.log(Logger.WARNING, "Thread " + this.myThread.getName() + " did not terminate when requested to do so");
            }
        }

        @Override
        public void run() {
            BEManagementService.this.myLogger.log(Logger.INFO, "LoopManager Thread " + Thread.currentThread().getName() + " started");
            String prefix = this.myServer.getLogPrefix() + "LM-" + this.myIndex + ": ";
            this.handlePendingChannels(prefix);
            int selectBugCounter = 0;
            while (this.state == 1) {
                int n;
                block22: {
                    n = 0;
                    try {
                        long startSelect = System.currentTimeMillis();
                        n = this.mySelector.select();
                        if (BEManagementService.this.waitForDataTimeProvider != null) {
                            BEManagementService.this.waitForDataTimeProvider.addSample(System.currentTimeMillis() - startSelect);
                        }
                    }
                    catch (NullPointerException npe) {
                        BEManagementService.this.myLogger.log(Logger.WARNING, this.myServer.getLogPrefix() + "NullPointerException in select. Ignore and retry.");
                        continue;
                    }
                    catch (Exception e) {
                        if (this.state != 1) break block22;
                        BEManagementService.this.myLogger.log(Logger.SEVERE, this.myServer.getLogPrefix() + "Error selecting next IO event. ", e);
                        this.state = -1;
                    }
                }
                if (this.state != 1) continue;
                Set<SelectionKey> keys = this.mySelector.selectedKeys();
                int keysSize = keys.size();
                if (BEManagementService.this.myLogger.isLoggable(Logger.FINE)) {
                    BEManagementService.this.myLogger.log(Logger.FINE, prefix + " n=" + n + " selected-keys=" + keysSize + (n != keysSize ? " This is very strange!!!!" : ""));
                }
                if (n > 0 && keysSize > 0) {
                    selectBugCounter = 0;
                    Iterator<SelectionKey> it = keys.iterator();
                    while (it.hasNext()) {
                        SelectionKey key = it.next();
                        if (key.isValid()) {
                            if ((key.readyOps() & 0x10) != 0) {
                                if (BEManagementService.this.myLogger.isLoggable(Logger.FINER)) {
                                    BEManagementService.this.myLogger.log(Logger.FINER, prefix + "------------------ ACCEPT_OP on key " + key);
                                }
                                this.handleAcceptOp(key, prefix);
                            } else if ((key.readyOps() & 1) != 0) {
                                try {
                                    if (BEManagementService.this.myLogger.isLoggable(Logger.FINER)) {
                                        BEManagementService.this.myLogger.log(Logger.FINER, prefix + "READ_OP on key " + key);
                                    }
                                    this.handleReadOp(key, prefix);
                                }
                                catch (ICPException ex) {
                                    BEManagementService.this.myLogger.log(Logger.SEVERE, "failed to read from socket", ex);
                                }
                            } else {
                                BEManagementService.this.myLogger.log(Logger.WARNING, prefix + "SelectedKey " + key + " has unknown OPTIONS " + key.readyOps());
                            }
                        } else {
                            BEManagementService.this.myLogger.log(Logger.WARNING, prefix + "SelectedKey " + key + " NOT VALID");
                        }
                        it.remove();
                    }
                } else if (++selectBugCounter > 100) {
                    this.handleSelectBug();
                }
                this.handlePendingChannels(prefix);
            }
            try {
                this.mySelector.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.state = 3;
            BEManagementService.this.myLogger.log(Logger.INFO, "LoopManager Thread " + Thread.currentThread().getName() + " terminated");
        }

        private synchronized void handleSelectBug() {
            BEManagementService.this.myLogger.log(Logger.WARNING, Thread.currentThread().getName() + " SELECT BUG OCCURRED!!!! Replacing LoopManager");
            LoopManager lm = new LoopManager(this);
            this.myServer.replaceLoopManager(this.myIndex, lm);
        }

        private final void handleAcceptOp(SelectionKey key, String prefix) {
            try {
                SocketChannel sc = ((ServerSocketChannel)key.channel()).accept();
                ++Connection.socketCnt;
                BEManagementService.this.checkAddress(sc);
                sc.configureBlocking(false);
                LoopManager lm = this.myServer.getLooper();
                lm.register(sc);
                BEManagementService.this.myLogger.log(Logger.INFO, prefix + "Incoming socket " + sc + " assigned to LM-" + lm.myIndex + " (" + lm.size() + ")");
            }
            catch (JADESecurityException jse) {
                BEManagementService.this.myLogger.log(Logger.WARNING, prefix + "Connection attempt from malicious address " + jse.getMessage());
            }
            catch (NotFoundException nfe) {
                BEManagementService.this.myLogger.log(Logger.SEVERE, prefix + "NO LoopManager available to handle incoming socket!!!!");
            }
            catch (Exception e) {
                BEManagementService.this.myLogger.log(Logger.WARNING, prefix + "Error accepting incoming connection. ", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleReadOp(SelectionKey key, String prefix) throws ICPException {
            this.readStartTime = System.currentTimeMillis();
            boolean isNewConnection = false;
            try {
                KeyManager mgr = (KeyManager)key.attachment();
                if (mgr == null) {
                    NIOJICPConnection c = this.myServer.createConnection(key);
                    isNewConnection = true;
                    mgr = new KeyManager(key, new NIOJICPConnectionWrapper(c), this.myServer);
                    key.attach(mgr);
                    BEManagementService.this.myLogger.log(Logger.INFO, prefix + "Connection " + c + " created and associated to KeyManager " + mgr);
                }
                mgr.read();
            }
            finally {
                long elapsedTime = System.currentTimeMillis() - this.readStartTime;
                this.readStartTime = -1L;
                if (BEManagementService.this.dataProcessingTimeProvider != null) {
                    BEManagementService.this.dataProcessingTimeProvider.addSample(elapsedTime);
                }
                if (elapsedTime > 1000L) {
                    if (!isNewConnection || elapsedTime > 10000L) {
                        BEManagementService.this.myLogger.log(Logger.WARNING, prefix + " *** Serve time = " + elapsedTime);
                    }
                    if (elapsedTime > 10000L) {
                        BEManagementService.this.processingTimeGT10SecCounter++;
                    } else {
                        BEManagementService.this.processingTimeGT1SecCounter++;
                    }
                }
            }
        }

        private final synchronized void register(SocketChannel sc) {
            this.pendingChannels.add(sc);
            this.pendingChannelPresent = true;
            this.mySelector.wakeup();
        }

        private final synchronized void handlePendingChannels(String prefix) {
            if (this.pendingChannelPresent) {
                for (int i = 0; i < this.pendingChannels.size(); ++i) {
                    SocketChannel sc = (SocketChannel)this.pendingChannels.get(i);
                    if (BEManagementService.this.myLogger.isLoggable(Logger.FINE)) {
                        BEManagementService.this.myLogger.log(Logger.FINE, prefix + "Registering Selector " + this.mySelector + " on channel " + sc + " for READ operations");
                    }
                    try {
                        sc.register(this.mySelector, 1);
                        continue;
                    }
                    catch (Exception e) {
                        BEManagementService.this.myLogger.log(Logger.WARNING, prefix + "Error registering socket channel for asynchronous IO. ", e);
                    }
                }
                this.pendingChannels.clear();
                this.pendingChannelPresent = false;
            }
        }

        public final Selector getSelector() {
            return this.mySelector;
        }

        public final int size() {
            return this.mySelector.keys().size() + this.pendingChannels.size();
        }

        public final long getReadElapsedTime(long now) {
            if (this.readStartTime > 0L) {
                return now - this.readStartTime;
            }
            return -1L;
        }

        public final boolean isStuck() {
            return this.stuck;
        }

        public final void setStuck() {
            this.stuck = true;
        }
    }

    private class KeyManager {
        private SelectionKey key;
        private NIOJICPConnectionWrapper connection;
        private NIOMediator mediator;
        private IOEventServer server;

        public KeyManager(SelectionKey k, NIOJICPConnectionWrapper c, IOEventServer s) {
            this.key = k;
            this.connection = c;
            this.server = s;
        }

        public final NIOMediator getMediator() {
            return this.mediator;
        }

        public final void setMediator(NIOMediator m) {
            this.mediator = m;
        }

        public final NIOJICPConnectionWrapper getConnection() {
            return this.connection;
        }

        public final SelectionKey getKey() {
            return this.key;
        }

        public final void read() {
            try {
                do {
                    JICPPacket pkt = this.connection.readPacket();
                    this.server.servePacket(this, pkt);
                } while (this.connection.moreDataAvailable());
            }
            catch (PacketIncompleteException pie) {
                if (BEManagementService.this.myLogger.isLoggable(Logger.FINE)) {
                    BEManagementService.this.myLogger.log(Logger.FINE, "Incomplete JICPPacket (" + pie.getMessage() + ") from connection " + this.connection + ". Wait for more data..");
                }
            }
            catch (Exception e) {
                this.server.serveException(this, e);
            }
        }
    }

    private class IOEventServer
    implements PDPContextManager,
    PDPContextManager.Listener,
    JICPMediatorManager {
        private String myID;
        private String myLogPrefix;
        private ServerSocketChannel mySSChannel;
        private long mediatorCnt = 1L;
        private Hashtable<String, NIOMediator> mediators = new Hashtable();
        private Vector<String> deregisteredMediators = new Vector();
        private String host;
        private int port;
        private Properties leapProps = new Properties();
        private PDPContextManager myPDPContextManager;
        private TransportProtocol myProtocol;
        private ConnectionFactory myConnectionFactory;
        private LoopManager[] loopers;

        private IOEventServer() {
        }

        public void init(String id, Profile p) {
            String pdpContextManagerClass;
            this.myID = id;
            this.myLogPrefix = BEManagementService.PREFIX.startsWith(this.myID) ? "" : "Server " + this.myID + ": ";
            this.host = p.getParameter(id + '_' + "local-host", null);
            this.port = 2099;
            String strPort = p.getParameter(id + '_' + "local-port", this.myID);
            try {
                this.port = Integer.parseInt(strPort);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String protoManagerClass = p.getParameter(id + '_' + "protocol", null);
            ProtocolManager pm = null;
            try {
                pm = (ProtocolManager)JadeClassLoader.forName(protoManagerClass).newInstance();
            }
            catch (Exception e) {
                if (protoManagerClass != null) {
                    BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "Unable to load protocol-manager class " + protoManagerClass + ", fallback to default " + NIOJICPPeer.class.getName() + "!");
                }
                pm = new NIOJICPPeer();
            }
            BEManagementService.this.myLogger.log(Logger.INFO, this.myLogPrefix + "ProtocolManager class = " + pm.getClass().getName());
            this.myProtocol = pm.getProtocol();
            this.myConnectionFactory = pm.getConnectionFactory();
            String fileName = p.getParameter(id + '_' + "leap-property-file", "leap.properties");
            try {
                this.leapProps.load(fileName);
                BEManagementService.this.myLogger.log(Logger.INFO, this.myLogPrefix + "Applying properties from file " + fileName + " to all back-ends");
            }
            catch (Exception e) {
                BEManagementService.this.myLogger.log(Logger.CONFIG, this.myLogPrefix + "Can't read LEAP property file " + fileName + ". Keep default. [" + e + "]");
            }
            this.leapProps.setProperty("jade_core_BackEndContainer_usebemanager", "true");
            String additionalService = p.getParameter(id + '_' + BEManagementService.ADDITIONAL_SERVICES, null);
            if (additionalService != null) {
                this.leapProps.setProperty(BEManagementService.ADDITIONAL_SERVICES, additionalService);
            }
            if ((pdpContextManagerClass = this.leapProps.getProperty("pdp-context-manager")) != null) {
                try {
                    BEManagementService.this.myLogger.log(Logger.INFO, this.myLogPrefix + "Loading PDPContextManager of class " + pdpContextManagerClass);
                    this.myPDPContextManager = (PDPContextManager)JadeClassLoader.forName(pdpContextManagerClass).newInstance();
                    this.myPDPContextManager.init(this.leapProps);
                    this.myPDPContextManager.registerListener(this);
                }
                catch (Throwable t) {
                    BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "Cannot load PDPContext manager " + pdpContextManagerClass, t);
                    this.myPDPContextManager = null;
                }
            } else {
                this.myPDPContextManager = this;
            }
            int poolSize = 5;
            String strPoolSize = p.getParameter(id + '_' + "poolsize", null);
            try {
                poolSize = Integer.parseInt(strPoolSize);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.loopers = new LoopManager[poolSize];
            for (int i = 0; i < this.loopers.length; ++i) {
                this.loopers[i] = new LoopManager(this, i);
            }
        }

        public synchronized void activate() throws Throwable {
            BEManagementService.this.myLogger.log(Logger.CONFIG, this.myLogPrefix + "Opening server socket channel.");
            this.mySSChannel = ServerSocketChannel.open();
            this.mySSChannel.configureBlocking(false);
            BEManagementService.this.myLogger.log(Logger.CONFIG, this.myLogPrefix + "Binding server socket to." + this.host + ":" + this.port);
            ServerSocket ss = this.mySSChannel.socket();
            InetSocketAddress addr = null;
            if (this.host != null) {
                addr = new InetSocketAddress(this.host, this.port);
            } else {
                addr = new InetSocketAddress(this.port);
                this.host = Profile.getDefaultNetworkName();
            }
            ss.bind(addr);
            BEManagementService.this.myLogger.log(Logger.CONFIG, this.myLogPrefix + "Registering for asynchronous IO events.");
            this.mySSChannel.register(this.loopers[0].getSelector(), 16);
            BEManagementService.this.myLogger.log(Logger.INFO, this.myLogPrefix + "Ready to accept I/O events on address " + this.myProtocol.buildAddress(this.host, String.valueOf(this.port), null, null));
            for (int i = 0; i < this.loopers.length; ++i) {
                this.loopers[i].start();
            }
        }

        void replaceLoopManager(int index, LoopManager newLoopManager) {
            LoopManager oldLoopManager = this.loopers[index];
            HashMap<SelectableChannel, KeyManager> managers = new HashMap<SelectableChannel, KeyManager>();
            for (SelectionKey selectionKey : oldLoopManager.getSelector().keys()) {
                int interestOps = selectionKey.interestOps();
                SelectableChannel channel = selectionKey.channel();
                managers.put(channel, (KeyManager)selectionKey.attachment());
                try {
                    channel.register(newLoopManager.getSelector(), interestOps);
                    BEManagementService.this.myLogger.log(Logger.INFO, Thread.currentThread().getName() + "- New Selector " + newLoopManager.getSelector() + " successfully registered to Channel " + channel + " with interest options = " + interestOps);
                }
                catch (Exception e) {
                    BEManagementService.this.myLogger.log(Logger.SEVERE, Thread.currentThread().getName() + "- Error registering new Selector " + newLoopManager.getSelector() + " to Channel " + channel + " with interest options = " + interestOps + "[" + e + "]");
                }
            }
            for (SelectionKey newKey : newLoopManager.getSelector().keys()) {
                newKey.attach(managers.get(newKey.channel()));
            }
            this.loopers[index] = newLoopManager;
            newLoopManager.start();
            oldLoopManager.stop();
        }

        @Override
        public int getLocalPort() {
            return this.mySSChannel.socket().getLocalPort();
        }

        @Override
        public String getLocalHost() {
            return this.host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void shutdown() {
            BEManagementService.this.myLogger.log(Logger.CONFIG, this.myLogPrefix + "Shutting down...");
            try {
                if (this.mySSChannel != null) {
                    this.mySSChannel.close();
                    BEManagementService.this.myLogger.log(Logger.FINEST, this.myLogPrefix + "Server Socket Channel closed");
                }
                if (this.loopers != null) {
                    for (int i = 0; i < this.loopers.length; ++i) {
                        BEManagementService.this.myLogger.log(Logger.FINE, this.myLogPrefix + "Stopping LoopManager #" + i);
                        if (this.loopers[i].isStuck()) continue;
                        this.loopers[i].stop();
                        this.loopers[i].join();
                        BEManagementService.this.myLogger.log(Logger.FINEST, this.myLogPrefix + "LoopManager #" + i + " terminated");
                    }
                }
            }
            catch (IOException ioe) {
                BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "Error closing Server Socket Channel", ioe);
            }
            catch (InterruptedException ie) {
                BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "Interrupted while waiting for LoopManager to termnate", ie);
            }
            Hashtable<String, NIOMediator> hashtable = this.mediators;
            synchronized (hashtable) {
                for (NIOMediator m : this.mediators.values()) {
                    BEManagementService.this.myLogger.log(Logger.FINE, this.myLogPrefix + "Killing mediator " + m.getID());
                    m.kill();
                }
            }
            this.mediators.clear();
            BEManagementService.this.myLogger.log(Logger.CONFIG, this.myLogPrefix + "Shutdown complete");
        }

        final String getID() {
            return this.myID;
        }

        final String getLogPrefix() {
            return this.myLogPrefix;
        }

        final synchronized long nextMediatorCnt() {
            return this.mediatorCnt++;
        }

        final LoopManager getLooper() throws NotFoundException {
            int minSize = 999999;
            int index = -1;
            for (int i = 1; i < this.loopers.length; ++i) {
                int size;
                if (this.loopers[i].isStuck() || (size = this.loopers[i].size()) >= minSize) continue;
                minSize = size;
                index = i;
            }
            if (index < 0) {
                throw new NotFoundException("NO LoopManager selected");
            }
            return this.loopers[index];
        }

        final NIOJICPConnection createConnection(SelectionKey key) throws ICPException {
            Socket s = null;
            NIOJICPConnection conn = (NIOJICPConnection)this.myConnectionFactory.createConnection(s);
            conn.init((SocketChannel)key.channel());
            if (BEManagementService.this.myLogger.isLoggable(Logger.FINE)) {
                BEManagementService.this.myLogger.log(Logger.FINE, "create connection " + conn.getClass().getName());
            }
            return conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void servePacket(KeyManager mgr, JICPPacket pkt) {
            boolean keepLock;
            boolean closeConnection;
            JICPPacket reply;
            NIOMediator mediator;
            NIOJICPConnectionWrapper connection;
            int port;
            InetAddress address;
            block43: {
                if (pkt == null) {
                    return;
                }
                SelectionKey key = mgr.getKey();
                SocketChannel sc = (SocketChannel)key.channel();
                Socket s = sc.socket();
                address = s.getInetAddress();
                port = s.getPort();
                connection = mgr.getConnection();
                mediator = mgr.getMediator();
                reply = null;
                closeConnection = mediator == null;
                keepLock = false;
                byte type = pkt.getType();
                String recipientID = pkt.getRecipientID();
                try {
                    switch (type) {
                        case 24: {
                            connection.lock();
                            BEManagementService.this.myLogger.log(Logger.INFO, this.myLogPrefix + "GET_SERVER_TIME request received from " + address + ":" + port);
                            reply = new JICPPacket(1, 0, String.valueOf(System.currentTimeMillis()).getBytes());
                            break;
                        }
                        case 21: {
                            BEManagementService.this.myLogger.log(Logger.INFO, this.myLogPrefix + "GET_ADDRESS request received from " + address + ":" + port + ". Port-request=" + (pkt.getData() != null));
                            String addressStr = address.getHostAddress();
                            if (pkt.getData() != null) {
                                addressStr = addressStr + ":" + port;
                            }
                            reply = new JICPPacket(1, 0, addressStr.getBytes());
                            break;
                        }
                        case 20: {
                            BEManagementService.this.myLogger.log(Logger.INFO, this.myLogPrefix + "GET_CONFIGURATION_OPTIONS request received from " + address + ":" + port);
                            String replyMsg = BEManagementService.this.encodeConfigOptionsResponse();
                            reply = new JICPPacket(1, 0, replyMsg.getBytes());
                            break;
                        }
                        case 22: {
                            BEManagementService.this.createMediatorCounter++;
                            if (mediator == null) {
                                NIOMediator old;
                                BEManagementService.this.myLogger.log(Logger.INFO, this.myLogPrefix + "CREATE_MEDIATOR request received from " + address + ":" + port);
                                connection.lock();
                                Properties p = FrontEndStub.parseCreateMediatorRequest(new String(pkt.getData()));
                                String pn = p.getProperty("platform-id");
                                if (pn != null && !pn.equals(BEManagementService.this.platformName)) {
                                    BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "Security attack! CREATE_MEDIATOR request with wrong platform name: " + pn);
                                    reply = new JICPPacket("Not-authorized", new JADESecurityException("Wrong platform-name"));
                                    break;
                                }
                                p.setProperty("frontendhost", address.getHostAddress());
                                String owner = p.getProperty("owner");
                                BEManagementService.this.myLogger.log(Logger.CONFIG, this.myLogPrefix + "Owner = " + owner);
                                try {
                                    Properties pdpContextInfo = this.myPDPContextManager.getPDPContextInfo(address, owner);
                                    BEManagementService.this.mergeProperties(p, pdpContextInfo);
                                }
                                catch (JADESecurityException jse) {
                                    BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "Security error! CREATE_MEDIATOR request from non authorized client [" + address + "]. " + jse.getMessage());
                                    reply = new JICPPacket("Not-authorized", jse);
                                    break;
                                }
                                String id = p.getProperty("mediator-id");
                                String msisdn = p.getProperty("msisdn");
                                if (id != null) {
                                    if (msisdn != null && !msisdn.equals(id)) {
                                        BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "Security attack! CREATE_MEDIATOR request with mediator-id != MSISDN. Address is: " + address);
                                        reply = new JICPPacket("Not-authorized", new JADESecurityException("Inconsistent mediator-id and msisdn"));
                                        break;
                                    }
                                    p.setProperty("jade_core_BackEndContainer_resynch", "true");
                                } else {
                                    id = msisdn;
                                    if (id == null) {
                                        id = "BE-" + this.getLocalHost() + '_' + this.getLocalPort() + '-' + this.nextMediatorCnt();
                                    }
                                }
                                if (id.equals(msisdn) && (old = this.mediators.get(id)) != null) {
                                    BEManagementService.this.myLogger.log(Logger.INFO, this.myLogPrefix + "Replacing old mediator " + id);
                                    old.kill();
                                    BEManagementService.this.waitABit(1000L);
                                }
                                mediator = this.startMediator(id, p);
                                this.configureBlocking(pkt, key);
                                closeConnection = !mediator.handleIncomingConnection(connection, pkt, address, port);
                                this.mediators.put(mediator.getID(), mediator);
                                if (!closeConnection) {
                                    mgr.setMediator(mediator);
                                }
                                p.setProperty("mediator-id", mediator.getID());
                                p.setProperty("local-host", address.getHostAddress());
                                String replyMsg = FrontEndStub.encodeCreateMediatorResponse(p);
                                reply = new JICPPacket(1, 0, replyMsg.getBytes());
                                reply.setSessionID((byte)31);
                                if (!"true".equals(p.getProperty("get-server-time"))) break;
                                keepLock = true;
                                break;
                            }
                            BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "CREATE_MEDIATOR request received on a connection already linked to an existing mediator");
                            reply = new JICPPacket("Unexpected packet type", null);
                            break;
                        }
                        case 23: {
                            BEManagementService.this.connectMediatorCounter++;
                            if (mediator == null) {
                                BEManagementService.this.myLogger.log(Logger.INFO, this.myLogPrefix + "CONNECT_MEDIATOR request received from " + address + ":" + port + ". ID=" + recipientID);
                                mediator = this.getFromID(recipientID);
                                if (mediator != null && mediator.getID() != null) {
                                    this.configureBlocking(pkt, key);
                                    boolean bl = closeConnection = !mediator.handleIncomingConnection(connection, pkt, address, port);
                                    if (!closeConnection) {
                                        mgr.setMediator(mediator);
                                    }
                                    reply = new JICPPacket(1, 0, address.getHostAddress().getBytes());
                                    break;
                                }
                                BEManagementService.this.mediatorNotFoundCounter++;
                                BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "Mediator " + recipientID + " not found");
                                reply = new JICPPacket("Not-found", null);
                                break;
                            }
                            BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "CONNECT_MEDIATOR request received on a connection already linked to an existing mediator");
                            reply = new JICPPacket("Unexpected packet type", null);
                            break;
                        }
                        default: {
                            if (type == 0) {
                                BEManagementService.this.incomingCommandCounter++;
                            } else if (type == 2) {
                                BEManagementService.this.keepAliveCounter++;
                            } else if (type == 30) {
                                BEManagementService.this.dropDownCounter++;
                            }
                            if (mediator == null) {
                                mediator = this.getFromID(recipientID);
                            }
                            if (mediator != null) {
                                if (BEManagementService.this.myLogger.isLoggable(Logger.FINEST)) {
                                    BEManagementService.this.myLogger.log(Logger.FINEST, this.myLogPrefix + "Passing packet of type " + type + " to mediator " + mediator.getID());
                                }
                                reply = mediator.handleJICPPacket(connection, pkt, address, port);
                                break;
                            }
                            BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "No mediator for incoming packet of type " + type);
                            if (type != 0) break;
                            reply = new JICPPacket("Not-found", null);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    BEManagementService.this.incomingPacketServingErrorCounter++;
                    BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + this.stringify(mediator) + "Error handling incoming packet. ", e);
                    if (type != 0 && type != 22 && type != 23 && type != 21) break block43;
                    reply = new JICPPacket("Unexpected error", e);
                }
            }
            if (reply != null) {
                try {
                    connection.writePacket(reply);
                }
                catch (Exception e) {
                    BEManagementService.this.incomingPacketServingErrorCounter++;
                    BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + this.stringify(mediator) + "Communication error writing return packet to " + address + ":" + port + " [" + e + "]", e);
                    closeConnection = true;
                }
            } else {
                closeConnection = false;
            }
            try {
                if (!closeConnection) return;
                try {
                    if (BEManagementService.this.myLogger.isLoggable(Logger.FINEST)) {
                        BEManagementService.this.myLogger.log(Logger.FINEST, this.myLogPrefix + this.stringify(mediator) + "Closing connection with " + address + ":" + port);
                    }
                    connection.close();
                    return;
                }
                catch (IOException io) {
                    BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + this.stringify(mediator) + "I/O error while closing connection with " + address + ":" + port);
                    io.printStackTrace();
                    return;
                }
            }
            finally {
                if (connection.isLocked() && !keepLock) {
                    connection.unlock();
                }
            }
        }

        private String stringify(NIOMediator mediator) {
            return mediator != null ? mediator.getID() + " - " : "null";
        }

        private void configureBlocking(JICPPacket pkt, SelectionKey key) {
            if (pkt.getData().length == 1 && pkt.getData()[0] == 1) {
                try {
                    key.cancel();
                    key.channel().configureBlocking(true);
                }
                catch (Exception e) {
                    BEManagementService.this.myLogger.log(Logger.SEVERE, "error configuring blocking", e);
                }
            }
        }

        public void serveException(KeyManager mgr, Exception e) {
            NIOJICPConnectionWrapper connection = mgr.getConnection();
            if (!((NIOJICPConnection)connection).isClosed()) {
                BEManagementService.this.incomingPacketReadingErrorCounter++;
                NIOMediator mediator = mgr.getMediator();
                if (mediator != null) {
                    mediator.handleConnectionError(connection, e);
                } else {
                    SelectionKey key = mgr.getKey();
                    SocketChannel sc = (SocketChannel)key.channel();
                    Socket s = sc.socket();
                    InetAddress address = s.getInetAddress();
                    int port = s.getPort();
                    BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "Exception reading incoming packet from " + address + ":" + port + " [" + e + "]");
                }
            }
            try {
                ((NIOJICPConnection)connection).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public NIOMediator getFromID(String id) {
            if (id != null) {
                return this.mediators.get(id);
            }
            return null;
        }

        @Override
        public void deregisterMediator(String id) {
            BEManagementService.this.myLogger.log(Logger.CONFIG, this.myLogPrefix + "Deregistering mediator " + id);
            this.deregisteredMediators.add(id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tick(long currentTime) {
            int newStuckLMCnt = 0;
            for (LoopManager lm : this.loopers) {
                if (lm.isStuck() || lm.getReadElapsedTime(currentTime) <= 60000L) continue;
                Thread lmThread = lm.myThread;
                if (lmThread.isInterrupted()) {
                    lm.setStuck();
                    int runningLoopersCnt = this.countRunningLoopers();
                    BEManagementService.this.myLogger.log(Logger.WARNING, "LM-" + lm.myIndex + " did not recover after last interrupt --> Mark it as STUCK. " + runningLoopersCnt + " LoopManagers still working properly");
                    if (runningLoopersCnt >= this.loopers.length / 2) continue;
                    BEManagementService.this.myLogger.log(Logger.SEVERE, "More than 50% of LoopManagers are stuck --> Kill JVM!");
                    System.exit(300);
                    continue;
                }
                ++newStuckLMCnt;
                StackTraceElement[] stackTrace = lmThread.getStackTrace();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < stackTrace.length; ++i) {
                    sb.append("\t at " + stackTrace[i] + "\n");
                }
                BEManagementService.this.myLogger.log(Logger.WARNING, "LM-" + lm.myIndex + " appears to be stuck in handling incoming data from the network. Try to kill it! Thread stack trace is\n" + sb.toString());
                lmThread.interrupt();
            }
            if (newStuckLMCnt > 0) {
                BEManagementService.this.myLogger.log(Logger.WARNING, "Full thread dump\n----------------------------------\n" + ThreadDumpManager.dumpAllThreads());
            }
            NIOMediator[] mm = null;
            NIOMediator[] nIOMediatorArray = this.mediators;
            synchronized (this.mediators) {
                mm = this.mediators.values().toArray(new NIOMediator[0]);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                for (NIOMediator m : mm) {
                    m.tick(currentTime);
                }
                String[] dms = null;
                String[] stringArray = this.deregisteredMediators;
                synchronized (this.deregisteredMediators) {
                    dms = this.deregisteredMediators.toArray(new String[0]);
                    this.deregisteredMediators.clear();
                    // ** MonitorExit[var6_7] (shouldn't be in output)
                    for (String id : dms) {
                        Hashtable<String, NIOMediator> hashtable = this.mediators;
                        synchronized (hashtable) {
                            NIOMediator m = this.mediators.remove(id);
                            if (m.getID() != null) {
                                this.mediators.put(m.getID(), m);
                            }
                        }
                    }
                    return;
                }
            }
        }

        @Override
        public Properties getPDPContextInfo(InetAddress addr, String owner) throws JADESecurityException {
            GenericCommand cmd = new GenericCommand(BEManagementService.INCOMING_CONNECTION, BEManagementService.this.getName(), null);
            cmd.addParam(this.myID);
            cmd.addParam(addr);
            cmd.addParam(owner);
            try {
                BEManagementService.this.myLogger.log(Logger.CONFIG, this.myLogPrefix + "Issuing V-Command " + BEManagementService.INCOMING_CONNECTION);
                Object ret = BEManagementService.this.submit(cmd);
                if (ret != null) {
                    if (ret instanceof Properties) {
                        BEManagementService.this.myLogger.log(Logger.FINER, this.myLogPrefix + "PDPContextProperties for address " + addr + " owner " + owner + " = " + ret);
                        return (Properties)ret;
                    }
                    if (ret instanceof JADESecurityException) {
                        BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "Address " + addr + " owner " + owner + " not authenticated.");
                        throw (JADESecurityException)ret;
                    }
                    if (ret instanceof Throwable) {
                        BEManagementService.this.myLogger.log(Logger.WARNING, this.myLogPrefix + "Error retrieving PDPContextPropert for address " + addr + " owner " + owner, (Throwable)ret);
                        throw new JADESecurityException(((Throwable)ret).getMessage());
                    }
                }
                return new Properties();
            }
            catch (ServiceException se) {
                se.printStackTrace();
                return null;
            }
        }

        @Override
        public void init(Properties pp) {
        }

        @Override
        public void registerListener(PDPContextManager.Listener l) {
        }

        @Override
        public void handlePDPContextClosed(String id) {
        }

        protected NIOMediator startMediator(String id, Properties p) throws Exception {
            String className = p.getProperty("mediator-class");
            if (className == null) {
                className = NIOBEDispatcher.class.getName();
            }
            NIOMediator m = (NIOMediator)JadeClassLoader.forName(className).newInstance();
            BEManagementService.this.mergeProperties(p, this.leapProps);
            BEManagementService.this.myLogger.log(Logger.INFO, this.myLogPrefix + "Initializing mediator " + id + " with properties " + p);
            m.init(this, id, p);
            return m;
        }

        private int countRunningLoopers() {
            int cnt = 0;
            for (LoopManager lm : this.loopers) {
                if (lm.isStuck()) continue;
                ++cnt;
            }
            return cnt;
        }

        public int getSocketCnt() {
            int cnt = 0;
            for (int i = 1; i < this.loopers.length; ++i) {
                cnt += this.loopers[i].size();
            }
            return cnt;
        }
    }
}

