/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.SimpleBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.states.MsgReceiver;
import jade.proto.states.ReplySender;
import java.util.Date;

abstract class Responder
extends FSMBehaviour {
    public final String RECEIVED_KEY = "__Received_key" + this.hashCode();
    public final String REPLY_KEY = "__Reply_key" + this.hashCode();
    protected static final String RECEIVE_INITIATION = "Receive-Initiation";
    protected static final String RECEIVE_NEXT = "Receive-Next";
    protected static final String HANDLE_OUT_OF_SEQUENCE = "Handle-Out-of-seq";
    protected static final String CHECK_IN_SEQ = "Check-In-seq";
    protected static final String SEND_REPLY = "Send-Reply";

    public Responder(Agent a, MessageTemplate mt) {
        this(a, mt, new DataStore());
    }

    public Responder(Agent a, MessageTemplate mt, DataStore store) {
        super(a);
        this.setDataStore(store);
        this.registerDefaultTransition(RECEIVE_INITIATION, CHECK_IN_SEQ);
        this.registerDefaultTransition(RECEIVE_NEXT, CHECK_IN_SEQ);
        this.registerDefaultTransition(CHECK_IN_SEQ, HANDLE_OUT_OF_SEQUENCE);
        this.registerDefaultTransition(HANDLE_OUT_OF_SEQUENCE, RECEIVE_NEXT, new String[]{HANDLE_OUT_OF_SEQUENCE});
        SimpleBehaviour b = new CfpReceiver(this.myAgent, mt, -1L, this.getDataStore(), this.RECEIVED_KEY);
        this.registerFirstState(b, RECEIVE_INITIATION);
        b = new NextReceiver(this.myAgent, null, -1L, this.getDataStore(), this.RECEIVED_KEY);
        this.registerState(b, RECEIVE_NEXT);
        b = new CheckInSeq(this.myAgent);
        this.registerDSState(b, CHECK_IN_SEQ);
        b = new HandleOutOfSeq(this.myAgent);
        this.registerDSState(b, HANDLE_OUT_OF_SEQUENCE);
        b = new SendReply(this.myAgent, this.REPLY_KEY, this.RECEIVED_KEY);
        this.registerDSState(b, SEND_REPLY);
    }

    private Responder() {
    }

    protected void handleOutOfSequence(ACLMessage msg) {
    }

    public void registerHandleOutOfSequence(Behaviour b) {
        this.registerDSState(b, HANDLE_OUT_OF_SEQUENCE);
    }

    @Override
    public void reset() {
        super.reset();
        DataStore ds = this.getDataStore();
        ds.remove(this.RECEIVED_KEY);
        ds.remove(this.REPLY_KEY);
    }

    protected abstract boolean checkInSequence(ACLMessage var1);

    protected void replySent(int exitValue) {
    }

    protected void registerDSState(Behaviour b, String name) {
        b.setDataStore(this.getDataStore());
        this.registerState(b, name);
    }

    private static class SendReply
    extends ReplySender {
        public SendReply(Agent a, String replyKey, String msgKey) {
            super(a, replyKey, msgKey);
        }

        private SendReply() {
        }

        @Override
        public int onEnd() {
            int ret = super.onEnd();
            Responder fsm = (Responder)this.getParent();
            fsm.replySent(ret);
            return ret;
        }
    }

    private static class HandleOutOfSeq
    extends OneShotBehaviour {
        private static final long serialVersionUID = 4487495895818005L;

        public HandleOutOfSeq(Agent a) {
            super(a);
        }

        private HandleOutOfSeq() {
        }

        @Override
        public void action() {
            Responder fsm = (Responder)this.getParent();
            fsm.handleOutOfSequence((ACLMessage)this.getDataStore().get(fsm.RECEIVED_KEY));
        }
    }

    private static class CheckInSeq
    extends OneShotBehaviour {
        private int ret;
        private static final long serialVersionUID = 4487495895818000L;

        public CheckInSeq(Agent a) {
            super(a);
        }

        private CheckInSeq() {
        }

        @Override
        public void action() {
            ACLMessage received;
            Responder fsm = (Responder)this.getParent();
            this.ret = fsm.checkInSequence(received = (ACLMessage)this.getDataStore().get(fsm.RECEIVED_KEY)) ? received.getPerformative() : -1;
        }

        @Override
        public int onEnd() {
            return this.ret;
        }
    }

    private static class NextReceiver
    extends MsgReceiver {
        public NextReceiver(Agent myAgent, MessageTemplate mt, long deadline, DataStore s, Object msgKey) {
            super(myAgent, mt, deadline, s, msgKey);
        }

        private NextReceiver() {
        }

        @Override
        public void onStart() {
            Date d;
            Responder fsm = (Responder)this.getParent();
            ACLMessage reply = (ACLMessage)this.getDataStore().get(fsm.REPLY_KEY);
            if (reply != null && (d = reply.getReplyByDate()) != null && d.getTime() > System.currentTimeMillis()) {
                this.setDeadline(d.getTime());
            }
        }
    }

    private static class CfpReceiver
    extends MsgReceiver {
        public CfpReceiver(Agent myAgent, MessageTemplate mt, long deadline, DataStore s, Object msgKey) {
            super(myAgent, mt, deadline, s, msgKey);
        }

        private CfpReceiver() {
        }

        @Override
        public int onEnd() {
            Responder fsm = (Responder)this.getParent();
            MsgReceiver nextRecv = (MsgReceiver)fsm.getState(Responder.RECEIVE_NEXT);
            ACLMessage received = (ACLMessage)this.getDataStore().get(fsm.RECEIVED_KEY);
            nextRecv.setTemplate(MessageTemplate.MatchConversationId(received.getConversationId()));
            return super.onEnd();
        }
    }
}

