/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.logging;

import jade.content.lang.sl.SLCodec;
import jade.core.Agent;
import jade.core.ContainerID;
import jade.domain.FIPAAgentManagement.APDescription;
import jade.domain.JADEAgentManagement.JADEManagementOntology;
import jade.domain.introspection.AMSSubscriber;
import jade.domain.introspection.AddedContainer;
import jade.domain.introspection.Event;
import jade.domain.introspection.PlatformDescription;
import jade.domain.introspection.RemovedContainer;
import jade.tools.logging.gui.LogManagerGUI;
import jade.tools.logging.ontology.LogManagementOntology;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;

public class LogManagerAgent
extends Agent {
    private LogManagerGUI myGui;
    private APDescription myPlatformProfile;
    private AMSSubscriber myAMSSubscriber;

    @Override
    protected void setup() {
        this.getContentManager().registerLanguage(new SLCodec());
        this.getContentManager().registerOntology(JADEManagementOntology.getInstance());
        this.getContentManager().registerOntology(LogManagementOntology.getInstance());
        this.myAMSSubscriber = new AMSSubscriber(){

            @Override
            protected void installHandlers(Map handlersTable) {
                handlersTable.put("meta_reset-events", new AMSSubscriber.EventHandler(){

                    @Override
                    public void handle(Event ev) {
                        LogManagerAgent.this.myGui.resetTree();
                    }
                });
                handlersTable.put("added-container", new AMSSubscriber.EventHandler(){

                    @Override
                    public void handle(Event ev) {
                        AddedContainer ac = (AddedContainer)ev;
                        ContainerID cid = ac.getContainer();
                        String name = cid.getName();
                        String address = cid.getAddress();
                        try {
                            InetAddress addr = InetAddress.getByName(address);
                            LogManagerAgent.this.myGui.addContainer(name, addr);
                        }
                        catch (UnknownHostException uhe) {
                            LogManagerAgent.this.myGui.addContainer(name, null);
                        }
                    }
                });
                handlersTable.put("removed-container", new AMSSubscriber.EventHandler(){

                    @Override
                    public void handle(Event ev) {
                        RemovedContainer rc = (RemovedContainer)ev;
                        ContainerID cid = rc.getContainer();
                        String name = cid.getName();
                        LogManagerAgent.this.myGui.removeContainer(name);
                    }
                });
                handlersTable.put("platform-description", new AMSSubscriber.EventHandler(){

                    @Override
                    public void handle(Event ev) {
                        PlatformDescription pd = (PlatformDescription)ev;
                        APDescription APdesc = pd.getPlatform();
                        LogManagerAgent.this.myPlatformProfile = APdesc;
                        LogManagerAgent.this.myGui.refreshLocalPlatformName(LogManagerAgent.this.myPlatformProfile.getName());
                    }
                });
            }
        };
        this.addBehaviour(this.myAMSSubscriber);
        this.myGui = new LogManagerGUI(this);
        this.myGui.showCorrect();
    }

    @Override
    protected void takeDown() {
        this.myGui.dispose();
        this.send(this.myAMSSubscriber.getCancel());
    }
}

