/*
 * Decompiled with CFR 0.152.
 */
package jade.wrapper.gateway;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.SequentialBehaviour;
import jade.util.Logger;
import jade.wrapper.gateway.GatewayBehaviour;
import jade.wrapper.gateway.GatewayListener;

public class GatewayAgent
extends Agent {
    private GatewayBehaviour myB = null;
    private GatewayListener listener;
    private final Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    protected void processCommand(final Object command) {
        if (command instanceof Behaviour) {
            SequentialBehaviour sb = new SequentialBehaviour(this);
            sb.addSubBehaviour((Behaviour)command);
            sb.addSubBehaviour(new OneShotBehaviour(this){

                @Override
                public void action() {
                    GatewayAgent.this.releaseCommand(command);
                }
            });
            this.addBehaviour(sb);
        } else {
            this.myLogger.log(Logger.WARNING, "Unknown command " + command);
        }
    }

    public final void releaseCommand(Object command) {
        this.myB.releaseCommand(command);
    }

    public GatewayAgent() {
        this.setEnabledO2ACommunication(true, 0);
    }

    @Override
    protected void setup() {
        Object[] args;
        this.myLogger.log(Logger.INFO, "Started GatewayAgent " + this.getLocalName());
        this.myB = new GatewayBehaviour(){

            @Override
            protected void processCommand(Object command) {
                ((GatewayAgent)this.myAgent).processCommand(command);
            }
        };
        this.addBehaviour(this.myB);
        this.setO2AManager(this.myB);
        if (this.listener == null && (args = this.getArguments()) != null) {
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof GatewayListener)) continue;
                this.listener = (GatewayListener)args[i];
                break;
            }
        }
        if (this.listener != null) {
            this.listener.handleGatewayConnected();
        }
    }

    @Override
    protected void takeDown() {
        if (this.listener != null) {
            this.listener.handleGatewayDisconnected();
        }
    }

    void setListener(GatewayListener listener) {
        this.listener = listener;
    }
}

