/* ===========================================================
 * JFreeChart : a free chart library for the Java(tm) platform
 * ===========================================================
 *
 * (C) Copyright 2000-2022, by David Gilbert and Contributors.
 *
 * Project Info:  http://www.jfree.org/jfreechart/index.html
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
 *
 * [Oracle and Java are registered trademarks of Oracle and/or its affiliates. 
 * Other names may be trademarks of their respective owners.]
 *
 * --------------------
 * ItemLabelAnchor.java
 * --------------------
 * (C) Copyright 2003-2022, by David Gilbert.
 *
 * Original Author:  David Gilbert;
 * Contributor(s):   -;
 *
 */

package org.jfree.chart.labels;

/**
 * An enumeration of the positions that a value label can take, relative to an
 * item in a {@link org.jfree.chart.plot.CategoryPlot}.
 */
public enum ItemLabelAnchor {

    /** Center anchor point. */
    CENTER,

    /** 1 o'clock anchor point. */
    INSIDE1,

    /** 2 o'clock  anchor point. */
    INSIDE2,

    /** 3 o'clock  anchor point. */
    INSIDE3,

    /** 4 o'clock  anchor point. */
    INSIDE4,

    /** 5 o'clock  anchor point. */
    INSIDE5,

    /** 6 o'clock  anchor point. */
    INSIDE6,

    /** 7 o'clock  anchor point. */
    INSIDE7,

    /** 8 o'clock  anchor point. */
    INSIDE8,

    /** 9 o'clock  anchor point. */
    INSIDE9,

    /** 10 o'clock  anchor point. */
    INSIDE10,

    /** 11 o'clock  anchor point. */
    INSIDE11,

    /** 12 o'clock  anchor point. */
    INSIDE12,

    /** 1 o'clock  anchor point. */
    OUTSIDE1,

    /** 2 o'clock  anchor point. */
    OUTSIDE2,

    /** 3 o'clock  anchor point. */
    OUTSIDE3,

    /** 4 o'clock  anchor point. */
    OUTSIDE4,

    /** 5 o'clock  anchor point. */
    OUTSIDE5,

    /** 6 o'clock  anchor point. */
    OUTSIDE6,

    /** 7 o'clock  anchor point. */
    OUTSIDE7,

    /** 8 o'clock  anchor point. */
    OUTSIDE8,

    /** 9 o'clock  anchor point. */
    OUTSIDE9,

    /** 10 o'clock  anchor point. */
    OUTSIDE10,

    /** 11 o'clock  anchor point. */
    OUTSIDE11,

    /** 12 o'clock  anchor point. */
    OUTSIDE12

}
