/*
 * Decompiled with CFR 0.152.
 */
package de.engehausen.treemap.swing;

import de.engehausen.treemap.ICancelable;
import de.engehausen.treemap.IColorProvider;
import de.engehausen.treemap.IGenericTreeMapLayout;
import de.engehausen.treemap.IGenericWeightedTreeModel;
import de.engehausen.treemap.ILabelProvider;
import de.engehausen.treemap.IRectangle;
import de.engehausen.treemap.IRectangleRenderer;
import de.engehausen.treemap.ISelectionChangeListener;
import de.engehausen.treemap.ITreeMapLayout;
import de.engehausen.treemap.ITreeModel;
import de.engehausen.treemap.IWeightedTreeModel;
import de.engehausen.treemap.impl.BuildControl;
import de.engehausen.treemap.impl.FIFO;
import de.engehausen.treemap.impl.GenericSquarifiedLayout;
import de.engehausen.treemap.impl.SquarifiedLayout;
import de.engehausen.treemap.swing.TreeMapMouseController;
import de.engehausen.treemap.swing.impl.DefaultColorProvider;
import de.engehausen.treemap.swing.impl.DefaultRectangleRenderer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

public class TreeMap<N>
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected ITreeModel<N> model;
    protected ITreeMapLayout<N> layout;
    protected ITreeModel<IRectangle<N>> rectangles;
    protected IRectangle<N> selected;
    protected N currentRoot;
    protected BufferedImage image;
    protected BuildControl buildControl;
    protected IRectangleRenderer<N, Graphics2D, Color> renderer = DefaultRectangleRenderer.defaultInstance();
    protected ILabelProvider<N> labelProvider;
    protected IColorProvider<N, Color> colorProvider;
    protected List<ISelectionChangeListener<N>> listeners;
    protected GraphicsConfiguration gc;
    protected boolean changeCursorOnRecalculate;

    public TreeMap() {
        this(true, true);
    }

    public TreeMap(boolean supportNavigation) {
        this(supportNavigation, true);
    }

    public TreeMap(boolean supportNavigation, boolean changeCursorOnRecalculate) {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentevent) {
                TreeMap.this.recalculate();
            }
        });
        if (supportNavigation) {
            new TreeMapMouseController(this);
        }
        this.changeCursorOnRecalculate = changeCursorOnRecalculate;
    }

    public void setRectangleRenderer(IRectangleRenderer<N, Graphics2D, Color> aRenderer) {
        this.renderer = aRenderer;
    }

    public IRectangleRenderer<N, Graphics2D, Color> getRectangleRenderer() {
        return this.renderer;
    }

    public void setLabelProvider(ILabelProvider<N> aProvider) {
        this.labelProvider = aProvider;
    }

    public ILabelProvider<N> getLabelProvider() {
        return this.labelProvider;
    }

    public void setColorProvider(IColorProvider<N, Color> aProvider) {
        this.colorProvider = aProvider;
    }

    public IColorProvider<N, Color> getColorProvider() {
        return this.colorProvider;
    }

    public void refresh() {
        this.image = this.rebuildImage(this.getWidth(), this.getHeight(), this.rectangles);
        this.repaint();
    }

    public void setTreeModel(IWeightedTreeModel<N> aModel) {
        if (this.layout == null) {
            this.layout = new SquarifiedLayout(2);
        }
        this.model = aModel;
        this.currentRoot = aModel.getRoot();
        this.selected = null;
        this.rectangles = null;
        this.image = null;
        this.recalculate();
    }

    public <T extends Number> void setTreeModel(IGenericWeightedTreeModel<N, T> aModel) {
        if (this.layout == null) {
            this.layout = new GenericSquarifiedLayout(2);
        }
        this.model = aModel;
        this.currentRoot = aModel.getRoot();
        this.selected = null;
        this.rectangles = null;
        this.image = null;
        this.recalculate();
    }

    public IWeightedTreeModel<N> getTreeModel() {
        if (this.model instanceof IWeightedTreeModel) {
            return (IWeightedTreeModel)this.model;
        }
        return null;
    }

    public ITreeModel<N> getCurrentTreeModel() {
        return this.model;
    }

    public void addSelectionChangeListener(ISelectionChangeListener<N> aListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ISelectionChangeListener<N>>(2);
        }
        this.listeners.add(aListener);
    }

    public void removeSelectionChangeListener(ISelectionChangeListener<N> aListener) {
        if (this.listeners != null) {
            this.listeners.remove(aListener);
        }
    }

    public void setTreeMapLayout(ITreeMapLayout<N> aLayout) {
        this.layout = aLayout;
    }

    @Override
    public void paintComponent(Graphics gr) {
        Graphics2D g = (Graphics2D)gr;
        if (this.image != null) {
            int w = this.getWidth();
            int h = this.getHeight();
            g.drawImage(this.image, 0, 0, w, h, null);
            if (this.selected != null) {
                int imgw = this.image.getWidth();
                int imgh = this.image.getHeight();
                if (imgw != w || imgh != h) {
                    AffineTransform transform = new AffineTransform();
                    transform.scale((double)w / (double)imgw, (double)h / (double)imgh);
                    g.setTransform(transform);
                }
                this.renderer.highlight((Object)g, this.rectangles, this.selected, this.colorProvider, this.labelProvider);
            }
        } else {
            this.drawBusy(g);
        }
    }

    protected void drawBusy(Graphics2D gr) {
        gr.setColor(this.getBackground());
        gr.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    protected void render(Graphics2D g, ITreeModel<IRectangle<N>> rects) {
        IRectangle root = (IRectangle)rects.getRoot();
        if (root != null) {
            if (this.colorProvider == null) {
                this.colorProvider = new DefaultColorProvider();
            }
            FIFO queue = new FIFO();
            queue.push((Object)((IRectangle)rects.getRoot()));
            while (queue.notEmpty()) {
                IRectangle node = (IRectangle)queue.pull();
                this.render(g, rects, node);
                if (!rects.hasChildren((Object)node)) continue;
                Iterator i = rects.getChildren((Object)node);
                while (i.hasNext()) {
                    queue.push((Object)((IRectangle)i.next()));
                }
            }
        }
    }

    protected void render(Graphics2D g, ITreeModel<IRectangle<N>> rects, IRectangle<N> rect) {
        this.renderer.render((Object)g, rects, rect, this.colorProvider, this.labelProvider);
    }

    protected boolean selectRectangle(int x, int y) {
        if (this.selected == null || !this.selected.contains(x, y)) {
            this.selected = this.findRectangle(x, y);
            if (this.selected != null && this.listeners != null) {
                String label = this.labelProvider != null ? this.labelProvider.getLabel(this.rectangles, this.selected) : null;
                for (int i = this.listeners.size() - 1; i >= 0; --i) {
                    this.listeners.get(i).selectionChanged(this.rectangles, this.selected, label);
                }
            }
            return true;
        }
        return false;
    }

    protected IRectangle<N> findRectangle(int x, int y) {
        IRectangle result;
        if (this.rectangles != null) {
            result = (IRectangle)this.rectangles.getRoot();
            if (result.contains(x, y)) {
                while (this.rectangles.hasChildren((Object)result)) {
                    boolean found = false;
                    Iterator i = this.rectangles.getChildren((Object)result);
                    while (i.hasNext()) {
                        IRectangle candidate = (IRectangle)i.next();
                        if (!candidate.contains(x, y)) continue;
                        result = candidate;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    break;
                }
            } else {
                result = null;
            }
        } else {
            result = null;
        }
        return result;
    }

    protected synchronized void recalculate() {
        if (this.model != null) {
            if (this.buildControl != null) {
                this.buildControl.cancel();
                this.buildControl = null;
            }
            BuildControl ctrl = new BuildControl();
            Worker worker = new Worker(this, ctrl);
            if (!GraphicsEnvironment.isHeadless() && this.changeCursorOnRecalculate) {
                this.setCursor(Cursor.getPredefinedCursor(3));
            }
            worker.execute();
            this.buildControl = ctrl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage rebuildImage(int width, int height, ITreeModel<IRectangle<N>> rects) {
        if (width * height > 0) {
            BufferedImage result;
            if (GraphicsEnvironment.isHeadless()) {
                result = new BufferedImage(width, height, 2);
            } else {
                if (this.gc == null) {
                    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice gs = ge.getDefaultScreenDevice();
                    this.gc = gs.getDefaultConfiguration();
                }
                result = this.gc.createCompatibleImage(width, height);
            }
            Graphics2D g = result.createGraphics();
            try {
                this.render(g, rects);
            }
            finally {
                g.dispose();
            }
            return result;
        }
        return null;
    }

    private static class Worker<N>
    extends SwingWorker<ITreeModel<IRectangle<N>>, Object> {
        private final BuildControl buildControl;
        private final TreeMap<N> treeMap;
        private final int width;
        private final int height;
        private BufferedImage image;

        public Worker(TreeMap<N> aMap, BuildControl aControl) {
            this.treeMap = aMap;
            this.buildControl = aControl;
            this.width = aMap.getWidth();
            this.height = aMap.getHeight();
        }

        @Override
        protected ITreeModel<IRectangle<N>> doInBackground() throws Exception {
            ITreeModel result;
            if (this.treeMap.layout instanceof IGenericTreeMapLayout) {
                result = ((IGenericTreeMapLayout)this.treeMap.layout).layout((IGenericWeightedTreeModel)this.treeMap.model, this.treeMap.currentRoot, this.width, this.height, (ICancelable)this.buildControl);
            } else if (this.treeMap.layout instanceof ITreeMapLayout) {
                result = this.treeMap.layout.layout((IWeightedTreeModel)this.treeMap.model, this.treeMap.currentRoot, this.width, this.height, (ICancelable)this.buildControl);
            } else {
                throw new IllegalStateException("cannot handle model with layout " + String.valueOf(this.treeMap.layout));
            }
            if (!this.buildControl.isCanceled()) {
                this.image = this.treeMap.rebuildImage(this.width, this.height, result);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            block9: {
                try {
                    ITreeModel newRects = (ITreeModel)this.get();
                    if (this.buildControl.isCanceled()) break block9;
                    TreeMap<N> treeMap = this.treeMap;
                    synchronized (treeMap) {
                        Point point;
                        this.treeMap.rectangles = newRects;
                        IRectangle root = (IRectangle)newRects.getRoot();
                        if (root != null) {
                            this.treeMap.currentRoot = root.getNode();
                        }
                        if (!GraphicsEnvironment.isHeadless()) {
                            this.treeMap.setCursor(Cursor.getPredefinedCursor(0));
                        }
                        this.treeMap.image = this.image;
                        this.treeMap.selected = null;
                        this.treeMap.buildControl = null;
                        if (!GraphicsEnvironment.isHeadless() && (point = this.treeMap.getMousePosition()) != null) {
                            this.treeMap.selectRectangle(point.x, point.y);
                        }
                    }
                    this.treeMap.repaint();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

