/*
 * Decompiled with CFR 0.152.
 */
package de.engehausen.treemap.swing;

import de.engehausen.treemap.swing.TreeMap;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class TreeMapMouseController<N>
implements MouseListener,
MouseMotionListener {
    protected final TreeMap<N> treemap;

    public TreeMapMouseController(TreeMap<N> aTreeMap) {
        this.treemap = aTreeMap;
        this.treemap.addMouseMotionListener(this);
        this.treemap.addMouseListener(this);
    }

    @Override
    public void mouseReleased(MouseEvent mouseevent) {
        if (this.treemap.model != null && this.treemap.currentRoot != null) {
            switch (mouseevent.getButton()) {
                case 1: {
                    Object last;
                    Object runner;
                    if (this.treemap.selected == null || (runner = this.treemap.selected.getNode()).equals(this.treemap.currentRoot)) break;
                    do {
                        last = runner;
                    } while (!this.treemap.currentRoot.equals(runner = this.treemap.model.getParent(runner)));
                    if (this.treemap.currentRoot.equals(last)) break;
                    this.treemap.currentRoot = last;
                    this.treemap.recalculate();
                    break;
                }
                case 3: {
                    Object parent = this.treemap.model.getParent(this.treemap.currentRoot);
                    if (parent == null) break;
                    this.treemap.currentRoot = parent;
                    this.treemap.recalculate();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseMoved(MouseEvent event) {
        boolean notBuilding;
        TreeMapMouseController treeMapMouseController = this;
        synchronized (treeMapMouseController) {
            notBuilding = this.treemap.buildControl == null;
        }
        if (notBuilding && this.treemap.selectRectangle(event.getX(), event.getY())) {
            this.treemap.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseevent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseevent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseevent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseevent) {
    }
}

