/*
 * Decompiled with CFR 0.152.
 */
package de.engehausen.treemap.swing.impl;

import de.engehausen.treemap.IColorProvider;
import de.engehausen.treemap.ILabelProvider;
import de.engehausen.treemap.IRectangle;
import de.engehausen.treemap.IRectangleRenderer;
import de.engehausen.treemap.ITreeModel;
import java.awt.Color;
import java.awt.Graphics2D;

public class BorderRenderer<N>
implements IRectangleRenderer<N, Graphics2D, Color> {
    protected final IRectangleRenderer<N, Graphics2D, Color> leafRenderer;

    public BorderRenderer(IRectangleRenderer<N, Graphics2D, Color> aLeafRenderer) {
        this.leafRenderer = aLeafRenderer;
    }

    public void highlight(Graphics2D graphics, ITreeModel<IRectangle<N>> model, IRectangle<N> rectangle, IColorProvider<N, Color> colorProvider, ILabelProvider<N> labelProvider) {
        if (model.hasChildren(rectangle)) {
            Color c = (Color)colorProvider.getColor(model, rectangle);
            graphics.setColor(c.brighter());
            graphics.drawRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
        } else {
            this.leafRenderer.highlight((Object)graphics, model, rectangle, colorProvider, labelProvider);
        }
    }

    public void render(Graphics2D graphics, ITreeModel<IRectangle<N>> model, IRectangle<N> rectangle, IColorProvider<N, Color> colorProvider, ILabelProvider<N> labelProvider) {
        if (model.hasChildren(rectangle)) {
            Color c = (Color)colorProvider.getColor(model, rectangle);
            graphics.setColor(c);
            graphics.fillRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
        } else {
            this.leafRenderer.render((Object)graphics, model, rectangle, colorProvider, labelProvider);
        }
    }
}

