/*
 * Decompiled with CFR 0.152.
 */
package de.engehausen.treemap.swing.impl;

import de.engehausen.treemap.IColorProvider;
import de.engehausen.treemap.ILabelProvider;
import de.engehausen.treemap.IRectangle;
import de.engehausen.treemap.IRectangleRenderer;
import de.engehausen.treemap.ITreeModel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Map;
import java.util.WeakHashMap;

public class CushionRectangleRenderer<N>
implements IRectangleRenderer<N, Graphics2D, Color> {
    private static Boolean fastRenderingSupported = Boolean.FALSE;
    protected final Map<Color, int[]> colorMappingRGB = new WeakHashMap<Color, int[]>(32, 0.9f);
    protected final Map<Color, Color> colorMappingColor = new WeakHashMap<Color, Color>(16, 0.9f);
    protected final int len;

    public CushionRectangleRenderer(int colorRangeSize) {
        this.len = colorRangeSize;
    }

    public void render(Graphics2D graphics, ITreeModel<IRectangle<N>> model, IRectangle<N> rectangle, IColorProvider<N, Color> colorProvider, ILabelProvider<N> labelProvider) {
        if (!model.hasChildren(rectangle)) {
            this.paintCushion(graphics, (Color)colorProvider.getColor(model, rectangle), rectangle);
        } else if (rectangle.equals(model.getRoot())) {
            graphics.setColor(Color.BLACK);
            graphics.fillRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void highlight(Graphics2D graphics, ITreeModel<IRectangle<N>> model, IRectangle<N> rectangle, IColorProvider<N, Color> colorProvider, ILabelProvider<N> labelProvider) {
        Composite oldComposite = graphics.getComposite();
        try {
            graphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
            int[] colors = this.getColorRange((Color)colorProvider.getColor(model, rectangle));
            graphics.setColor(new Color(colors[0]));
            graphics.fillRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
        }
        finally {
            graphics.setComposite(oldComposite);
        }
        this.highlightParents(graphics, model, rectangle, colorProvider, labelProvider);
    }

    protected void highlightParents(Graphics2D graphics, ITreeModel<IRectangle<N>> model, IRectangle<N> rectangle, IColorProvider<N, Color> colorProvider, ILabelProvider<N> labelProvider) {
    }

    protected void paintCushion(Graphics2D graphics, Color color, IRectangle<N> rectangle) {
        int h;
        int w = rectangle.getWidth();
        if (w * (h = rectangle.getHeight()) > 1) {
            graphics.drawImage((Image)this.createCushion(rectangle, this.getColorRange(color), w, h), rectangle.getX(), rectangle.getY(), null);
        } else {
            int y;
            int x = rectangle.getX();
            if ((x + (y = rectangle.getY())) % 2 == 0) {
                graphics.setColor(color);
            } else {
                graphics.setColor(this.getDarker(color));
            }
            graphics.drawLine(x, y, x, y);
        }
    }

    protected BufferedImage createCushion(IRectangle<N> r, int[] range, int w, int h) {
        BufferedImage result = new BufferedImage(w, h, 1);
        if (fastRenderingSupported == null) {
            fastRenderingSupported = result.getRaster().getDataBuffer() instanceof DataBufferInt;
        }
        if (fastRenderingSupported.booleanValue()) {
            double m = w > h ? (double)w : (double)h;
            int hw = w >> 1;
            int hh = h >> 1;
            int[] pixels = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
            for (int y = 0; y < h; ++y) {
                double dy = (hh - y) * (hh - y);
                int pos = y * w;
                for (int x = 0; x < w; ++x) {
                    int idx = (int)((double)range.length * Math.sqrt((double)((hw - x) * (hw - x)) + dy) / m);
                    pixels[pos + x] = range[idx];
                }
            }
        } else {
            this.renderSlow(result, w, h, range);
        }
        return result;
    }

    protected void renderSlow(BufferedImage image, int w, int h, int[] range) {
        double m = w > h ? (double)w : (double)h;
        int hw = w >> 1;
        int hh = h >> 1;
        for (int y = 0; y < h; ++y) {
            double dy = (hh - y) * (hh - y);
            for (int x = 0; x < w; ++x) {
                int idx = (int)((double)range.length * Math.sqrt((double)((hw - x) * (hw - x)) + dy) / m);
                image.setRGB(x, y, range[idx]);
            }
        }
    }

    protected int[] getColorRange(Color c) {
        int[] result = this.colorMappingRGB.get(c);
        if (result == null) {
            result = this.createColorRange(c);
            this.colorMappingRGB.put(c, result);
        }
        return result;
    }

    protected Color getDarker(Color in) {
        Color out = this.colorMappingColor.get(in);
        if (out == null) {
            out = in.darker();
            this.colorMappingColor.put(in, out);
        }
        return out;
    }

    protected int[] createColorRange(Color c) {
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        float sr = r / (float)this.len;
        float sg = g / (float)this.len;
        float sb = b / (float)this.len;
        int[] result = new int[this.len];
        for (int i = 0; i < this.len; ++i) {
            result[i] = this.toRGB(r, g, b);
            r -= sr;
            g -= sg;
            b -= sb;
        }
        return result;
    }

    protected int toRGB(float r, float g, float b) {
        return (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
    }
}

