/*
 * Decompiled with CFR 0.152.
 */
package de.engehausen.treemap.swing.impl;

import de.engehausen.treemap.IColorProvider;
import de.engehausen.treemap.ILabelProvider;
import de.engehausen.treemap.IRectangle;
import de.engehausen.treemap.IRectangleRenderer;
import de.engehausen.treemap.ITreeModel;
import java.awt.Color;
import java.awt.Graphics2D;

public class DefaultRectangleRenderer<N>
implements IRectangleRenderer<N, Graphics2D, Color> {
    private static final IRectangleRenderer<Object, Graphics2D, Color> DEFAULT = new DefaultRectangleRenderer<Object>();

    public static final <R> IRectangleRenderer<R, Graphics2D, Color> defaultInstance() {
        return DEFAULT;
    }

    public void render(Graphics2D graphics, ITreeModel<IRectangle<N>> model, IRectangle<N> rectangle, IColorProvider<N, Color> colorProvider, ILabelProvider<N> labelProvider) {
        graphics.setColor((Color)colorProvider.getColor(model, rectangle));
        graphics.fillRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public void highlight(Graphics2D graphics, ITreeModel<IRectangle<N>> model, IRectangle<N> rectangle, IColorProvider<N, Color> colorProvider, ILabelProvider<N> labelProvider) {
        graphics.setColor(Color.WHITE);
        graphics.drawRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }
}

