/*
 * Decompiled with CFR 0.152.
 */
package de.engehausen.treemap.swing.impl;

import de.engehausen.treemap.IColorProvider;
import de.engehausen.treemap.ILabelProvider;
import de.engehausen.treemap.IRectangle;
import de.engehausen.treemap.IRectangleRenderer;
import de.engehausen.treemap.ITreeModel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class LabelRenderer<N>
implements IRectangleRenderer<N, Graphics2D, Color> {
    protected final Font font;
    protected final boolean showRoot;

    public LabelRenderer(Font aFont) {
        this(aFont, false);
    }

    public LabelRenderer(Font aFont, boolean showsRoot) {
        this.font = aFont;
        this.showRoot = showsRoot;
    }

    public void render(Graphics2D graphics, ITreeModel<IRectangle<N>> model, IRectangle<N> rectangle, IColorProvider<N, Color> colorProvider, ILabelProvider<N> labelProvider) {
        if (!(labelProvider == null || !this.showRoot && rectangle.equals(model.getRoot()) && model.hasChildren(rectangle))) {
            this.render(graphics, labelProvider.getLabel(model, rectangle), Color.WHITE, rectangle);
        }
    }

    public void highlight(Graphics2D graphics, ITreeModel<IRectangle<N>> model, IRectangle<N> rectangle, IColorProvider<N, Color> colorProvider, ILabelProvider<N> labelProvider) {
        if (!(labelProvider == null || !this.showRoot && rectangle.equals(model.getRoot()) && model.hasChildren(rectangle))) {
            this.render(graphics, labelProvider.getLabel(model, rectangle), Color.RED, rectangle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void render(Graphics2D graphics, String text, Color color, IRectangle<N> bounds) {
        if (text != null) {
            boolean norotate;
            graphics.setColor(color);
            graphics.setFont(this.font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle2D textRect = fontMetrics.getStringBounds(text, graphics);
            int textw = (int)textRect.getWidth();
            int texth = (int)textRect.getHeight();
            double rectAR = this.aspectRatio(bounds.getWidth(), bounds.getHeight());
            double textAR = this.aspectRatio(textw, texth);
            boolean bl = norotate = Math.abs(1.0 / textAR - rectAR) >= Math.abs(textAR - rectAR);
            if (norotate) {
                int w = bounds.getWidth() - textw;
                int h = bounds.getHeight() - texth;
                if (w > 0 && h > 0) {
                    graphics.drawString(text, bounds.getX() + w / 2, bounds.getY() + h / 2 + texth);
                }
            } else if (bounds.getWidth() - texth > 0 && bounds.getHeight() - textw > 0) {
                AffineTransform orig = graphics.getTransform();
                try {
                    int w = bounds.getWidth() - textw;
                    int h = bounds.getHeight() - texth;
                    graphics.rotate(-1.5707963267948966, bounds.getX() + bounds.getWidth() / 2, bounds.getY() + bounds.getHeight() / 2);
                    graphics.drawString(text, bounds.getX() + w / 2, bounds.getY() + h / 2 + texth);
                }
                finally {
                    graphics.setTransform(orig);
                }
            }
        }
    }

    protected double aspectRatio(int w, int h) {
        return (double)w / (double)h;
    }
}

