/*
 * Decompiled with CFR 0.152.
 */
package de.engehausen.treemap.swing.impl;

import de.engehausen.treemap.IColorProvider;
import de.engehausen.treemap.ILabelProvider;
import de.engehausen.treemap.IRectangle;
import de.engehausen.treemap.IRectangleRenderer;
import de.engehausen.treemap.ITreeModel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class ScalingLabelRenderer<N>
implements IRectangleRenderer<N, Graphics2D, Color> {
    protected final Color normal;
    protected final Color highlight;
    protected final Font font;
    protected final boolean showRoot;

    public ScalingLabelRenderer(Font aFont, Color aNormalColor, Color aHighlightColor) {
        this(aFont, aNormalColor, aHighlightColor, false);
    }

    public ScalingLabelRenderer(Font aFont, Color aNormalColor, Color aHighlightColor, boolean showsRoot) {
        this.font = aFont;
        this.normal = aNormalColor;
        this.highlight = aHighlightColor;
        this.showRoot = showsRoot;
    }

    public void render(Graphics2D graphics, ITreeModel<IRectangle<N>> model, IRectangle<N> rectangle, IColorProvider<N, Color> colorProvider, ILabelProvider<N> labelProvider) {
        if (!(labelProvider == null || !this.showRoot && rectangle.equals(model.getRoot()) && model.hasChildren(rectangle))) {
            this.render(graphics, labelProvider.getLabel(model, rectangle), this.normal, rectangle);
        }
    }

    public void highlight(Graphics2D graphics, ITreeModel<IRectangle<N>> model, IRectangle<N> rectangle, IColorProvider<N, Color> colorProvider, ILabelProvider<N> labelProvider) {
        if (!(labelProvider == null || !this.showRoot && rectangle.equals(model.getRoot()) && model.hasChildren(rectangle))) {
            this.render(graphics, labelProvider.getLabel(model, rectangle), this.highlight, rectangle);
        }
    }

    protected void render(Graphics2D graphics, String text, Color color, IRectangle<N> bounds) {
        if (text != null) {
            graphics.setColor(color);
            graphics.setFont(this.font);
            this.setupGraphics(graphics);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle2D textRect = fontMetrics.getStringBounds(text, graphics);
            double w = textRect.getWidth() * 1.2;
            double h = textRect.getHeight();
            double scale = Math.min((double)bounds.getWidth() / w, (double)bounds.getHeight() / h);
            if (scale > 0.4) {
                AffineTransform at = AffineTransform.getTranslateInstance((double)bounds.getX() + ((double)bounds.getWidth() - w / (double)1.2f * scale) / 2.0, (double)bounds.getY() + (h + ((double)bounds.getHeight() - h) / 2.0));
                at.scale(scale, scale);
                graphics.setFont(this.font.deriveFont(at));
                graphics.drawString(text, 0, 0);
            }
        }
    }

    protected void setupGraphics(Graphics2D graphics) {
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }
}

