/*
 * Decompiled with CFR 0.152.
 */
package de.entwicklertraining.deepseek4j;

import de.entwicklertraining.api.base.ApiClient;
import de.entwicklertraining.api.base.ApiClientSettings;
import de.entwicklertraining.deepseek4j.chat.completion.DeepSeekCompletionRequest;
import de.entwicklertraining.deepseek4j.models.DeepSeekModelsRequest;
import de.entwicklertraining.deepseek4j.user.balance.DeepSeekUserBalanceRequest;

public final class DeepSeekClient
extends ApiClient {
    private static DeepSeekClient instance;

    public DeepSeekClient() {
        this(ApiClientSettings.builder().build(), "https://api.deepseek.com");
    }

    public DeepSeekClient(ApiClientSettings settings) {
        this(settings, "https://api.deepseek.com");
    }

    public DeepSeekClient(ApiClientSettings settings, String customBaseUrl) {
        super(settings);
        this.setBaseUrl(customBaseUrl);
        if (settings.getBearerAuthenticationKey().isEmpty() && System.getenv("DEEPSEEK_API_KEY") != null) {
            this.settings = this.settings.toBuilder().setBearerAuthenticationKey(System.getenv("DEEPSEEK_API_KEY")).build();
        }
        this.registerStatusCodeException(400, ApiClient.HTTP_400_RequestRejectedException.class, "Invalid format (HTTP 400):", false);
        this.registerStatusCodeException(401, ApiClient.HTTP_401_AuthorizationException.class, "Authentication failed (HTTP 401):", false);
        this.registerStatusCodeException(402, ApiClient.HTTP_402_PaymentRequiredException.class, "Insufficient balance (HTTP 402):", false);
        this.registerStatusCodeException(422, ApiClient.HTTP_422_UnprocessableEntityException.class, "Invalid parameters (HTTP 422):", false);
        this.registerStatusCodeException(429, ApiClient.HTTP_429_RateLimitOrQuotaException.class, "Rate limit or quota exceeded (HTTP 429):", true);
        this.registerStatusCodeException(500, ApiClient.HTTP_500_ServerErrorException.class, "Server encountered an issue (HTTP 500):", false);
        this.registerStatusCodeException(503, ApiClient.HTTP_503_ServerUnavailableException.class, "Server overloaded (HTTP 503):", true);
    }

    public DeepSeekChat chat() {
        return new DeepSeekChat(this);
    }

    public DeepSeekModelsRequest.Builder models() {
        return DeepSeekModelsRequest.builder(this);
    }

    public DeepSeekUser user() {
        return new DeepSeekUser(this);
    }

    public static class DeepSeekChat {
        private final DeepSeekClient client;

        public DeepSeekChat(DeepSeekClient client) {
            this.client = client;
        }

        public DeepSeekCompletionRequest.Builder completion() {
            return DeepSeekCompletionRequest.builder(this.client);
        }
    }

    public static class DeepSeekUser {
        private final DeepSeekClient client;

        public DeepSeekUser(DeepSeekClient client) {
            this.client = client;
        }

        public DeepSeekUserBalanceRequest.Builder balance() {
            return DeepSeekUserBalanceRequest.builder(this.client);
        }
    }
}

