/*
 * Decompiled with CFR 0.152.
 */
package de.entwicklertraining.deepseek4j;

import de.entwicklertraining.deepseek4j.DeepSeekJsonSchema;
import org.json.JSONArray;
import org.json.JSONObject;

final class DeepSeekJsonSchemaImpl
implements DeepSeekJsonSchema {
    private String type;
    private String description;
    private final JSONObject properties;
    private final JSONArray required;
    private final JSONArray enumValues;
    private DeepSeekJsonSchema itemsSchema;
    private final JSONArray anyOfSchemas;
    private boolean additionalProperties;
    private boolean anyOfMode;

    DeepSeekJsonSchemaImpl(String type) {
        this.type = type;
        this.properties = new JSONObject();
        this.required = new JSONArray();
        this.enumValues = new JSONArray();
        this.anyOfSchemas = new JSONArray();
        this.additionalProperties = false;
        this.anyOfMode = false;
    }

    @Override
    public DeepSeekJsonSchema description(String desc) {
        this.description = desc;
        return this;
    }

    @Override
    public DeepSeekJsonSchema property(String name, DeepSeekJsonSchema schema, boolean requiredField) {
        if (this.anyOfMode) {
            throw new IllegalStateException("Cannot add properties when building an anyOf schema directly.");
        }
        if (!"object".equals(this.type)) {
            throw new IllegalStateException("Can only add properties to an object schema.");
        }
        this.properties.put(name, (Object)schema.toJson());
        if (requiredField) {
            this.required.put((Object)name);
        }
        return this;
    }

    @Override
    public DeepSeekJsonSchema items(DeepSeekJsonSchema itemSchema) {
        if (this.anyOfMode) {
            throw new IllegalStateException("Cannot set items in anyOf mode.");
        }
        if (!"array".equals(this.type)) {
            throw new IllegalStateException("items can only be defined for array schemas.");
        }
        this.itemsSchema = itemSchema;
        return this;
    }

    @Override
    public DeepSeekJsonSchema enumValues(String ... values) {
        if (this.anyOfMode) {
            throw new IllegalStateException("Cannot set enum values in anyOf mode.");
        }
        if (this.type == null || !"string".equals(this.type)) {
            throw new IllegalStateException("Enum is currently only supported on string type schemas.");
        }
        for (String v : values) {
            this.enumValues.put((Object)v);
        }
        return this;
    }

    @Override
    public DeepSeekJsonSchema additionalProperties(boolean allowed) {
        this.additionalProperties = allowed;
        return this;
    }

    void setAnyOfMode(boolean anyOfMode) {
        this.anyOfMode = anyOfMode;
    }

    JSONArray getAnyOfSchemas() {
        return this.anyOfSchemas;
    }

    @Override
    public JSONObject toJson() {
        JSONObject obj = new JSONObject();
        if (this.anyOfMode) {
            obj.put("anyOf", (Object)this.anyOfSchemas);
            if (this.description != null && !this.description.isBlank()) {
                obj.put("description", (Object)this.description);
            }
            return obj;
        }
        if (this.type != null) {
            obj.put("type", (Object)this.type);
        }
        if (this.properties.length() > 0) {
            obj.put("properties", (Object)this.properties);
        }
        if (this.required.length() > 0) {
            obj.put("required", (Object)this.required);
        }
        if (this.enumValues.length() > 0) {
            obj.put("enum", (Object)this.enumValues);
        }
        if ("array".equals(this.type) && this.itemsSchema != null) {
            obj.put("items", (Object)this.itemsSchema.toJson());
        }
        obj.put("additionalProperties", this.additionalProperties);
        if (this.description != null && !this.description.isBlank()) {
            obj.put("description", (Object)this.description);
        }
        return obj;
    }
}

