/*
 * Decompiled with CFR 0.152.
 */
package de.entwicklertraining.deepseek4j;

import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;

public final class DeepSeekTokenService {
    private static final double AVG_LATIN_CHARS_PER_TOKEN = 3.3;
    private static final double AVG_CJK_CHARS_PER_TOKEN = 1.7;
    private final HuggingFaceTokenizer tokenizer = this.loadTokenizer();

    private HuggingFaceTokenizer loadTokenizer() {
        try {
            String resourcePath = this.getClass().getClassLoader().getResource("tokenizer.json").getPath();
            Path tokenizerPath = Paths.get(resourcePath, new String[0]).getParent();
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("trust_remote_code", "true");
            return HuggingFaceTokenizer.newInstance((Path)tokenizerPath, options);
        }
        catch (Exception e) {
            try {
                Path tokenizerPath = Paths.get("src/main/resources/", new String[0]);
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("trust_remote_code", "true");
                return HuggingFaceTokenizer.newInstance((Path)tokenizerPath, options);
            }
            catch (IOException fallbackEx) {
                return null;
            }
        }
    }

    public int calculateTokenCount(String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        try {
            if (this.tokenizer != null) {
                return this.tokenizer.encode(text).getIds().length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        long latin = text.codePoints().filter(cp -> Character.UnicodeScript.of(cp).equals((Object)Character.UnicodeScript.LATIN)).count();
        long cjk = (long)text.length() - latin;
        double estimate = (double)latin / 3.3 + (double)cjk / 1.7;
        return (int)Math.ceil(estimate);
    }
}

