/*
 * Decompiled with CFR 0.152.
 */
package de.entwicklertraining.deepseek4j;

import de.entwicklertraining.deepseek4j.DeepSeekJsonSchema;
import de.entwicklertraining.deepseek4j.DeepSeekToolsCallback;
import org.json.JSONArray;
import org.json.JSONObject;

public final class DeepSeekToolDefinition {
    private final String name;
    private final String description;
    private final JSONObject parameters;
    private final DeepSeekToolsCallback callback;

    private DeepSeekToolDefinition(String name, String description, JSONObject parameters, DeepSeekToolsCallback callback) {
        this.name = name;
        this.description = description;
        this.parameters = parameters;
        this.callback = callback;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public JSONObject parameters() {
        return this.parameters;
    }

    public DeepSeekToolsCallback callback() {
        return this.callback;
    }

    public JSONObject toJson() {
        JSONObject tool = new JSONObject();
        tool.put("type", (Object)"function");
        JSONObject function = new JSONObject();
        function.put("name", (Object)this.name);
        function.put("description", (Object)this.description);
        function.put("parameters", (Object)this.parameters);
        tool.put("function", (Object)function);
        return tool;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static final class Builder {
        private final String name;
        private String description;
        private final JSONObject schema = new JSONObject();
        private final JSONObject properties = new JSONObject();
        private final JSONArray required = new JSONArray();
        private DeepSeekToolsCallback callback;
        private boolean areAdditionalPropertiesAllowed = false;

        private Builder(String name) {
            this.name = name;
            this.schema.put("type", (Object)"object");
        }

        public Builder description(String desc) {
            this.description = desc;
            return this;
        }

        public Builder parameter(String paramName, DeepSeekJsonSchema paramSchema, boolean requiredField) {
            this.properties.put(paramName, (Object)paramSchema.toJson());
            if (requiredField) {
                this.required.put((Object)paramName);
            }
            return this;
        }

        public Builder callback(DeepSeekToolsCallback cb) {
            this.callback = cb;
            return this;
        }

        public Builder allowAdditionalProperties() {
            this.areAdditionalPropertiesAllowed = true;
            return this;
        }

        public DeepSeekToolDefinition build() {
            if (!this.properties.isEmpty()) {
                this.schema.put("properties", (Object)this.properties);
            }
            if (!this.required.isEmpty()) {
                this.schema.put("required", (Object)this.required);
            }
            this.schema.put("additionalProperties", this.areAdditionalPropertiesAllowed);
            return new DeepSeekToolDefinition(this.name, this.description, this.schema, this.callback);
        }
    }
}

