/*
 * Decompiled with CFR 0.152.
 */
package de.entwicklertraining.deepseek4j.chat.completion;

import de.entwicklertraining.api.base.ApiClient;
import de.entwicklertraining.deepseek4j.DeepSeekClient;
import de.entwicklertraining.deepseek4j.DeepSeekToolCallContext;
import de.entwicklertraining.deepseek4j.DeepSeekToolDefinition;
import de.entwicklertraining.deepseek4j.DeepSeekToolResult;
import de.entwicklertraining.deepseek4j.chat.completion.DeepSeekCompletionRequest;
import de.entwicklertraining.deepseek4j.chat.completion.DeepSeekCompletionResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeepSeekCompletionCallHandler {
    private final DeepSeekClient client;
    private static final int MAX_TURNS = 4;
    private static final Logger logger = LoggerFactory.getLogger(DeepSeekCompletionCallHandler.class);

    public DeepSeekCompletionCallHandler(DeepSeekClient client) {
        this.client = client;
    }

    public DeepSeekCompletionResponse handleRequest(DeepSeekCompletionRequest initialRequest, boolean useExponentialBackoff) {
        if (Boolean.TRUE.equals(initialRequest.stream())) {
            throw new UnsupportedOperationException("Streaming responses are not currently supported by this handler.");
        }
        this.validateRequestForModel(initialRequest);
        ArrayList<JSONObject> messages = new ArrayList<JSONObject>(initialRequest.messages());
        HashMap<String, DeepSeekToolDefinition> toolMap = new HashMap<String, DeepSeekToolDefinition>();
        if (initialRequest.tools() != null) {
            for (DeepSeekToolDefinition t : initialRequest.tools()) {
                toolMap.put(t.name(), t);
            }
        }
        DeepSeekCompletionRequest currentRequest = initialRequest;
        int turnCount = 0;
        while (true) {
            if (++turnCount > 4) {
                throw new ApiClient.ApiClientException("Exceeded maximum of 4 DeepSeek call iterations without final stop.");
            }
            DeepSeekCompletionResponse response = useExponentialBackoff ? (DeepSeekCompletionResponse)this.client.sendRequest(currentRequest) : (DeepSeekCompletionResponse)this.client.sendRequestWithExponentialBackoff(currentRequest);
            if (response.getJson().has("error")) {
                throw new ApiClient.ApiResponseUnusableException("DeepSeek API returned an error: " + response.getJson().toString());
            }
            JSONObject firstChoice = response.getJson().optJSONArray("choices").optJSONObject(0);
            if (firstChoice == null) {
                throw new ApiClient.ApiResponseUnusableException("DeepSeek API response missing 'choices' array or first choice object. Response: " + response.getJson().toString());
            }
            JSONObject assistantMessage = firstChoice.optJSONObject("message");
            if (assistantMessage == null) {
                throw new ApiClient.ApiResponseUnusableException("DeepSeek API response missing 'message' object in first choice. Response: " + response.getJson().toString());
            }
            String finishReason = firstChoice.optString("finish_reason", null);
            JSONObject messageToAdd = new JSONObject(assistantMessage.toString());
            if ("deepseek-reasoner".equals(currentRequest.model())) {
                messageToAdd.remove("reasoning_content");
            }
            messages.add(messageToAdd);
            JSONArray toolCallsArray = assistantMessage.optJSONArray("tool_calls");
            if (toolCallsArray == null || toolCallsArray.isEmpty()) {
                if ("tool_calls".equals(finishReason)) {
                    logger.warn("DeepSeek finish_reason is 'tool_calls' but no 'tool_calls' array found in the message. Returning current response. Response: {}", (Object)response.getJson());
                }
                return response;
            }
            if (!"tool_calls".equals(finishReason)) {
                logger.warn("DeepSeek response contains 'tool_calls' but finish_reason is '{}'. Processing tool calls anyway. Response: {}", (Object)finishReason, (Object)response.getJson());
            }
            for (int i = 0; i < toolCallsArray.length(); ++i) {
                DeepSeekToolResult toolResult;
                JSONObject args;
                JSONObject toolCallObj = toolCallsArray.optJSONObject(i);
                if (toolCallObj == null) continue;
                String toolCallId = toolCallObj.optString("id", null);
                JSONObject functionObj = toolCallObj.optJSONObject("function");
                if (toolCallId == null || functionObj == null) {
                    logger.error("Invalid tool_call entry missing 'id' or 'function': {}", (Object)toolCallObj);
                    continue;
                }
                String toolName = functionObj.optString("name", null);
                if (toolName == null || toolName.isBlank()) {
                    throw new ApiClient.ApiResponseUnusableException("Missing 'name' in tool call function object. " + String.valueOf(toolCallObj));
                }
                if (!toolMap.containsKey(toolName)) {
                    throw new ApiClient.ApiResponseUnusableException("Unknown tool call name referenced by model: " + toolName);
                }
                String argsString = functionObj.optString("arguments", null);
                if (argsString == null) {
                    args = new JSONObject();
                    logger.warn("Missing 'arguments' string for tool call '{}'. Assuming empty arguments.", (Object)toolName);
                } else {
                    try {
                        args = new JSONObject(argsString);
                    }
                    catch (Exception e) {
                        throw new ApiClient.ApiResponseUnusableException("Failed to parse arguments JSON string for tool call '" + toolName + "'. Arguments: '" + argsString + "' Error: " + e.getMessage());
                    }
                }
                DeepSeekToolDefinition toolDef = (DeepSeekToolDefinition)toolMap.get(toolName);
                try {
                    toolResult = toolDef.callback().handle(new DeepSeekToolCallContext(args));
                    if (toolResult == null || toolResult.content() == null) {
                        throw new IllegalStateException("Tool callback for '" + toolName + "' returned null result or null content.");
                    }
                }
                catch (Exception e) {
                    logger.error("Exception occurred during execution of tool '{}': {}", new Object[]{toolName, e.getMessage(), e});
                    throw new ApiClient.ApiClientException("Error executing tool '" + toolName + "': " + e.getMessage(), (Throwable)e);
                }
                messages.add(new JSONObject().put("role", (Object)"tool").put("tool_call_id", (Object)toolCallId).put("content", (Object)toolResult.content()));
            }
            currentRequest = this.buildNextRequest(initialRequest, messages);
        }
    }

    private void validateRequestForModel(DeepSeekCompletionRequest request) {
        String model = request.model();
        if (model == null || model.isBlank()) {
            throw new IllegalArgumentException("Model ID cannot be null or empty.");
        }
        if ("deepseek-reasoner".equals(model)) {
            if (request.temperature() != null) {
                logger.warn("Parameter 'temperature' is ignored by model 'deepseek-reasoner'.");
            }
            if (request.topP() != null) {
                logger.warn("Parameter 'top_p' is ignored by model 'deepseek-reasoner'.");
            }
            if (request.presencePenalty() != null) {
                logger.warn("Parameter 'presence_penalty' is ignored by model 'deepseek-reasoner'.");
            }
            if (request.frequencyPenalty() != null) {
                logger.warn("Parameter 'frequency_penalty' is ignored by model 'deepseek-reasoner'.");
            }
            if (request.tools() != null && !request.tools().isEmpty()) {
                throw new IllegalArgumentException("Parameter 'tools' (function calling) is not supported by model 'deepseek-reasoner'.");
            }
            Object toolChoice = request.toolChoice();
            if (toolChoice != null) {
                if (toolChoice instanceof String) {
                    String tcStr = (String)toolChoice;
                    if (!"auto".equals(tcStr) && !"none".equals(tcStr)) {
                        throw new IllegalArgumentException("Parameter 'tool_choice' value '" + tcStr + "' is not supported by model 'deepseek-reasoner'. Only 'auto' or 'none' are implicitly allowed.");
                    }
                } else {
                    throw new IllegalArgumentException("Parameter 'tool_choice' (specifying a function) is not supported by model 'deepseek-reasoner'.");
                }
            }
            if (request.responseFormat() != null && "json_object".equals(request.responseFormat().type())) {
                throw new IllegalArgumentException("Response format 'json_object' is not supported by model 'deepseek-reasoner'.");
            }
            if (Boolean.TRUE.equals(request.logprobs())) {
                throw new IllegalArgumentException("Parameter 'logprobs' is not supported by model 'deepseek-reasoner'.");
            }
            if (request.topLogprobs() != null) {
                throw new IllegalArgumentException("Parameter 'top_logprobs' is not supported by model 'deepseek-reasoner'.");
            }
        }
    }

    private DeepSeekCompletionRequest buildNextRequest(DeepSeekCompletionRequest initialReq, List<JSONObject> messages) {
        DeepSeekCompletionRequest.Builder builder = ((DeepSeekCompletionRequest.Builder)((DeepSeekCompletionRequest.Builder)DeepSeekCompletionRequest.builder(this.client).model(initialReq.model()).maxExecutionTimeInSeconds(initialReq.getMaxExecutionTimeInSeconds())).setCancelSupplier(initialReq.getIsCanceledSupplier())).addAllMessages(messages).addAllTools(initialReq.tools()).responseFormat(initialReq.responseFormat()).frequencyPenalty(initialReq.frequencyPenalty()).presencePenalty(initialReq.presencePenalty()).maxTokens(initialReq.maxTokens()).temperature(initialReq.temperature()).topP(initialReq.topP()).stop(initialReq.stop()).stream(initialReq.stream()).logprobs(initialReq.logprobs()).topLogprobs(initialReq.topLogprobs()).toolChoice(initialReq.toolChoice()).streamOptions(initialReq.streamOptions());
        if (initialReq.hasCaptureOnSuccess()) {
            builder.captureOnSuccess(initialReq.getCaptureOnSuccess());
        }
        if (initialReq.hasCaptureOnError()) {
            builder.captureOnError(initialReq.getCaptureOnError());
        }
        return builder.build();
    }
}

