/*
 * Decompiled with CFR 0.152.
 */
package de.entwicklertraining.deepseek4j.chat.completion;

import de.entwicklertraining.api.base.ApiRequestBuilderBase;
import de.entwicklertraining.deepseek4j.DeepSeekClient;
import de.entwicklertraining.deepseek4j.DeepSeekRequest;
import de.entwicklertraining.deepseek4j.DeepSeekResponseFormat;
import de.entwicklertraining.deepseek4j.DeepSeekToolDefinition;
import de.entwicklertraining.deepseek4j.chat.completion.DeepSeekCompletionCallHandler;
import de.entwicklertraining.deepseek4j.chat.completion.DeepSeekCompletionResponse;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public final class DeepSeekCompletionRequest
extends DeepSeekRequest<DeepSeekCompletionResponse> {
    private final String model;
    private final List<JSONObject> messages;
    private final Double frequencyPenalty;
    private final Integer maxTokens;
    private final Double presencePenalty;
    private final DeepSeekResponseFormat responseFormat;
    private final Object stop;
    private final Boolean stream;
    private final DeepSeekStreamOptions streamOptions;
    private final Double temperature;
    private final Double topP;
    private final List<DeepSeekToolDefinition> tools;
    private final Object toolChoice;
    private final Boolean logprobs;
    private final Integer topLogprobs;

    DeepSeekCompletionRequest(Builder builder, String model, List<JSONObject> messages, Double frequencyPenalty, Integer maxTokens, Double presencePenalty, DeepSeekResponseFormat responseFormat, Object stop, Boolean stream, DeepSeekStreamOptions streamOptions, Double temperature, Double topP, List<DeepSeekToolDefinition> tools, Object toolChoice, Boolean logprobs, Integer topLogprobs) {
        super(builder);
        this.model = model;
        this.messages = messages;
        this.frequencyPenalty = frequencyPenalty;
        this.maxTokens = maxTokens;
        this.presencePenalty = presencePenalty;
        this.responseFormat = responseFormat;
        this.stop = stop;
        this.stream = stream;
        this.streamOptions = streamOptions;
        this.temperature = temperature;
        this.topP = topP;
        this.tools = tools;
        this.toolChoice = toolChoice;
        this.logprobs = logprobs;
        this.topLogprobs = topLogprobs;
    }

    public String model() {
        return this.model;
    }

    public List<JSONObject> messages() {
        return this.messages;
    }

    public Double frequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Integer maxTokens() {
        return this.maxTokens;
    }

    public Double presencePenalty() {
        return this.presencePenalty;
    }

    public DeepSeekResponseFormat responseFormat() {
        return this.responseFormat;
    }

    public Object stop() {
        return this.stop;
    }

    public Boolean stream() {
        return this.stream;
    }

    public DeepSeekStreamOptions streamOptions() {
        return this.streamOptions;
    }

    public Double temperature() {
        return this.temperature;
    }

    public Double topP() {
        return this.topP;
    }

    public List<DeepSeekToolDefinition> tools() {
        return this.tools;
    }

    public Object toolChoice() {
        return this.toolChoice;
    }

    public Boolean logprobs() {
        return this.logprobs;
    }

    public Integer topLogprobs() {
        return this.topLogprobs;
    }

    public String getRelativeUrl() {
        return "/chat/completions";
    }

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    @Override
    public String getBody() {
        return this.toJson().toString();
    }

    public JSONObject toJson() {
        JSONObject streamOptsJson;
        JSONObject body = new JSONObject();
        body.put("model", (Object)this.model);
        body.put("messages", (Object)new JSONArray(this.messages));
        if (this.frequencyPenalty != null) {
            body.put("frequency_penalty", (Object)this.frequencyPenalty);
        }
        if (this.maxTokens != null) {
            body.put("max_tokens", (Object)this.maxTokens);
        }
        if (this.presencePenalty != null) {
            body.put("presence_penalty", (Object)this.presencePenalty);
        }
        if (this.responseFormat != null) {
            body.put("response_format", (Object)this.responseFormat.toJson());
        }
        if (this.stop != null) {
            body.put("stop", this.stop);
        }
        if (this.stream != null) {
            body.put("stream", (Object)this.stream);
        }
        if (this.streamOptions != null && (streamOptsJson = this.streamOptions.toJson()).length() > 0) {
            body.put("stream_options", (Object)streamOptsJson);
        }
        if (this.temperature != null) {
            body.put("temperature", (Object)this.temperature);
        }
        if (this.topP != null) {
            body.put("top_p", (Object)this.topP);
        }
        if (this.tools != null && !this.tools.isEmpty()) {
            JSONArray toolArr = new JSONArray();
            for (DeepSeekToolDefinition t : this.tools) {
                toolArr.put((Object)t.toJson());
            }
            body.put("tools", (Object)toolArr);
        }
        if (this.toolChoice != null) {
            body.put("tool_choice", this.toolChoice);
        }
        if (this.logprobs != null) {
            body.put("logprobs", (Object)this.logprobs);
        }
        if (this.topLogprobs != null) {
            body.put("top_logprobs", (Object)this.topLogprobs);
        }
        return body;
    }

    @Override
    public DeepSeekCompletionResponse createResponse(String responseBody) {
        return new DeepSeekCompletionResponse(new JSONObject(responseBody), this);
    }

    public static Builder builder(DeepSeekClient client) {
        return new Builder(client);
    }

    public static final class DeepSeekStreamOptions {
        private final Boolean includeUsage;

        public DeepSeekStreamOptions(Boolean includeUsage) {
            this.includeUsage = includeUsage;
        }

        public JSONObject toJson() {
            JSONObject obj = new JSONObject();
            if (this.includeUsage != null) {
                obj.put("include_usage", (Object)this.includeUsage);
            }
            return obj;
        }

        public Boolean includeUsage() {
            return this.includeUsage;
        }

        public static DeepSeekStreamOptions withUsage(boolean include) {
            return new DeepSeekStreamOptions(include);
        }
    }

    public static final class Builder
    extends ApiRequestBuilderBase<Builder, DeepSeekCompletionRequest> {
        private final DeepSeekClient client;
        private String model;
        private final List<JSONObject> messages = new ArrayList<JSONObject>();
        private Double frequencyPenalty;
        private Integer maxTokens;
        private Double presencePenalty;
        private DeepSeekResponseFormat responseFormat;
        private Object stop;
        private Boolean stream;
        private DeepSeekStreamOptions streamOptions;
        private Double temperature;
        private Double topP;
        private final List<DeepSeekToolDefinition> tools = new ArrayList<DeepSeekToolDefinition>();
        private Object toolChoice;
        private Boolean logprobs;
        private Integer topLogprobs;

        public Builder(DeepSeekClient client) {
            this.client = client;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder addSystemMessage(String content, String name) {
            JSONObject message = new JSONObject().put("role", (Object)"system").put("content", (Object)content);
            if (name != null && !name.isBlank()) {
                message.put("name", (Object)name);
            }
            this.messages.add(message);
            return this;
        }

        public Builder addSystemMessage(String content) {
            return this.addSystemMessage(content, null);
        }

        public Builder addUserMessage(String content, String name) {
            JSONObject message = new JSONObject().put("role", (Object)"user").put("content", (Object)content);
            if (name != null && !name.isBlank()) {
                message.put("name", (Object)name);
            }
            this.messages.add(message);
            return this;
        }

        public Builder addUserMessage(String content) {
            return this.addUserMessage(content, null);
        }

        public Builder addAssistantMessage(String content, String name) {
            JSONObject message = new JSONObject().put("role", (Object)"assistant").put("content", (Object)content);
            if (name != null && !name.isBlank()) {
                message.put("name", (Object)name);
            }
            this.messages.add(message);
            return this;
        }

        public Builder addAssistantMessage(String content) {
            return this.addAssistantMessage(content, null);
        }

        public Builder addToolMessage(String content, String toolCallId, String name) {
            JSONObject message = new JSONObject().put("role", (Object)"tool").put("content", (Object)content).put("tool_call_id", (Object)toolCallId);
            if (name != null && !name.isBlank()) {
                message.put("name", (Object)name);
            }
            this.messages.add(message);
            return this;
        }

        public Builder addToolMessage(String content, String toolCallId) {
            return this.addToolMessage(content, toolCallId, null);
        }

        public Builder addAllMessages(List<JSONObject> msgs) {
            this.messages.addAll(msgs);
            return this;
        }

        public Builder frequencyPenalty(Double freq) {
            this.frequencyPenalty = freq;
            return this;
        }

        public Builder maxTokens(Integer m) {
            this.maxTokens = m;
            return this;
        }

        public Builder presencePenalty(Double pres) {
            this.presencePenalty = pres;
            return this;
        }

        public Builder responseFormat(DeepSeekResponseFormat rf) {
            this.responseFormat = rf;
            return this;
        }

        public Builder stop(Object stopValue) {
            this.stop = stopValue;
            return this;
        }

        public Builder stream(Boolean s) {
            this.stream = s;
            return this;
        }

        public Builder streamOptions(DeepSeekStreamOptions opts) {
            this.streamOptions = opts;
            return this;
        }

        public Builder temperature(Double t) {
            this.temperature = t;
            return this;
        }

        public Builder topP(Double tp) {
            this.topP = tp;
            return this;
        }

        public Builder addTool(DeepSeekToolDefinition tool) {
            this.tools.add(tool);
            return this;
        }

        public Builder addAllTools(List<DeepSeekToolDefinition> t) {
            this.tools.addAll(t);
            return this;
        }

        public Builder toolChoice(Object tc) {
            this.toolChoice = tc;
            return this;
        }

        public Builder logprobs(Boolean log) {
            this.logprobs = log;
            return this;
        }

        public Builder topLogprobs(Integer top) {
            this.topLogprobs = top;
            return this;
        }

        public DeepSeekCompletionRequest build() {
            List<DeepSeekToolDefinition> finalTools = this.tools == null ? List.of() : List.copyOf(this.tools);
            List<JSONObject> finalMessages = this.messages == null ? List.of() : List.copyOf(this.messages);
            return new DeepSeekCompletionRequest(this, this.model, finalMessages, this.frequencyPenalty, this.maxTokens, this.presencePenalty, this.responseFormat, this.stop, this.stream, this.streamOptions, this.temperature, this.topP, finalTools, this.toolChoice, this.logprobs, this.topLogprobs);
        }

        public DeepSeekCompletionResponse executeWithExponentialBackoff() {
            return new DeepSeekCompletionCallHandler(this.client).handleRequest(this.build(), true);
        }

        public DeepSeekCompletionResponse execute() {
            return new DeepSeekCompletionCallHandler(this.client).handleRequest(this.build(), false);
        }
    }
}

