/*
 * Decompiled with CFR 0.152.
 */
package de.entwicklertraining.deepseek4j.chat.completion;

import de.entwicklertraining.deepseek4j.DeepSeekResponse;
import de.entwicklertraining.deepseek4j.chat.completion.DeepSeekCompletionRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public final class DeepSeekCompletionResponse
extends DeepSeekResponse<DeepSeekCompletionRequest> {
    public DeepSeekCompletionResponse(JSONObject json, DeepSeekCompletionRequest request) {
        super(json, request);
    }

    public String getId() {
        return this.getJson().optString("id", null);
    }

    public String getObject() {
        return this.getJson().optString("object", null);
    }

    public long getCreated() {
        return this.getJson().optLong("created", 0L);
    }

    public String getModel() {
        return this.getJson().optString("model", null);
    }

    public String getSystemFingerprint() {
        return this.getJson().optString("system_fingerprint", null);
    }

    public List<Choice> getChoices() {
        JSONArray choicesArray = this.getJson().optJSONArray("choices");
        if (choicesArray == null) {
            return Collections.emptyList();
        }
        ArrayList<Choice> choices = new ArrayList<Choice>();
        for (int i = 0; i < choicesArray.length(); ++i) {
            JSONObject choiceJson = choicesArray.optJSONObject(i);
            if (choiceJson == null) continue;
            choices.add(new Choice(choiceJson));
        }
        return choices;
    }

    public Usage getUsage() {
        JSONObject usageJson = this.getJson().optJSONObject("usage");
        return usageJson != null ? new Usage(usageJson) : null;
    }

    public String assistantMessage() {
        return this.getChoices().stream().findFirst().map(Choice::getMessage).map(Message::getContent).orElse(null);
    }

    public String finishReason() {
        return this.getChoices().stream().findFirst().map(Choice::getFinishReason).orElse(null);
    }

    public static class Choice {
        private final JSONObject json;

        Choice(JSONObject json) {
            this.json = json != null ? json : new JSONObject();
        }

        public int getIndex() {
            return this.json.optInt("index", 0);
        }

        public String getFinishReason() {
            return this.json.optString("finish_reason", null);
        }

        public Message getMessage() {
            JSONObject messageJson = this.json.optJSONObject("message");
            return messageJson != null ? new Message(messageJson) : null;
        }

        public Logprobs getLogprobs() {
            JSONObject logprobsJson = this.json.optJSONObject("logprobs");
            return logprobsJson != null ? new Logprobs(logprobsJson) : null;
        }
    }

    public static class Usage {
        private final JSONObject json;

        Usage(JSONObject json) {
            this.json = json != null ? json : new JSONObject();
        }

        public int getCompletionTokens() {
            return this.json.optInt("completion_tokens", 0);
        }

        public int getPromptTokens() {
            return this.json.optInt("prompt_tokens", 0);
        }

        public int getPromptCacheHitTokens() {
            return this.json.optInt("prompt_cache_hit_tokens", 0);
        }

        public int getPromptCacheMissTokens() {
            return this.json.optInt("prompt_cache_miss_tokens", 0);
        }

        public int getTotalTokens() {
            return this.json.optInt("total_tokens", 0);
        }

        public CompletionTokensDetails getCompletionTokensDetails() {
            JSONObject detailsJson = this.json.optJSONObject("completion_tokens_details");
            return detailsJson != null ? new CompletionTokensDetails(detailsJson) : null;
        }
    }

    public static class CompletionTokensDetails {
        private final JSONObject json;

        CompletionTokensDetails(JSONObject json) {
            this.json = json != null ? json : new JSONObject();
        }

        public int getReasoningTokens() {
            return this.json.optInt("reasoning_tokens", 0);
        }
    }

    public static class TopTokenLogprob {
        private final JSONObject json;

        TopTokenLogprob(JSONObject json) {
            this.json = json != null ? json : new JSONObject();
        }

        public String getToken() {
            return this.json.optString("token", null);
        }

        public double getLogprob() {
            return this.json.optDouble("logprob", Double.NaN);
        }

        public List<Integer> getBytes() {
            JSONArray bytesArray = this.json.optJSONArray("bytes");
            if (bytesArray == null) {
                return Collections.emptyList();
            }
            ArrayList<Integer> bytesList = new ArrayList<Integer>();
            for (int i = 0; i < bytesArray.length(); ++i) {
                bytesList.add(bytesArray.optInt(i));
            }
            return bytesList;
        }
    }

    public static class TokenLogprob {
        private final JSONObject json;

        TokenLogprob(JSONObject json) {
            this.json = json != null ? json : new JSONObject();
        }

        public String getToken() {
            return this.json.optString("token", null);
        }

        public double getLogprob() {
            return this.json.optDouble("logprob", Double.NaN);
        }

        public List<Integer> getBytes() {
            JSONArray bytesArray = this.json.optJSONArray("bytes");
            if (bytesArray == null) {
                return Collections.emptyList();
            }
            ArrayList<Integer> bytesList = new ArrayList<Integer>();
            for (int i = 0; i < bytesArray.length(); ++i) {
                bytesList.add(bytesArray.optInt(i));
            }
            return bytesList;
        }

        public List<TopTokenLogprob> getTopLogprobs() {
            JSONArray topLogprobsArray = this.json.optJSONArray("top_logprobs");
            if (topLogprobsArray == null) {
                return Collections.emptyList();
            }
            ArrayList<TopTokenLogprob> topLogprobs = new ArrayList<TopTokenLogprob>();
            for (int i = 0; i < topLogprobsArray.length(); ++i) {
                JSONObject topTokenLogprobJson = topLogprobsArray.optJSONObject(i);
                if (topTokenLogprobJson == null) continue;
                topLogprobs.add(new TopTokenLogprob(topTokenLogprobJson));
            }
            return topLogprobs;
        }
    }

    public static class Logprobs {
        private final JSONObject json;

        Logprobs(JSONObject json) {
            this.json = json != null ? json : new JSONObject();
        }

        public List<TokenLogprob> getContent() {
            JSONArray contentArray = this.json.optJSONArray("content");
            if (contentArray == null) {
                return Collections.emptyList();
            }
            ArrayList<TokenLogprob> content = new ArrayList<TokenLogprob>();
            for (int i = 0; i < contentArray.length(); ++i) {
                JSONObject tokenLogprobJson = contentArray.optJSONObject(i);
                if (tokenLogprobJson == null) continue;
                content.add(new TokenLogprob(tokenLogprobJson));
            }
            return content;
        }
    }

    public static class FunctionCall {
        private final JSONObject json;

        FunctionCall(JSONObject json) {
            this.json = json != null ? json : new JSONObject();
        }

        public String getName() {
            return this.json.optString("name", null);
        }

        public String getArguments() {
            return this.json.optString("arguments", null);
        }

        public JSONObject getArgumentsAsJson() {
            String args = this.getArguments();
            if (args == null || args.isEmpty()) {
                return new JSONObject();
            }
            try {
                return new JSONObject(args);
            }
            catch (Exception e) {
                System.err.println("Warning: Could not parse function arguments as JSON: " + args);
                return new JSONObject();
            }
        }
    }

    public static class ToolCall {
        private final JSONObject json;

        ToolCall(JSONObject json) {
            this.json = json != null ? json : new JSONObject();
        }

        public String getId() {
            return this.json.optString("id", null);
        }

        public String getType() {
            return this.json.optString("type", null);
        }

        public FunctionCall getFunction() {
            JSONObject functionJson = this.json.optJSONObject("function");
            return functionJson != null ? new FunctionCall(functionJson) : null;
        }
    }

    public static class Message {
        private final JSONObject json;

        Message(JSONObject json) {
            this.json = json != null ? json : new JSONObject();
        }

        public String getRole() {
            return this.json.optString("role", null);
        }

        public String getContent() {
            return this.json.optString("content", null);
        }

        public String getReasoningContent() {
            return this.json.optString("reasoning_content", null);
        }

        public List<ToolCall> getToolCalls() {
            JSONArray toolCallsArray = this.json.optJSONArray("tool_calls");
            if (toolCallsArray == null) {
                return Collections.emptyList();
            }
            ArrayList<ToolCall> toolCalls = new ArrayList<ToolCall>();
            for (int i = 0; i < toolCallsArray.length(); ++i) {
                JSONObject toolCallJson = toolCallsArray.optJSONObject(i);
                if (toolCallJson == null) continue;
                toolCalls.add(new ToolCall(toolCallJson));
            }
            return toolCalls;
        }
    }
}

