/*
 * Decompiled with CFR 0.152.
 */
package de.entwicklertraining.deepseek4j.user.balance;

import de.entwicklertraining.deepseek4j.DeepSeekResponse;
import de.entwicklertraining.deepseek4j.user.balance.DeepSeekUserBalanceRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public final class DeepSeekUserBalanceResponse
extends DeepSeekResponse<DeepSeekUserBalanceRequest> {
    public DeepSeekUserBalanceResponse(JSONObject json, DeepSeekUserBalanceRequest request) {
        super(json, request);
    }

    public boolean isAvailable() {
        return this.getJson().optBoolean("is_available", false);
    }

    public List<BalanceInfo> getBalanceInfos() {
        JSONArray balanceInfosArray = this.getJson().optJSONArray("balance_infos");
        if (balanceInfosArray == null) {
            return Collections.emptyList();
        }
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>();
        for (int i = 0; i < balanceInfosArray.length(); ++i) {
            JSONObject balanceInfoJson = balanceInfosArray.optJSONObject(i);
            if (balanceInfoJson == null) continue;
            balanceInfos.add(new BalanceInfo(balanceInfoJson));
        }
        return balanceInfos;
    }

    public static class BalanceInfo {
        private final JSONObject json;

        BalanceInfo(JSONObject json) {
            this.json = json != null ? json : new JSONObject();
        }

        public String getCurrency() {
            return this.json.optString("currency", null);
        }

        public String getTotalBalance() {
            return this.json.optString("total_balance", null);
        }

        public String getGrantedBalance() {
            return this.json.optString("granted_balance", null);
        }

        public String getToppedUpBalance() {
            return this.json.optString("topped_up_balance", null);
        }
    }
}

