package physx.character;

/**
 * specifies how a CCT interacts with non-walkable parts.
 * <p>
 * This is only used when slopeLimit is non zero. It is currently enabled for static actors only, and not supported for spheres or capsules.
 */
public enum PxControllerNonWalkableModeEnum {

    /**
     * Stops character from climbing up non-walkable slopes, but doesn't move it otherwise
     */
    ePREVENT_CLIMBING(getePREVENT_CLIMBING()),
    ePREVENT_CLIMBING_AND_FORCE_SLIDING(getePREVENT_CLIMBING_AND_FORCE_SLIDING());
    public final int value;
    
    PxControllerNonWalkableModeEnum(int value) {
        this.value = value;
    }

    private static native int _getePREVENT_CLIMBING();
    private static int getePREVENT_CLIMBING() {
        de.fabmax.physxjni.Loader.load();
        return _getePREVENT_CLIMBING();
    }

    private static native int _getePREVENT_CLIMBING_AND_FORCE_SLIDING();
    private static int getePREVENT_CLIMBING_AND_FORCE_SLIDING() {
        de.fabmax.physxjni.Loader.load();
        return _getePREVENT_CLIMBING_AND_FORCE_SLIDING();
    }

    public static PxControllerNonWalkableModeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxControllerNonWalkableModeEnum: " + value);
    }

}
