package physx.cooking;

import physx.NativeObject;

/**
 * Structure describing parameters affecting BVH34 midphase mesh structure.
 * @see PxMidphaseDesc
 */
public class PxBVH34MidphaseDesc extends NativeObject {

    protected PxBVH34MidphaseDesc() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxBVH34MidphaseDesc wrapPointer(long address) {
        return address != 0L ? new PxBVH34MidphaseDesc(address) : null;
    }
    
    public static PxBVH34MidphaseDesc arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxBVH34MidphaseDesc(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * Mesh cooking hint for max primitives per leaf limit. 
     * Less primitives per leaf produces larger meshes with better runtime performance 
     * and worse cooking performance. More triangles per leaf results in faster cooking speed and
     * smaller mesh sizes, but with worse runtime performance.
     * <p>
     * <b>Default value:</b> 4
     * <b>Range:</b> &lt;2, 15&gt;
     */
    public int getNumPrimsPerLeaf() {
        checkNotNull();
        return _getNumPrimsPerLeaf(address);
    }
    private static native int _getNumPrimsPerLeaf(long address);

    /**
     * Mesh cooking hint for max primitives per leaf limit. 
     * Less primitives per leaf produces larger meshes with better runtime performance 
     * and worse cooking performance. More triangles per leaf results in faster cooking speed and
     * smaller mesh sizes, but with worse runtime performance.
     * <p>
     * <b>Default value:</b> 4
     * <b>Range:</b> &lt;2, 15&gt;
     */
    public void setNumPrimsPerLeaf(int value) {
        checkNotNull();
        _setNumPrimsPerLeaf(address, value);
    }
    private static native void _setNumPrimsPerLeaf(long address, int value);

    // Functions

    /**
     * Desc initialization to default value.
     */
    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * Returns true if the descriptor is valid.
     * @return true if the current settings are valid.
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
