package physx.extensions;

import physx.common.PxVec3;

public class CustomSupport extends Support {

    protected CustomSupport() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static CustomSupport wrapPointer(long address) {
        return address != 0L ? new CustomSupport(address) : null;
    }
    
    public static CustomSupport arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected CustomSupport(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @return WebIDL type: float
     */
    public float getCustomMargin() {
        checkNotNull();
        return _getCustomMargin(address);
    }
    private static native float _getCustomMargin(long address);

    /**
     * @param dir    WebIDL type: {@link PxVec3} [Const, Ref]
     * @param result WebIDL type: {@link PxVec3} [Ref]
     */
    public void getCustomSupportLocal(PxVec3 dir, PxVec3 result) {
        checkNotNull();
        _getCustomSupportLocal(address, dir.getAddress(), result.getAddress());
    }
    private static native void _getCustomSupportLocal(long address, long dir, long result);

}
