package physx.geometry;

import physx.common.PxBase;

/**
 * Class representing a bounding volume hierarchy.
 * <p>
 * PxBVH can be provided to PxScene::addActor. In this case the scene query 
 * pruning structure inside PhysX SDK will store/update one bound per actor. 
 * The scene queries against such an actor will query actor bounds and then 
 * make a local space query against the provided BVH, which is in actor's
 * local space.
 * <p>
 * PxBVH can also be used as a standalone data-structure for arbitrary
 * purposes, unrelated to PxScene / PxActor.
 */
public class PxBVH extends PxBase {

    protected PxBVH() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxBVH wrapPointer(long address) {
        return address != 0L ? new PxBVH(address) : null;
    }
    
    public static PxBVH arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxBVH(long address) {
        super(address);
    }

}
