package physx.geometry;

import physx.NativeObject;
import physx.common.PxBoundedData;
import physx.support.PxArray_PxU32;
import physx.support.PxArray_PxVec3;
import physx.support.PxTypedStridedData_PxU16;

/**
 * Descriptor class for #PxTetrahedronMesh (contains only pure geometric data).
 * @see PxTetrahedronMesh
 * @see physx.physics.PxShape
 */
public class PxTetrahedronMeshDesc extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxTetrahedronMeshDesc wrapPointer(long address) {
        return address != 0L ? new PxTetrahedronMeshDesc(address) : null;
    }
    
    public static PxTetrahedronMeshDesc arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxTetrahedronMeshDesc(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxTetrahedronMeshDesc
     */
    public static PxTetrahedronMeshDesc createAt(long address) {
        __placement_new_PxTetrahedronMeshDesc(address);
        PxTetrahedronMeshDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxTetrahedronMeshDesc
     */
    public static <T> PxTetrahedronMeshDesc createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxTetrahedronMeshDesc(address);
        PxTetrahedronMeshDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxTetrahedronMeshDesc(long address);

    /**
     * @param address        Pre-allocated memory, where the object is created.
     * @param meshVertices   WebIDL type: {@link PxArray_PxVec3} [Ref]
     * @param meshTetIndices WebIDL type: {@link PxArray_PxU32} [Ref]
     * @return Stack allocated object of PxTetrahedronMeshDesc
     */
    public static PxTetrahedronMeshDesc createAt(long address, PxArray_PxVec3 meshVertices, PxArray_PxU32 meshTetIndices) {
        __placement_new_PxTetrahedronMeshDesc(address, meshVertices.getAddress(), meshTetIndices.getAddress());
        PxTetrahedronMeshDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>            Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator      Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate       Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param meshVertices   WebIDL type: {@link PxArray_PxVec3} [Ref]
     * @param meshTetIndices WebIDL type: {@link PxArray_PxU32} [Ref]
     * @return Stack allocated object of PxTetrahedronMeshDesc
     */
    public static <T> PxTetrahedronMeshDesc createAt(T allocator, Allocator<T> allocate, PxArray_PxVec3 meshVertices, PxArray_PxU32 meshTetIndices) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxTetrahedronMeshDesc(address, meshVertices.getAddress(), meshTetIndices.getAddress());
        PxTetrahedronMeshDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxTetrahedronMeshDesc(long address, long meshVertices, long meshTetIndices);

    /**
     * @param address        Pre-allocated memory, where the object is created.
     * @param meshVertices   WebIDL type: {@link PxArray_PxVec3} [Ref]
     * @param meshTetIndices WebIDL type: {@link PxArray_PxU32} [Ref]
     * @param meshFormat     WebIDL type: {@link PxTetrahedronMeshFormatEnum} [enum]
     * @return Stack allocated object of PxTetrahedronMeshDesc
     */
    public static PxTetrahedronMeshDesc createAt(long address, PxArray_PxVec3 meshVertices, PxArray_PxU32 meshTetIndices, PxTetrahedronMeshFormatEnum meshFormat) {
        __placement_new_PxTetrahedronMeshDesc(address, meshVertices.getAddress(), meshTetIndices.getAddress(), meshFormat.value);
        PxTetrahedronMeshDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>            Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator      Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate       Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param meshVertices   WebIDL type: {@link PxArray_PxVec3} [Ref]
     * @param meshTetIndices WebIDL type: {@link PxArray_PxU32} [Ref]
     * @param meshFormat     WebIDL type: {@link PxTetrahedronMeshFormatEnum} [enum]
     * @return Stack allocated object of PxTetrahedronMeshDesc
     */
    public static <T> PxTetrahedronMeshDesc createAt(T allocator, Allocator<T> allocate, PxArray_PxVec3 meshVertices, PxArray_PxU32 meshTetIndices, PxTetrahedronMeshFormatEnum meshFormat) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxTetrahedronMeshDesc(address, meshVertices.getAddress(), meshTetIndices.getAddress(), meshFormat.value);
        PxTetrahedronMeshDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxTetrahedronMeshDesc(long address, long meshVertices, long meshTetIndices, int meshFormat);

    /**
     * @param address                   Pre-allocated memory, where the object is created.
     * @param meshVertices              WebIDL type: {@link PxArray_PxVec3} [Ref]
     * @param meshTetIndices            WebIDL type: {@link PxArray_PxU32} [Ref]
     * @param meshFormat                WebIDL type: {@link PxTetrahedronMeshFormatEnum} [enum]
     * @param numberOfTetsPerHexElement WebIDL type: unsigned short
     * @return Stack allocated object of PxTetrahedronMeshDesc
     */
    public static PxTetrahedronMeshDesc createAt(long address, PxArray_PxVec3 meshVertices, PxArray_PxU32 meshTetIndices, PxTetrahedronMeshFormatEnum meshFormat, short numberOfTetsPerHexElement) {
        __placement_new_PxTetrahedronMeshDesc(address, meshVertices.getAddress(), meshTetIndices.getAddress(), meshFormat.value, numberOfTetsPerHexElement);
        PxTetrahedronMeshDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>                       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator                 Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate                  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param meshVertices              WebIDL type: {@link PxArray_PxVec3} [Ref]
     * @param meshTetIndices            WebIDL type: {@link PxArray_PxU32} [Ref]
     * @param meshFormat                WebIDL type: {@link PxTetrahedronMeshFormatEnum} [enum]
     * @param numberOfTetsPerHexElement WebIDL type: unsigned short
     * @return Stack allocated object of PxTetrahedronMeshDesc
     */
    public static <T> PxTetrahedronMeshDesc createAt(T allocator, Allocator<T> allocate, PxArray_PxVec3 meshVertices, PxArray_PxU32 meshTetIndices, PxTetrahedronMeshFormatEnum meshFormat, short numberOfTetsPerHexElement) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxTetrahedronMeshDesc(address, meshVertices.getAddress(), meshTetIndices.getAddress(), meshFormat.value, numberOfTetsPerHexElement);
        PxTetrahedronMeshDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxTetrahedronMeshDesc(long address, long meshVertices, long meshTetIndices, int meshFormat, short numberOfTetsPerHexElement);

    // Constructors

    /**
     * Constructor to build an empty tetmesh description
     */
    public PxTetrahedronMeshDesc() {
        address = _PxTetrahedronMeshDesc();
    }
    private static native long _PxTetrahedronMeshDesc();

    /**
     * Constructor to build a tetmeshdescription that links to the vertices and indices provided
     */
    public PxTetrahedronMeshDesc(PxArray_PxVec3 meshVertices, PxArray_PxU32 meshTetIndices) {
        address = _PxTetrahedronMeshDesc(meshVertices.getAddress(), meshTetIndices.getAddress());
    }
    private static native long _PxTetrahedronMeshDesc(long meshVertices, long meshTetIndices);

    /**
     * Constructor to build a tetmeshdescription that links to the vertices and indices provided
     */
    public PxTetrahedronMeshDesc(PxArray_PxVec3 meshVertices, PxArray_PxU32 meshTetIndices, PxTetrahedronMeshFormatEnum meshFormat) {
        address = _PxTetrahedronMeshDesc(meshVertices.getAddress(), meshTetIndices.getAddress(), meshFormat.value);
    }
    private static native long _PxTetrahedronMeshDesc(long meshVertices, long meshTetIndices, int meshFormat);

    /**
     * Constructor to build a tetmeshdescription that links to the vertices and indices provided
     */
    public PxTetrahedronMeshDesc(PxArray_PxVec3 meshVertices, PxArray_PxU32 meshTetIndices, PxTetrahedronMeshFormatEnum meshFormat, short numberOfTetsPerHexElement) {
        address = _PxTetrahedronMeshDesc(meshVertices.getAddress(), meshTetIndices.getAddress(), meshFormat.value, numberOfTetsPerHexElement);
    }
    private static native long _PxTetrahedronMeshDesc(long meshVertices, long meshTetIndices, int meshFormat, short numberOfTetsPerHexElement);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * Optional pointer to first material index, or NULL. There are PxTetrahedronMesh::numTriangles indices in total.
     * Caller may add materialIndexStride bytes to the pointer to access the next triangle.
     * <p>
     * When a tetrahedron mesh collides with another object, a material is required at the collision point.
     * If materialIndices is NULL, then the material of the PxShape instance is used.
     * Otherwise, if the point of contact is on a tetrahedron with index i, then the material index is determined as:
     * PxFEMMaterialTableIndex index = *(PxFEMMaterialTableIndex *)(((PxU8*)materialIndices) + materialIndexStride * i);
     * <p>
     * If the contact point falls on a vertex or an edge, a tetrahedron adjacent to the vertex or edge is selected, and its index
     * used to look up a material. The selection is arbitrary but consistent over time.
     * <p>
     * <b>Default:</b> NULL
     */
    public PxTypedStridedData_PxU16 getMaterialIndices() {
        checkNotNull();
        return PxTypedStridedData_PxU16.wrapPointer(_getMaterialIndices(address));
    }
    private static native long _getMaterialIndices(long address);

    /**
     * Optional pointer to first material index, or NULL. There are PxTetrahedronMesh::numTriangles indices in total.
     * Caller may add materialIndexStride bytes to the pointer to access the next triangle.
     * <p>
     * When a tetrahedron mesh collides with another object, a material is required at the collision point.
     * If materialIndices is NULL, then the material of the PxShape instance is used.
     * Otherwise, if the point of contact is on a tetrahedron with index i, then the material index is determined as:
     * PxFEMMaterialTableIndex index = *(PxFEMMaterialTableIndex *)(((PxU8*)materialIndices) + materialIndexStride * i);
     * <p>
     * If the contact point falls on a vertex or an edge, a tetrahedron adjacent to the vertex or edge is selected, and its index
     * used to look up a material. The selection is arbitrary but consistent over time.
     * <p>
     * <b>Default:</b> NULL
     */
    public void setMaterialIndices(PxTypedStridedData_PxU16 value) {
        checkNotNull();
        _setMaterialIndices(address, value.getAddress());
    }
    private static native void _setMaterialIndices(long address, long value);

    /**
     * Pointer to first vertex point.
     */
    public PxBoundedData getPoints() {
        checkNotNull();
        return PxBoundedData.wrapPointer(_getPoints(address));
    }
    private static native long _getPoints(long address);

    /**
     * Pointer to first vertex point.
     */
    public void setPoints(PxBoundedData value) {
        checkNotNull();
        _setPoints(address, value.getAddress());
    }
    private static native void _setPoints(long address, long value);

    /**
     * Pointer to first tetrahedron.
     * <p>
     * Caller may add tetrhedronStrideBytes bytes to the pointer to access the next tetrahedron.
     * <p>
     * These are quadruplets of 0 based indices:
     * vert0 vert1 vert2 vert3
     * vert0 vert1 vert2 vert3
     * vert0 vert1 vert2 vert3
     * ...
     * <p>
     * where vertex is either a 32 or 16 bit unsigned integer. There are numTetrahedrons*4 indices.
     * <p>
     * This is declared as a void pointer because it is actually either an PxU16 or a PxU32 pointer.
     */
    public PxBoundedData getTetrahedrons() {
        checkNotNull();
        return PxBoundedData.wrapPointer(_getTetrahedrons(address));
    }
    private static native long _getTetrahedrons(long address);

    /**
     * Pointer to first tetrahedron.
     * <p>
     * Caller may add tetrhedronStrideBytes bytes to the pointer to access the next tetrahedron.
     * <p>
     * These are quadruplets of 0 based indices:
     * vert0 vert1 vert2 vert3
     * vert0 vert1 vert2 vert3
     * vert0 vert1 vert2 vert3
     * ...
     * <p>
     * where vertex is either a 32 or 16 bit unsigned integer. There are numTetrahedrons*4 indices.
     * <p>
     * This is declared as a void pointer because it is actually either an PxU16 or a PxU32 pointer.
     */
    public void setTetrahedrons(PxBoundedData value) {
        checkNotNull();
        _setTetrahedrons(address, value.getAddress());
    }
    private static native void _setTetrahedrons(long address, long value);

    /**
     * Flags bits, combined from values of the enum ::PxMeshFlag
     */
    public PxMeshFlags getFlags() {
        checkNotNull();
        return PxMeshFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * Flags bits, combined from values of the enum ::PxMeshFlag
     */
    public void setFlags(PxMeshFlags value) {
        checkNotNull();
        _setFlags(address, value.getAddress());
    }
    private static native void _setFlags(long address, long value);

    /**
     * Used for simulation meshes only. Defines if this tet mesh should be simulated as a tet mesh,
     * or if a set of tetrahedra should be used to represent another shape, e.g. a hexahedral mesh constructed 
     * from 6 elements.
     */
    public short getTetsPerElement() {
        checkNotNull();
        return _getTetsPerElement(address);
    }
    private static native short _getTetsPerElement(long address);

    /**
     * Used for simulation meshes only. Defines if this tet mesh should be simulated as a tet mesh,
     * or if a set of tetrahedra should be used to represent another shape, e.g. a hexahedral mesh constructed 
     * from 6 elements.
     */
    public void setTetsPerElement(short value) {
        checkNotNull();
        _setTetsPerElement(address, value);
    }
    private static native void _setTetsPerElement(long address, short value);

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
