package physx.geometry;

import physx.PlatformChecks;
import physx.common.PxBounds3;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.extensions.PxMassProperties;
import physx.physics.PxGeomRaycastHit;
import physx.physics.PxGeomSweepHit;
import physx.physics.PxHitFlags;

public class SimpleCustomGeometryCallbacksImpl extends SimpleCustomGeometryCallbacks {

    static {
        PlatformChecks.requirePlatform(15, "physx.geometry.SimpleCustomGeometryCallbacksImpl");
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static SimpleCustomGeometryCallbacksImpl wrapPointer(long address) {
        return address != 0L ? new SimpleCustomGeometryCallbacksImpl(address) : null;
    }
    
    public static SimpleCustomGeometryCallbacksImpl arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected SimpleCustomGeometryCallbacksImpl(long address) {
        super(address);
    }

    protected SimpleCustomGeometryCallbacksImpl() {
        address = _SimpleCustomGeometryCallbacksImpl();
    }
    private native long _SimpleCustomGeometryCallbacksImpl();
    
    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /*
     * Called from native code
     */
    private long _getLocalBoundsImpl(long geometry) {
        return getLocalBoundsImpl(PxGeometry.wrapPointer(geometry)).getAddress();
    }

    /**
     * @param geometry WebIDL type: {@link PxGeometry} [Const, Ref]
     * @return WebIDL type: {@link PxBounds3}
     */
    public PxBounds3 getLocalBoundsImpl(PxGeometry geometry) {
        return null;
    }

    /*
     * Called from native code
     */
    private boolean _generateContactsImpl(long geom0, long geom1, long pose0, long pose1, float contactDistance, float meshContactMargin, float toleranceLength, long contactBuffer) {
        return generateContactsImpl(PxGeometry.wrapPointer(geom0), PxGeometry.wrapPointer(geom1), PxTransform.wrapPointer(pose0), PxTransform.wrapPointer(pose1), contactDistance, meshContactMargin, toleranceLength, PxContactBuffer.wrapPointer(contactBuffer));
    }

    /**
     * @param geom0             WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param geom1             WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose0             WebIDL type: {@link PxTransform} [Const, Ref]
     * @param pose1             WebIDL type: {@link PxTransform} [Const, Ref]
     * @param contactDistance   WebIDL type: float
     * @param meshContactMargin WebIDL type: float
     * @param toleranceLength   WebIDL type: float
     * @param contactBuffer     WebIDL type: {@link PxContactBuffer} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean generateContactsImpl(PxGeometry geom0, PxGeometry geom1, PxTransform pose0, PxTransform pose1, float contactDistance, float meshContactMargin, float toleranceLength, PxContactBuffer contactBuffer) {
        return false;
    }

    /*
     * Called from native code
     */
    private int _raycastImpl(long origin, long unitDir, long geom, long pose, float maxDist, long hitFlags, int maxHits, long rayHits, int stride) {
        return raycastImpl(PxVec3.wrapPointer(origin), PxVec3.wrapPointer(unitDir), PxGeometry.wrapPointer(geom), PxTransform.wrapPointer(pose), maxDist, PxHitFlags.wrapPointer(hitFlags), maxHits, PxGeomRaycastHit.wrapPointer(rayHits), stride);
    }

    /**
     * @param origin   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param unitDir  WebIDL type: {@link PxVec3} [Const, Ref]
     * @param geom     WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose     WebIDL type: {@link PxTransform} [Const, Ref]
     * @param maxDist  WebIDL type: float
     * @param hitFlags WebIDL type: {@link PxHitFlags} [Ref]
     * @param maxHits  WebIDL type: unsigned long
     * @param rayHits  WebIDL type: {@link PxGeomRaycastHit}
     * @param stride   WebIDL type: unsigned long
     * @return WebIDL type: unsigned long
     */
    public int raycastImpl(PxVec3 origin, PxVec3 unitDir, PxGeometry geom, PxTransform pose, float maxDist, PxHitFlags hitFlags, int maxHits, PxGeomRaycastHit rayHits, int stride) {
        return 0;
    }

    /*
     * Called from native code
     */
    private boolean _overlapImpl(long geom0, long pose0, long geom1, long pose1) {
        return overlapImpl(PxGeometry.wrapPointer(geom0), PxTransform.wrapPointer(pose0), PxGeometry.wrapPointer(geom1), PxTransform.wrapPointer(pose1));
    }

    /**
     * @param geom0 WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose0 WebIDL type: {@link PxTransform} [Const, Ref]
     * @param geom1 WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose1 WebIDL type: {@link PxTransform} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean overlapImpl(PxGeometry geom0, PxTransform pose0, PxGeometry geom1, PxTransform pose1) {
        return false;
    }

    /*
     * Called from native code
     */
    private boolean _sweepImpl(long unitDir, float maxDist, long geom0, long pose0, long geom1, long pose1, long sweepHit, long hitFlags, float inflation) {
        return sweepImpl(PxVec3.wrapPointer(unitDir), maxDist, PxGeometry.wrapPointer(geom0), PxTransform.wrapPointer(pose0), PxGeometry.wrapPointer(geom1), PxTransform.wrapPointer(pose1), PxGeomSweepHit.wrapPointer(sweepHit), PxHitFlags.wrapPointer(hitFlags), inflation);
    }

    /**
     * @param unitDir   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param maxDist   WebIDL type: float
     * @param geom0     WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose0     WebIDL type: {@link PxTransform} [Const, Ref]
     * @param geom1     WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose1     WebIDL type: {@link PxTransform} [Const, Ref]
     * @param sweepHit  WebIDL type: {@link PxGeomSweepHit} [Ref]
     * @param hitFlags  WebIDL type: {@link PxHitFlags} [Ref]
     * @param inflation WebIDL type: float
     * @return WebIDL type: boolean
     */
    public boolean sweepImpl(PxVec3 unitDir, float maxDist, PxGeometry geom0, PxTransform pose0, PxGeometry geom1, PxTransform pose1, PxGeomSweepHit sweepHit, PxHitFlags hitFlags, float inflation) {
        return false;
    }

    /*
     * Called from native code
     */
    private void _computeMassPropertiesImpl(long geometry, long massProperties) {
        computeMassPropertiesImpl(PxGeometry.wrapPointer(geometry), PxMassProperties.wrapPointer(massProperties));
    }

    /**
     * @param geometry       WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param massProperties WebIDL type: {@link PxMassProperties} [Ref]
     */
    public void computeMassPropertiesImpl(PxGeometry geometry, PxMassProperties massProperties) { }

    /*
     * Called from native code
     */
    private boolean _usePersistentContactManifoldImpl(long geometry) {
        return usePersistentContactManifoldImpl(PxGeometry.wrapPointer(geometry));
    }

    /**
     * @param geometry WebIDL type: {@link PxGeometry} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean usePersistentContactManifoldImpl(PxGeometry geometry) {
        return false;
    }

}
