package physx.particles;

import physx.PlatformChecks;

/**
 * Structure to define user-defined particle state when constructing a new particle system that includes diffuse particles.
 */
public class PxParticleAndDiffuseBufferDesc extends PxParticleBufferDesc {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxParticleAndDiffuseBufferDesc");
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleAndDiffuseBufferDesc wrapPointer(long address) {
        return address != 0L ? new PxParticleAndDiffuseBufferDesc(address) : null;
    }
    
    public static PxParticleAndDiffuseBufferDesc arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleAndDiffuseBufferDesc(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxParticleAndDiffuseBufferDesc
     */
    public static PxParticleAndDiffuseBufferDesc createAt(long address) {
        __placement_new_PxParticleAndDiffuseBufferDesc(address);
        PxParticleAndDiffuseBufferDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxParticleAndDiffuseBufferDesc
     */
    public static <T> PxParticleAndDiffuseBufferDesc createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxParticleAndDiffuseBufferDesc(address);
        PxParticleAndDiffuseBufferDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxParticleAndDiffuseBufferDesc(long address);

    // Constructors

    public PxParticleAndDiffuseBufferDesc() {
        address = _PxParticleAndDiffuseBufferDesc();
    }
    private static native long _PxParticleAndDiffuseBufferDesc();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     */
    public PxDiffuseParticleParams getDiffuseParams() {
        checkNotNull();
        return PxDiffuseParticleParams.wrapPointer(_getDiffuseParams(address));
    }
    private static native long _getDiffuseParams(long address);

    /**
     */
    public void setDiffuseParams(PxDiffuseParticleParams value) {
        checkNotNull();
        _setDiffuseParams(address, value.getAddress());
    }
    private static native void _setDiffuseParams(long address, long value);

    /**
     */
    public int getMaxDiffuseParticles() {
        checkNotNull();
        return _getMaxDiffuseParticles(address);
    }
    private static native int _getMaxDiffuseParticles(long address);

    /**
     */
    public void setMaxDiffuseParticles(int value) {
        checkNotNull();
        _setMaxDiffuseParticles(address, value);
    }
    private static native void _setMaxDiffuseParticles(long address, int value);

    /**
     */
    public int getMaxActiveDiffuseParticles() {
        checkNotNull();
        return _getMaxActiveDiffuseParticles(address);
    }
    private static native int _getMaxActiveDiffuseParticles(long address);

    /**
     */
    public void setMaxActiveDiffuseParticles(int value) {
        checkNotNull();
        _setMaxActiveDiffuseParticles(address, value);
    }
    private static native void _setMaxActiveDiffuseParticles(long address, int value);

}
