package physx.particles;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.common.PxVec4;
import physx.support.PxU32Ptr;

/**
 * Structure to describe the set of particle cloths in the same #PxParticleClothBuffer. Used an input for the cloth preprocessing.
 */
public class PxParticleClothDesc extends NativeObject {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxParticleClothDesc");
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleClothDesc wrapPointer(long address) {
        return address != 0L ? new PxParticleClothDesc(address) : null;
    }
    
    public static PxParticleClothDesc arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleClothDesc(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxParticleClothDesc
     */
    public static PxParticleClothDesc createAt(long address) {
        __placement_new_PxParticleClothDesc(address);
        PxParticleClothDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxParticleClothDesc
     */
    public static <T> PxParticleClothDesc createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxParticleClothDesc(address);
        PxParticleClothDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxParticleClothDesc(long address);

    // Constructors

    public PxParticleClothDesc() {
        address = _PxParticleClothDesc();
    }
    private static native long _PxParticleClothDesc();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * List of PxParticleCloth s, describes the individual cloths.
     */
    public PxParticleCloth getCloths() {
        checkNotNull();
        return PxParticleCloth.wrapPointer(_getCloths(address));
    }
    private static native long _getCloths(long address);

    /**
     * List of PxParticleCloth s, describes the individual cloths.
     */
    public void setCloths(PxParticleCloth value) {
        checkNotNull();
        _setCloths(address, value.getAddress());
    }
    private static native void _setCloths(long address, long value);

    /**
     * List of triangle indices, 3 consecutive PxU32 that map triangle vertices to particles
     */
    public PxU32Ptr getTriangles() {
        checkNotNull();
        return PxU32Ptr.wrapPointer(_getTriangles(address));
    }
    private static native long _getTriangles(long address);

    /**
     * List of triangle indices, 3 consecutive PxU32 that map triangle vertices to particles
     */
    public void setTriangles(PxU32Ptr value) {
        checkNotNull();
        _setTriangles(address, value.getAddress());
    }
    private static native void _setTriangles(long address, long value);

    /**
     * List of PxParticleSpring s.
     */
    public PxParticleSpring getSprings() {
        checkNotNull();
        return PxParticleSpring.wrapPointer(_getSprings(address));
    }
    private static native long _getSprings(long address);

    /**
     * List of PxParticleSpring s.
     */
    public void setSprings(PxParticleSpring value) {
        checkNotNull();
        _setSprings(address, value.getAddress());
    }
    private static native void _setSprings(long address, long value);

    /**
     * List of rest positions for all particles
     */
    public PxVec4 getRestPositions() {
        checkNotNull();
        return PxVec4.wrapPointer(_getRestPositions(address));
    }
    private static native long _getRestPositions(long address);

    /**
     * List of rest positions for all particles
     */
    public void setRestPositions(PxVec4 value) {
        checkNotNull();
        _setRestPositions(address, value.getAddress());
    }
    private static native void _setRestPositions(long address, long value);

    /**
     * The number of cloths in described using this cloth descriptor
     */
    public int getNbCloths() {
        checkNotNull();
        return _getNbCloths(address);
    }
    private static native int _getNbCloths(long address);

    /**
     * The number of cloths in described using this cloth descriptor
     */
    public void setNbCloths(int value) {
        checkNotNull();
        _setNbCloths(address, value);
    }
    private static native void _setNbCloths(long address, int value);

    /**
     * The number of springs in this cloth descriptor
     */
    public int getNbSprings() {
        checkNotNull();
        return _getNbSprings(address);
    }
    private static native int _getNbSprings(long address);

    /**
     * The number of springs in this cloth descriptor
     */
    public void setNbSprings(int value) {
        checkNotNull();
        _setNbSprings(address, value);
    }
    private static native void _setNbSprings(long address, int value);

    /**
     * The number of triangles in this cloth descriptor
     */
    public int getNbTriangles() {
        checkNotNull();
        return _getNbTriangles(address);
    }
    private static native int _getNbTriangles(long address);

    /**
     * The number of triangles in this cloth descriptor
     */
    public void setNbTriangles(int value) {
        checkNotNull();
        _setNbTriangles(address, value);
    }
    private static native void _setNbTriangles(long address, int value);

    /**
     * The number of particles in this cloth descriptor
     */
    public int getNbParticles() {
        checkNotNull();
        return _getNbParticles(address);
    }
    private static native int _getNbParticles(long address);

    /**
     * The number of particles in this cloth descriptor
     */
    public void setNbParticles(int value) {
        checkNotNull();
        _setNbParticles(address, value);
    }
    private static native void _setNbParticles(long address, int value);

}
