package physx.particles;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.common.PxCudaContextManager;
import physx.support.PxU32Ptr;

public class PxPartitionedParticleCloth extends NativeObject {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxPartitionedParticleCloth");
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxPartitionedParticleCloth wrapPointer(long address) {
        return address != 0L ? new PxPartitionedParticleCloth(address) : null;
    }
    
    public static PxPartitionedParticleCloth arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxPartitionedParticleCloth(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxPartitionedParticleCloth
     */
    public static PxPartitionedParticleCloth createAt(long address) {
        __placement_new_PxPartitionedParticleCloth(address);
        PxPartitionedParticleCloth createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxPartitionedParticleCloth
     */
    public static <T> PxPartitionedParticleCloth createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxPartitionedParticleCloth(address);
        PxPartitionedParticleCloth createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxPartitionedParticleCloth(long address);

    // Constructors

    public PxPartitionedParticleCloth() {
        address = _PxPartitionedParticleCloth();
    }
    private static native long _PxPartitionedParticleCloth();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxU32Ptr} [Value]
     */
    public PxU32Ptr getAccumulatedSpringsPerPartitions() {
        checkNotNull();
        return PxU32Ptr.wrapPointer(_getAccumulatedSpringsPerPartitions(address));
    }
    private static native long _getAccumulatedSpringsPerPartitions(long address);

    /**
     * @param value WebIDL type: {@link PxU32Ptr} [Value]
     */
    public void setAccumulatedSpringsPerPartitions(PxU32Ptr value) {
        checkNotNull();
        _setAccumulatedSpringsPerPartitions(address, value.getAddress());
    }
    private static native void _setAccumulatedSpringsPerPartitions(long address, long value);

    /**
     * @return WebIDL type: {@link PxU32Ptr} [Value]
     */
    public PxU32Ptr getAccumulatedCopiesPerParticles() {
        checkNotNull();
        return PxU32Ptr.wrapPointer(_getAccumulatedCopiesPerParticles(address));
    }
    private static native long _getAccumulatedCopiesPerParticles(long address);

    /**
     * @param value WebIDL type: {@link PxU32Ptr} [Value]
     */
    public void setAccumulatedCopiesPerParticles(PxU32Ptr value) {
        checkNotNull();
        _setAccumulatedCopiesPerParticles(address, value.getAddress());
    }
    private static native void _setAccumulatedCopiesPerParticles(long address, long value);

    /**
     * @return WebIDL type: {@link PxU32Ptr} [Value]
     */
    public PxU32Ptr getRemapOutput() {
        checkNotNull();
        return PxU32Ptr.wrapPointer(_getRemapOutput(address));
    }
    private static native long _getRemapOutput(long address);

    /**
     * @param value WebIDL type: {@link PxU32Ptr} [Value]
     */
    public void setRemapOutput(PxU32Ptr value) {
        checkNotNull();
        _setRemapOutput(address, value.getAddress());
    }
    private static native void _setRemapOutput(long address, long value);

    /**
     * @return WebIDL type: {@link PxParticleSpring}
     */
    public PxParticleSpring getOrderedSprings() {
        checkNotNull();
        return PxParticleSpring.wrapPointer(_getOrderedSprings(address));
    }
    private static native long _getOrderedSprings(long address);

    /**
     * @param value WebIDL type: {@link PxParticleSpring}
     */
    public void setOrderedSprings(PxParticleSpring value) {
        checkNotNull();
        _setOrderedSprings(address, value.getAddress());
    }
    private static native void _setOrderedSprings(long address, long value);

    /**
     * @return WebIDL type: {@link PxU32Ptr} [Value]
     */
    public PxU32Ptr getSortedClothStartIndices() {
        checkNotNull();
        return PxU32Ptr.wrapPointer(_getSortedClothStartIndices(address));
    }
    private static native long _getSortedClothStartIndices(long address);

    /**
     * @param value WebIDL type: {@link PxU32Ptr} [Value]
     */
    public void setSortedClothStartIndices(PxU32Ptr value) {
        checkNotNull();
        _setSortedClothStartIndices(address, value.getAddress());
    }
    private static native void _setSortedClothStartIndices(long address, long value);

    /**
     * @return WebIDL type: {@link PxParticleCloth}
     */
    public PxParticleCloth getCloths() {
        checkNotNull();
        return PxParticleCloth.wrapPointer(_getCloths(address));
    }
    private static native long _getCloths(long address);

    /**
     * @param value WebIDL type: {@link PxParticleCloth}
     */
    public void setCloths(PxParticleCloth value) {
        checkNotNull();
        _setCloths(address, value.getAddress());
    }
    private static native void _setCloths(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getRemapOutputSize() {
        checkNotNull();
        return _getRemapOutputSize(address);
    }
    private static native int _getRemapOutputSize(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setRemapOutputSize(int value) {
        checkNotNull();
        _setRemapOutputSize(address, value);
    }
    private static native void _setRemapOutputSize(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbPartitions() {
        checkNotNull();
        return _getNbPartitions(address);
    }
    private static native int _getNbPartitions(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbPartitions(int value) {
        checkNotNull();
        _setNbPartitions(address, value);
    }
    private static native void _setNbPartitions(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbSprings() {
        checkNotNull();
        return _getNbSprings(address);
    }
    private static native int _getNbSprings(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbSprings(int value) {
        checkNotNull();
        _setNbSprings(address, value);
    }
    private static native void _setNbSprings(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbCloths() {
        checkNotNull();
        return _getNbCloths(address);
    }
    private static native int _getNbCloths(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbCloths(int value) {
        checkNotNull();
        _setNbCloths(address, value);
    }
    private static native void _setNbCloths(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxSpringsPerPartition() {
        checkNotNull();
        return _getMaxSpringsPerPartition(address);
    }
    private static native int _getMaxSpringsPerPartition(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMaxSpringsPerPartition(int value) {
        checkNotNull();
        _setMaxSpringsPerPartition(address, value);
    }
    private static native void _setMaxSpringsPerPartition(long address, int value);

    /**
     * @return WebIDL type: {@link PxCudaContextManager}
     */
    public PxCudaContextManager getMCudaManager() {
        checkNotNull();
        return PxCudaContextManager.wrapPointer(_getMCudaManager(address));
    }
    private static native long _getMCudaManager(long address);

    /**
     * @param value WebIDL type: {@link PxCudaContextManager}
     */
    public void setMCudaManager(PxCudaContextManager value) {
        checkNotNull();
        _setMCudaManager(address, value.getAddress());
    }
    private static native void _setMCudaManager(long address, long value);

    // Functions

    /**
     * @param nbParticles WebIDL type: unsigned long
     * @param cudaManager WebIDL type: {@link PxCudaContextManager}
     */
    public void allocateBuffers(int nbParticles, PxCudaContextManager cudaManager) {
        checkNotNull();
        _allocateBuffers(address, nbParticles, cudaManager.getAddress());
    }
    private static native void _allocateBuffers(long address, int nbParticles, long cudaManager);

}
