package physx.physics;

/**
 * Identifies each type of actor for retrieving actors from a scene.
 * <p>
 * <b>Note:</b> #PxArticulationLink objects are not supported. Use the #PxArticulationReducedCoordinate object to retrieve all its links.
 * <p>
 * <b>See also:</b> PxScene::getActors(), PxScene::getNbActors()
 */
public enum PxActorTypeFlagEnum {

    /**
     * A static rigid body
     * <b>See also:</b> PxRigidStatic
     */
    eRIGID_STATIC(geteRIGID_STATIC()),
    /**
     * A dynamic rigid body
     * <b>See also:</b> PxRigidDynamic
     */
    eRIGID_DYNAMIC(geteRIGID_DYNAMIC());
    public final int value;
    
    PxActorTypeFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteRIGID_STATIC();
    private static int geteRIGID_STATIC() {
        de.fabmax.physxjni.Loader.load();
        return _geteRIGID_STATIC();
    }

    private static native int _geteRIGID_DYNAMIC();
    private static int geteRIGID_DYNAMIC() {
        de.fabmax.physxjni.Loader.load();
        return _geteRIGID_DYNAMIC();
    }

    public static PxActorTypeFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxActorTypeFlagEnum: " + value);
    }

}
