package physx.physics;

import physx.NativeObject;

public class PxArticulationCacheFlags extends NativeObject {

    protected PxArticulationCacheFlags() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArticulationCacheFlags wrapPointer(long address) {
        return address != 0L ? new PxArticulationCacheFlags(address) : null;
    }
    
    public static PxArticulationCacheFlags arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArticulationCacheFlags(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param flags   WebIDL type: unsigned long
     * @return Stack allocated object of PxArticulationCacheFlags
     */
    public static PxArticulationCacheFlags createAt(long address, int flags) {
        __placement_new_PxArticulationCacheFlags(address, flags);
        PxArticulationCacheFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param flags     WebIDL type: unsigned long
     * @return Stack allocated object of PxArticulationCacheFlags
     */
    public static <T> PxArticulationCacheFlags createAt(T allocator, Allocator<T> allocate, int flags) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxArticulationCacheFlags(address, flags);
        PxArticulationCacheFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxArticulationCacheFlags(long address, int flags);

    // Constructors

    /**
     * @param flags WebIDL type: unsigned long
     */
    public PxArticulationCacheFlags(int flags) {
        address = _PxArticulationCacheFlags(flags);
    }
    private static native long _PxArticulationCacheFlags(int flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag WebIDL type: {@link PxArticulationCacheFlagEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean isSet(PxArticulationCacheFlagEnum flag) {
        checkNotNull();
        return _isSet(address, flag.value);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxArticulationCacheFlagEnum} [enum]
     */
    public void raise(PxArticulationCacheFlagEnum flag) {
        checkNotNull();
        _raise(address, flag.value);
    }
    private static native void _raise(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxArticulationCacheFlagEnum} [enum]
     */
    public void clear(PxArticulationCacheFlagEnum flag) {
        checkNotNull();
        _clear(address, flag.value);
    }
    private static native void _clear(long address, int flag);

}
