package physx.physics;

import physx.NativeObject;

/**
 * Data structure to set articulation joint limits.
 * <p>
 * - The lower limit should be strictly smaller than the higher limit. If the limits should be equal, use PxArticulationMotion::eLOCKED
 * and an appropriate offset in the parent/child joint frames.
 * - The limit units are linear units (equivalent to scene units) for a translational axis, or radians for a rotational axis.
 * @see PxArticulationReducedCoordinate
 */
public class PxArticulationLimit extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArticulationLimit wrapPointer(long address) {
        return address != 0L ? new PxArticulationLimit(address) : null;
    }
    
    public static PxArticulationLimit arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArticulationLimit(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxArticulationLimit
     */
    public static PxArticulationLimit createAt(long address) {
        __placement_new_PxArticulationLimit(address);
        PxArticulationLimit createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxArticulationLimit
     */
    public static <T> PxArticulationLimit createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxArticulationLimit(address);
        PxArticulationLimit createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxArticulationLimit(long address);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param low     WebIDL type: float
     * @param high    WebIDL type: float
     * @return Stack allocated object of PxArticulationLimit
     */
    public static PxArticulationLimit createAt(long address, float low, float high) {
        __placement_new_PxArticulationLimit(address, low, high);
        PxArticulationLimit createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param low       WebIDL type: float
     * @param high      WebIDL type: float
     * @return Stack allocated object of PxArticulationLimit
     */
    public static <T> PxArticulationLimit createAt(T allocator, Allocator<T> allocate, float low, float high) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxArticulationLimit(address, low, high);
        PxArticulationLimit createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxArticulationLimit(long address, float low, float high);

    // Constructors

    public PxArticulationLimit() {
        address = _PxArticulationLimit();
    }
    private static native long _PxArticulationLimit();

    /**
     * @param low  WebIDL type: float
     * @param high WebIDL type: float
     */
    public PxArticulationLimit(float low, float high) {
        address = _PxArticulationLimit(low, high);
    }
    private static native long _PxArticulationLimit(float low, float high);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * The lower limit on the joint axis position.
     * <p>
     * <b>Range:</b> [-PX_MAX_F32, high)<br>
     * <b>Default:</b> 0.0f<br>
     */
    public float getLow() {
        checkNotNull();
        return _getLow(address);
    }
    private static native float _getLow(long address);

    /**
     * The lower limit on the joint axis position.
     * <p>
     * <b>Range:</b> [-PX_MAX_F32, high)<br>
     * <b>Default:</b> 0.0f<br>
     */
    public void setLow(float value) {
        checkNotNull();
        _setLow(address, value);
    }
    private static native void _setLow(long address, float value);

    /**
     * The higher limit on the joint axis position.
     * <p>
     * <b>Range:</b> (low, PX_MAX_F32]<br>
     * <b>Default:</b> 0.0f<br>
     */
    public float getHigh() {
        checkNotNull();
        return _getHigh(address);
    }
    private static native float _getHigh(long address);

    /**
     * The higher limit on the joint axis position.
     * <p>
     * <b>Range:</b> (low, PX_MAX_F32]<br>
     * <b>Default:</b> 0.0f<br>
     */
    public void setHigh(float value) {
        checkNotNull();
        _setHigh(address, value);
    }
    private static native void _setHigh(long address, float value);

}
