package physx.physics;


public class PxRaycastBuffer10 extends PxRaycastCallback {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxRaycastBuffer10 wrapPointer(long address) {
        return address != 0L ? new PxRaycastBuffer10(address) : null;
    }
    
    public static PxRaycastBuffer10 arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxRaycastBuffer10(long address) {
        super(address);
    }

    // Constructors

    public PxRaycastBuffer10() {
        address = _PxRaycastBuffer10();
    }
    private static native long _PxRaycastBuffer10();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxRaycastHit} [Value]
     */
    public PxRaycastHit getBlock() {
        checkNotNull();
        return PxRaycastHit.wrapPointer(_getBlock(address));
    }
    private static native long _getBlock(long address);

    /**
     * @param value WebIDL type: {@link PxRaycastHit} [Value]
     */
    public void setBlock(PxRaycastHit value) {
        checkNotNull();
        _setBlock(address, value.getAddress());
    }
    private static native void _setBlock(long address, long value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getHasBlock() {
        checkNotNull();
        return _getHasBlock(address);
    }
    private static native boolean _getHasBlock(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setHasBlock(boolean value) {
        checkNotNull();
        _setHasBlock(address, value);
    }
    private static native void _setHasBlock(long address, boolean value);

    // Functions

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbAnyHits() {
        checkNotNull();
        return _getNbAnyHits(address);
    }
    private static native int _getNbAnyHits(long address);

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: {@link PxRaycastHit} [Const, Ref]
     */
    public PxRaycastHit getAnyHit(int index) {
        checkNotNull();
        return PxRaycastHit.wrapPointer(_getAnyHit(address, index));
    }
    private static native long _getAnyHit(long address, int index);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbTouches() {
        checkNotNull();
        return _getNbTouches(address);
    }
    private static native int _getNbTouches(long address);

    /**
     * @return WebIDL type: {@link PxRaycastHit} [Const]
     */
    public PxRaycastHit getTouches() {
        checkNotNull();
        return PxRaycastHit.wrapPointer(_getTouches(address));
    }
    private static native long _getTouches(long address);

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: {@link PxRaycastHit} [Const, Ref]
     */
    public PxRaycastHit getTouch(int index) {
        checkNotNull();
        return PxRaycastHit.wrapPointer(_getTouch(address, index));
    }
    private static native long _getTouch(long address, int index);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxNbTouches() {
        checkNotNull();
        return _getMaxNbTouches(address);
    }
    private static native int _getMaxNbTouches(long address);

}
