package physx.physics;


public class SimpleQueryFilterCallback extends PxQueryFilterCallback {

    protected SimpleQueryFilterCallback() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static SimpleQueryFilterCallback wrapPointer(long address) {
        return address != 0L ? new SimpleQueryFilterCallback(address) : null;
    }
    
    public static SimpleQueryFilterCallback arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected SimpleQueryFilterCallback(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param filterData WebIDL type: {@link PxFilterData} [Const, Ref]
     * @param shape      WebIDL type: {@link PxShape} [Const]
     * @param actor      WebIDL type: {@link PxRigidActor} [Const]
     * @param queryFlags WebIDL type: {@link PxHitFlags} [Ref]
     * @return WebIDL type: unsigned long
     */
    public int simplePreFilter(PxFilterData filterData, PxShape shape, PxRigidActor actor, PxHitFlags queryFlags) {
        checkNotNull();
        return _simplePreFilter(address, filterData.getAddress(), shape.getAddress(), actor.getAddress(), queryFlags.getAddress());
    }
    private static native int _simplePreFilter(long address, long filterData, long shape, long actor, long queryFlags);

    /**
     * @param filterData WebIDL type: {@link PxFilterData} [Const, Ref]
     * @param hit        WebIDL type: {@link PxQueryHit} [Const, Ref]
     * @param shape      WebIDL type: {@link PxShape} [Const]
     * @param actor      WebIDL type: {@link PxRigidActor} [Const]
     * @return WebIDL type: unsigned long
     */
    public int simplePostFilter(PxFilterData filterData, PxQueryHit hit, PxShape shape, PxRigidActor actor) {
        checkNotNull();
        return _simplePostFilter(address, filterData.getAddress(), hit.getAddress(), shape.getAddress(), actor.getAddress());
    }
    private static native int _simplePostFilter(long address, long filterData, long hit, long shape, long actor);

}
