package physx.support;

import physx.NativeObject;
import physx.geometry.PxHeightFieldSample;

public class PxArray_PxHeightFieldSample extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArray_PxHeightFieldSample wrapPointer(long address) {
        return address != 0L ? new PxArray_PxHeightFieldSample(address) : null;
    }
    
    public static PxArray_PxHeightFieldSample arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArray_PxHeightFieldSample(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxArray_PxHeightFieldSample
     */
    public static PxArray_PxHeightFieldSample createAt(long address) {
        __placement_new_PxArray_PxHeightFieldSample(address);
        PxArray_PxHeightFieldSample createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxArray_PxHeightFieldSample
     */
    public static <T> PxArray_PxHeightFieldSample createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxArray_PxHeightFieldSample(address);
        PxArray_PxHeightFieldSample createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxArray_PxHeightFieldSample(long address);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param size    WebIDL type: unsigned long
     * @return Stack allocated object of PxArray_PxHeightFieldSample
     */
    public static PxArray_PxHeightFieldSample createAt(long address, int size) {
        __placement_new_PxArray_PxHeightFieldSample(address, size);
        PxArray_PxHeightFieldSample createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param size      WebIDL type: unsigned long
     * @return Stack allocated object of PxArray_PxHeightFieldSample
     */
    public static <T> PxArray_PxHeightFieldSample createAt(T allocator, Allocator<T> allocate, int size) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxArray_PxHeightFieldSample(address, size);
        PxArray_PxHeightFieldSample createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxArray_PxHeightFieldSample(long address, int size);

    // Constructors

    public PxArray_PxHeightFieldSample() {
        address = _PxArray_PxHeightFieldSample();
    }
    private static native long _PxArray_PxHeightFieldSample();

    /**
     * @param size WebIDL type: unsigned long
     */
    public PxArray_PxHeightFieldSample(int size) {
        address = _PxArray_PxHeightFieldSample(size);
    }
    private static native long _PxArray_PxHeightFieldSample(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: {@link PxHeightFieldSample} [Ref]
     */
    public PxHeightFieldSample get(int index) {
        checkNotNull();
        return PxHeightFieldSample.wrapPointer(_get(address, index));
    }
    private static native long _get(long address, int index);

    /**
     * @param index WebIDL type: unsigned long
     * @param value WebIDL type: {@link PxHeightFieldSample} [Const, Ref]
     */
    public void set(int index, PxHeightFieldSample value) {
        checkNotNull();
        _set(address, index, value.getAddress());
    }
    private static native void _set(long address, int index, long value);

    /**
     * @return WebIDL type: {@link PxHeightFieldSample}
     */
    public PxHeightFieldSample begin() {
        checkNotNull();
        return PxHeightFieldSample.wrapPointer(_begin(address));
    }
    private static native long _begin(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int size() {
        checkNotNull();
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value WebIDL type: {@link PxHeightFieldSample} [Ref]
     */
    public void pushBack(PxHeightFieldSample value) {
        checkNotNull();
        _pushBack(address, value.getAddress());
    }
    private static native void _pushBack(long address, long value);

    public void clear() {
        checkNotNull();
        _clear(address);
    }
    private static native void _clear(long address);

}
